/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class IBContentProvider
extends AsyncTreeContentProvider {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private boolean fComputeIncludedBy = true;

    public IBContentProvider(Display disp) {
        super(disp);
    }

    public Object getParent(Object element) {
        if (element instanceof IBNode) {
            IBNode node = (IBNode)element;
            return node.getParent();
        }
        return super.getParent(element);
    }

    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        IBNode node;
        if (parentElement instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)parentElement;
            return new Object[]{new IBNode(null, new IBFile(tu), null, 0, 0, 0L)};
        }
        if (parentElement instanceof IBNode && ((node = (IBNode)parentElement).isRecursive() || node.getRepresentedIFL() == null)) {
            return NO_CHILDREN;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        block16: {
            if (parentElement instanceof IBNode == false) return IBContentProvider.NO_CHILDREN;
            node = (IBNode)parentElement;
            ifl = node.getRepresentedIFL();
            project = node.getCProject();
            if (ifl == null) {
                return IBContentProvider.NO_CHILDREN;
            }
            try {
                index = CCorePlugin.getIndexManager().getIndex(project, this.fComputeIncludedBy != false ? 2 : 1);
                index.acquireReadLock();
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
                return IBContentProvider.NO_CHILDREN;
            }
            catch (InterruptedException v0) {
                return IBContentProvider.NO_CHILDREN;
            }
            try {
                directiveFile = null;
                targetFile = null;
                if (this.fComputeIncludedBy) {
                    includes = this.findIncludedBy(index, ifl, IBContentProvider.NPM);
                } else {
                    includes = this.findIncludesTo(index, ifl, IBContentProvider.NPM);
                    directiveFile = node.getRepresentedFile();
                }
                if (includes.length > 0) {
                    result = new ArrayList<IBNode>(includes.length);
                    i = 0;
                    while (true) {
                        if (i >= includes.length) {
                            var16_16 = result.toArray();
                            var14_17 = null;
                            break block16;
                        }
                        include = includes[i];
                        try {
                            if (this.fComputeIncludedBy) {
                                directiveFile = targetFile = new IBFile(project, include.getIncludedByLocation());
                            } else {
                                includesPath = include.getIncludesLocation();
                                targetFile = includesPath == null ? new IBFile(include.getName()) : new IBFile(project, includesPath);
                            }
                            newnode = new IBNode(node, targetFile, directiveFile, include.getNameOffset(), include.getNameLength(), include.getIncludedBy().getTimestamp());
                            newnode.setIsActiveCode(include.isActive());
                            newnode.setIsSystemInclude(include.isSystemInclude());
                            result.add(newnode);
                        }
                        catch (CoreException e) {
                            CUIPlugin.getDefault().log(e);
                        }
                        ++i;
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var15_20) {
                var14_18 = null;
                index.releaseReadLock();
                throw var15_20;
            }
        }
        index.releaseReadLock();
        return var16_16;
lbl-1000:
        // 1 sources

        {
            var14_19 = null;
        }
        index.releaseReadLock();
        return IBContentProvider.NO_CHILDREN;
    }

    public void setComputeIncludedBy(boolean value) {
        this.fComputeIncludedBy = value;
    }

    public boolean getComputeIncludedBy() {
        return this.fComputeIncludedBy;
    }

    private IIndexInclude[] findIncludedBy(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            IIndexFile file;
            if (ifl != null && (file = index.getFile(ifl)) != null) {
                return index.findIncludedBy(file);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        return new IIndexInclude[0];
    }

    public IIndexInclude[] findIncludesTo(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            IIndexFile file;
            if (ifl != null && (file = index.getFile(ifl)) != null) {
                return index.findIncludes(file);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        return new IIndexInclude[0];
    }
}

