/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.ui.includebrowser.IBDropTargetListener;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class IBDragSourceListener
implements DragSourceListener {
    private TreeViewer fTreeViewer;
    private ArrayList fSelectedNodes = new ArrayList();
    private IBDropTargetListener fDropTargetListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IBDragSourceListener(TreeViewer viewer) {
        this.fTreeViewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        if (this.fDropTargetListener != null) {
            this.fDropTargetListener.setEnabled(false);
        }
        this.fSelectedNodes.clear();
        if (event.doit) {
            IStructuredSelection sel = (IStructuredSelection)this.fTreeViewer.getSelection();
            Iterator iter = sel.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IBNode)) continue;
                this.fSelectedNodes.add(element);
            }
            event.doit = !this.fSelectedNodes.isEmpty();
        }
    }

    public void setDependentDropTargetListener(IBDropTargetListener dl) {
        this.fDropTargetListener = dl;
    }

    public void dragSetData(DragSourceEvent event) {
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getResources();
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getFiles();
        }
    }

    private String[] getFiles() {
        ArrayList<String> files = new ArrayList<String>(this.fSelectedNodes.size());
        Iterator iter = this.fSelectedNodes.iterator();
        while (iter.hasNext()) {
            IPath location;
            IIndexFileLocation ifl;
            IBNode node = (IBNode)iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.core.index.IIndexFileLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ifl = (IIndexFileLocation)node.getAdapter(clazz)) == null || (location = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)ifl)) == null) continue;
            files.add(location.toOSString());
        }
        return files.toArray(new String[files.size()]);
    }

    private IFile[] getResources() {
        ArrayList<IFile> files = new ArrayList<IFile>(this.fSelectedNodes.size());
        Iterator iter = this.fSelectedNodes.iterator();
        while (iter.hasNext()) {
            IFile file;
            IBNode node = (IBNode)iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)node.getAdapter(clazz)) == null) continue;
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.fDropTargetListener != null) {
            this.fDropTargetListener.setEnabled(true);
        }
        this.fSelectedNodes.clear();
    }
}

