/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;

public class LanguageVerifier {
    public static Map computeAvailableLanguages() {
        ILanguage[] registeredLanguages = LanguageManager.getInstance().getRegisteredLanguages();
        TreeMap<String, ILanguage> languages = new TreeMap<String, ILanguage>();
        int i = 0;
        while (i < registeredLanguages.length) {
            languages.put(registeredLanguages[i].getId(), registeredLanguages[i]);
            ++i;
        }
        return languages;
    }

    public static String computeAffectedLanguages(Set missingLanguages) {
        Iterator languages = missingLanguages.iterator();
        StringBuffer buffer = new StringBuffer();
        while (languages.hasNext()) {
            buffer.append('\n');
            buffer.append(languages.next());
        }
        return buffer.toString();
    }

    public static Set removeMissingLanguages(ProjectLanguageConfiguration config, ICProjectDescription description, Map availableLanguages) {
        TreeSet<String> missingLanguages = new TreeSet<String>();
        Iterator fileConfigurationMappings = config.getFileMappings().entrySet().iterator();
        while (fileConfigurationMappings.hasNext()) {
            Map.Entry entry = fileConfigurationMappings.next();
            String path = (String)entry.getKey();
            Map configurationLanguageMappings = (Map)entry.getValue();
            Iterator mappings = configurationLanguageMappings.entrySet().iterator();
            while (mappings.hasNext()) {
                Map.Entry mapping = mappings.next();
                String configurationId = (String)mapping.getKey();
                String languageId = (String)mapping.getValue();
                if (availableLanguages.containsKey(languageId)) continue;
                missingLanguages.add(languageId);
                ICConfigurationDescription configuration = description.getConfigurationById(configurationId);
                config.removeFileMapping(configuration, path);
            }
        }
        Iterator configurationContentTypeMappings = config.getContentTypeMappings().entrySet().iterator();
        while (configurationContentTypeMappings.hasNext()) {
            Map.Entry entry = configurationContentTypeMappings.next();
            String configurationId = (String)entry.getKey();
            Map contentTypeLanguageMappings = (Map)entry.getValue();
            Iterator mappings = contentTypeLanguageMappings.entrySet().iterator();
            while (mappings.hasNext()) {
                Map.Entry mapping = mappings.next();
                String contentTypeId = (String)mapping.getKey();
                String languageId = (String)mapping.getValue();
                if (availableLanguages.containsKey(languageId)) continue;
                missingLanguages.add(languageId);
                ICConfigurationDescription configuration = description.getConfigurationById(configurationId);
                config.removeContentTypeMapping(configuration, contentTypeId);
            }
        }
        return missingLanguages;
    }

    public static Set removeMissingLanguages(WorkspaceLanguageConfiguration config, Map availableLanguages) {
        TreeSet<String> missingLanguages = new TreeSet<String>();
        Iterator contentTypeMappings = config.getWorkspaceMappings().entrySet().iterator();
        while (contentTypeMappings.hasNext()) {
            Map.Entry entry = contentTypeMappings.next();
            String contentTypeId = (String)entry.getKey();
            String languageId = (String)entry.getValue();
            if (availableLanguages.containsKey(languageId)) continue;
            missingLanguages.add(languageId);
            config.removeWorkspaceMapping(contentTypeId);
        }
        return missingLanguages;
    }
}

