/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Collections;
import java.util.Set;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.language.ContentTypeMappingDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class WorkspaceContentTypeMappingDialog
extends ContentTypeMappingDialog {
    private Set fFilteredContentTypes = Collections.EMPTY_SET;

    public WorkspaceContentTypeMappingDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(2, false));
        Label contentTypeLabel = new Label(area, 131072);
        contentTypeLabel.setText(PreferencesMessages.ContentTypeMappingsDialog_contentType);
        this.fContentType = new Combo(area, 12);
        this.fContentType.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configureContentTypes(this.fContentType);
        this.fContentType.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WorkspaceContentTypeMappingDialog.this.fSelectedContentTypeName = WorkspaceContentTypeMappingDialog.this.fContentType.getText();
                WorkspaceContentTypeMappingDialog.this.fSelectedContentTypeID = (String)WorkspaceContentTypeMappingDialog.this.fContentTypeNamesToIDsMap.get(WorkspaceContentTypeMappingDialog.this.fSelectedContentTypeName);
                WorkspaceContentTypeMappingDialog.this.getButton(0).setEnabled(WorkspaceContentTypeMappingDialog.this.isValidSelection());
            }
        });
        Label languageLabel = new Label(area, 131072);
        languageLabel.setText(PreferencesMessages.ContentTypeMappingsDialog_language);
        this.fLanguage = new Combo(area, 12);
        this.fLanguage.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fLanguage.setItems(this.getLanguages());
        this.fLanguage.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WorkspaceContentTypeMappingDialog.this.fSelectedLanguageName = WorkspaceContentTypeMappingDialog.this.fLanguage.getText();
                WorkspaceContentTypeMappingDialog.this.fSelectedLanguageID = (String)WorkspaceContentTypeMappingDialog.this.fLanguageNamesToIDsMap.get(WorkspaceContentTypeMappingDialog.this.fSelectedLanguageName);
                WorkspaceContentTypeMappingDialog.this.getButton(0).setEnabled(WorkspaceContentTypeMappingDialog.this.isValidSelection());
            }
        });
        return area;
    }

    private void configureContentTypes(Combo combo) {
        combo.removeAll();
        String[] contentTypesIDs = LanguageManager.getInstance().getRegisteredContentTypeIds();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        int i = 0;
        while (i < contentTypesIDs.length) {
            if (!this.fFilteredContentTypes.contains(contentTypesIDs[i])) {
                String name = contentTypeManager.getContentType(contentTypesIDs[i]).getName();
                combo.add(name);
                this.fContentTypeNamesToIDsMap.put(name, contentTypesIDs[i]);
            }
            ++i;
        }
    }

    public void setContentTypeFilter(Set contentTypes) {
        this.fFilteredContentTypes = contentTypes;
    }

    protected boolean isValidSelection() {
        return this.fContentType.getSelectionIndex() != -1 && this.fLanguage.getSelectionIndex() != -1;
    }
}

