/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class AbstractCEditorTextHover
implements ICEditorTextHover,
ITextHoverExtension {
    private IEditorPart fEditor;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            Point selectedRange = textViewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            return CWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public abstract String getHoverInfo(ITextViewer var1, IRegion var2);

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractCEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        return EditorsUI.getTooltipAffordanceString();
    }
}

