/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.THViewPart;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.cdt.internal.ui.viewsupport.FindNameForSelectionVisitor;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TypeHierarchyUI {
    public static THViewPart open(ICElement input, IWorkbenchWindow window) {
        ICElement[] inputs;
        if (!TypeHierarchyUI.isValidInput(input)) {
            return null;
        }
        ICElement memberInput = null;
        if (!TypeHierarchyUI.isValidTypeInput(input) && !TypeHierarchyUI.isValidTypeInput(input = (memberInput = input).getParent()) && (inputs = TypeHierarchyUI.findInput(memberInput)) != null) {
            input = inputs[0];
            memberInput = inputs[1];
        }
        if (TypeHierarchyUI.isValidTypeInput(input)) {
            return TypeHierarchyUI.openInViewPart(window, input, memberInput);
        }
        return null;
    }

    private static THViewPart openInViewPart(IWorkbenchWindow window, ICElement input, ICElement member) {
        IWorkbenchPage page = window.getActivePage();
        try {
            THViewPart result = (THViewPart)page.showView("org.eclipse.cdt.ui.typeHierarchy");
            result.setInput(input, member);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), Messages.TypeHierarchyUI_OpenTypeHierarchy, null);
            return null;
        }
    }

    public static ICElement[] getInput(ITextEditor editor, IRegion region) {
        if (editor != null) {
            IEditorInput editorInput = editor.getEditorInput();
            IWorkingCopy inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
            if (inputCElement != null) {
                ICProject project = inputCElement.getCProject();
                try {
                    return TypeHierarchyUI.findInput(project, editorInput, region);
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            }
        }
        return null;
    }

    public static void open(final ITextEditor editor, final ITextSelection sel) {
        IWorkingCopy inputCElement;
        if (editor != null && (inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput())) != null) {
            final ICProject project = inputCElement.getCProject();
            final IEditorInput editorInput = editor.getEditorInput();
            final Display display = Display.getCurrent();
            Job job = new Job(Messages.TypeHierarchyUI_OpenTypeHierarchy){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        StatusLineHandler.clearStatusLine((IWorkbenchSite)editor.getSite());
                        Region reg = new Region(sel.getOffset(), sel.getLength());
                        ICElement[] elems = TypeHierarchyUI.findInput(project, editorInput, (IRegion)reg);
                        if (elems != null && elems.length == 2) {
                            display.asyncExec(new Runnable(this, editor, elems){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ ITextEditor val$editor;
                                private final /* synthetic */ ICElement[] val$elems;
                                {
                                    this.this$1 = var1_1;
                                    this.val$editor = iTextEditor;
                                    this.val$elems = iCElementArray;
                                }

                                public void run() {
                                    TypeHierarchyUI.access$1(this.val$editor.getSite().getWorkbenchWindow(), this.val$elems[0], this.val$elems[1]);
                                }
                            });
                        } else {
                            StatusLineHandler.showStatusLineMessage((IWorkbenchSite)editor.getSite(), Messages.TypeHierarchyUI_OpenFailure_message);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    /*
     * Exception decompiling
     */
    private static ICElement[] findInput(ICProject project, IEditorInput editorInput, IRegion sel) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 152->158)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ICElement[] findInput(ICElement member) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 123->129)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IBinding findTypeBinding(IBinding memberBinding) {
        try {
            if (memberBinding instanceof IEnumerator) {
                IType type = ((IEnumerator)memberBinding).getType();
                if (type instanceof IBinding) {
                    return (IBinding)type;
                }
            } else {
                if (memberBinding instanceof ICPPMember) {
                    return ((ICPPMember)memberBinding).getClassOwner();
                }
                if (memberBinding instanceof IField) {
                    return ((IField)memberBinding).getCompositeTypeOwner();
                }
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    private static ICElement findDefinition(ICProject project, IIndex index, IASTName name, IBinding binding) throws CoreException {
        if (name != null && name.isDefinition()) {
            return IndexUI.getCElementForName(project, index, name);
        }
        ICElementHandle[] elems = IndexUI.findAllDefinitions(index, binding);
        if (elems.length > 0) {
            return elems[0];
        }
        return IndexUI.findAnyDeclaration(index, project, binding);
    }

    private static ICElement findDeclaration(ICProject project, IIndex index, IASTName name, IBinding binding) throws CoreException {
        if (name != null && name.isDefinition()) {
            return IndexUI.getCElementForName(project, index, name);
        }
        ICElementHandle[] elems = IndexUI.findAllDefinitions(index, binding);
        if (elems.length > 0) {
            return elems[0];
        }
        return IndexUI.findAnyDeclaration(index, project, binding);
    }

    private static IASTName getSelectedName(IIndex index, IEditorInput editorInput, IRegion sel) throws CoreException {
        int selectionStart = sel.getOffset();
        int selectionLength = sel.getLength();
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (workingCopy == null) {
            return null;
        }
        int options = 2;
        IASTTranslationUnit ast = workingCopy.getAST(index, options);
        FindNameForSelectionVisitor finder = new FindNameForSelectionVisitor(ast.getFilePath(), selectionStart, selectionLength);
        ast.accept((ASTVisitor)finder);
        return finder.getSelectedName();
    }

    public static boolean isValidInput(IBinding binding) {
        return TypeHierarchyUI.isValidTypeInput(binding) || binding instanceof ICPPMember || binding instanceof IEnumerator || binding instanceof IField;
    }

    public static boolean isValidTypeInput(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef;
    }

    public static boolean isValidInput(ICElement elem) {
        if (elem == null) {
            return false;
        }
        if (TypeHierarchyUI.isValidTypeInput(elem)) {
            return true;
        }
        switch (elem.getElementType()) {
            case 70: 
            case 71: 
            case 72: 
            case 81: 
            case 90: 
            case 91: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidTypeInput(ICElement elem) {
        if (elem == null) {
            return false;
        }
        switch (elem.getElementType()) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 80: {
                return true;
            }
        }
        return false;
    }

    static String getLocalElementSignature(ICElement element) {
        if (element != null) {
            try {
                switch (element.getElementType()) {
                    case 70: 
                    case 71: {
                        return ((IFunctionDeclaration)element).getSignature();
                    }
                    case 72: {
                        return element.getElementName();
                    }
                }
            }
            catch (CModelException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    static /* synthetic */ THViewPart access$1(IWorkbenchWindow iWorkbenchWindow, ICElement iCElement, ICElement iCElement2) {
        return TypeHierarchyUI.openInViewPart(iWorkbenchWindow, iCElement, iCElement2);
    }
}

