/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.ExpDialog;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractExportTab
extends AbstractCPropertyTab {
    protected Table table;
    protected TableViewer tv;
    protected ICConfigurationDescription cfg;
    protected static final LanguageManager lm = LanguageManager.getInstance();
    protected static final IContentTypeManager ctm = Platform.getContentTypeManager();
    public static final Image IMG_FS = CPluginImages.get("org.eclipse.cdt.ui.filesyst.gif");
    public static final Image IMG_WS = CPluginImages.get("org.eclipse.cdt.ui.workspace.gif");
    public static final Image IMG_MK = CPluginImages.get("org.eclipse.cdt.ui.define_obj.gif");
    private static final String ALL = UIMessages.getString("AbstractExportTab.0");
    private static final String LIST = UIMessages.getString("AbstractExportTab.1");
    private static Map names_l = new HashMap();
    private static Map names_t = new HashMap();
    private static String[] names_ls;
    private static String[] names_ts;
    private List namesList;

    static {
        ILanguage[] ls = lm.getRegisteredLanguages();
        names_ls = new String[ls.length];
        int i = 0;
        while (i < ls.length) {
            names_l.put(ls[i].getName(), ls[i].getId());
            AbstractExportTab.names_ls[i] = ls[i].getName();
            ++i;
        }
        String[] ids = lm.getRegisteredContentTypeIds();
        names_ts = new String[ids.length];
        int i2 = 0;
        while (i2 < ids.length) {
            IContentType ct = ctm.getContentType(ids[i2]);
            names_t.put(ct.getName(), ct.getId());
            AbstractExportTab.names_ts[i2] = ct.getName();
            ++i2;
        }
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        this.table = new Table(this.usercomp, 68098);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 255;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tv = new TableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new RichLabelProvider());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExportTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AbstractExportTab.this.buttonIsEnabled(1) && AbstractExportTab.this.table.getSelectionIndex() != -1) {
                    AbstractExportTab.this.buttonPressed(1);
                }
            }
        });
        TableColumn c = new TableColumn(this.table, 0);
        c.setWidth(this.hasValues() ? 100 : 200);
        c.setText(UIMessages.getString("EnvDialog.0"));
        c = new TableColumn(this.table, 0);
        c.setWidth(this.hasValues() ? 100 : 0);
        c.setText(UIMessages.getString("EnvDialog.1"));
        c = new TableColumn(this.table, 0);
        c.setWidth(100);
        c.setText(UIMessages.getString("LanguagesTab.1"));
        c = new TableColumn(this.table, 0);
        c.setWidth(100);
        c.setText(UIMessages.getString("LanguagesTab.0"));
        this.initButtons(new String[]{ADD_STR, EDIT_STR, DEL_STR});
        this.updateData(this.getResDesc());
    }

    protected void updateButtons() {
        boolean x;
        int i = this.table.getSelectionIndex();
        boolean y = x = i != -1;
        if (x) {
            ICSettingEntry ent = ((ExtData)this.table.getItem((int)i).getData()).entry;
            if (ent.isReadOnly()) {
                x = false;
            }
            if (ent.isBuiltIn() || ent.isReadOnly()) {
                y = false;
            }
        }
        this.buttonSetEnabled(1, x);
        this.buttonSetEnabled(2, y);
    }

    public abstract int getKind();

    public abstract ICLanguageSettingEntry doAdd(String var1, String var2, boolean var3);

    public abstract ICLanguageSettingEntry doEdit(String var1, String var2, boolean var3);

    public abstract boolean hasValues();

    public void update() {
        int x = this.table.getSelectionIndex();
        if (x == -1) {
            x = 0;
        }
        this.namesList = new ArrayList();
        ArrayList<ExtData> lst = new ArrayList<ExtData>();
        ICExternalSetting[] vals = this.cfg.getExternalSettings();
        if (vals == null || vals.length == 0) {
            this.tv.setInput(null);
            this.updateButtons();
            return;
        }
        int i = 0;
        while (i < vals.length) {
            ICSettingEntry[] ents = vals[i].getEntries(this.getKind());
            if (ents != null && ents.length != 0) {
                int j = 0;
                while (j < ents.length) {
                    lst.add(new ExtData(vals[i], ents[j]));
                    this.namesList.add(ents[j].getName());
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(lst, CDTListComparator.getInstance());
        this.tv.setInput((Object)lst.toArray(new Object[lst.size()]));
        if (this.table.getItemCount() > x) {
            this.table.select(x);
        } else if (this.table.getItemCount() > 0) {
            this.table.select(0);
        }
        this.updateButtons();
    }

    public void updateData(ICResourceDescription rcfg) {
        if (rcfg == null) {
            return;
        }
        this.cfg = rcfg.getConfiguration();
        this.update();
    }

    /*
     * Unable to fully structure code
     */
    public void buttonPressed(int i) {
        ent = new ICLanguageSettingEntry[1];
        n = this.table.getSelectionIndex();
        switch (i) {
            case 0: {
                dlg = new ExpDialog(this.usercomp.getShell(), true, UIMessages.getString("AbstractExportTab.2"), "", "", this.cfg, null, null, this.getKind(), AbstractExportTab.names_ls, AbstractExportTab.names_ts, this.namesList, false);
                if (!dlg.open()) break;
                ent[0] = this.doAdd(dlg.text1.trim(), dlg.text2.trim(), dlg.check2);
                if (ent[0] != null) {
                    if (dlg.check1) {
                        cfgs = this.page.getCfgsEditable();
                        k = 0;
                        while (k < cfgs.length) {
                            cfgs[k].createExternalSetting(AbstractExportTab.name2id(dlg.sel_langs, AbstractExportTab.names_l), AbstractExportTab.name2id(dlg.sel_types, AbstractExportTab.names_t), null, (ICSettingEntry[])ent);
                            ++k;
                        }
                    } else {
                        this.cfg.createExternalSetting(AbstractExportTab.name2id(dlg.sel_langs, AbstractExportTab.names_l), AbstractExportTab.name2id(dlg.sel_types, AbstractExportTab.names_t), null, (ICSettingEntry[])ent);
                    }
                }
                this.update();
                break;
            }
            case 1: {
                if (n == -1) {
                    return;
                }
                old = (ExtData)this.table.getItem(n).getData();
                if (old.entry.isReadOnly()) {
                    return;
                }
                if (this.getKind() == 4) {
                    s1 = old.getName();
                    s2 = old.getValue();
                } else {
                    s1 = s2 = old.getName();
                }
                isWsp = (old.entry.getFlags() & 8) != 0;
                dlg = new ExpDialog(this.usercomp.getShell(), false, UIMessages.getString("AbstractExportTab.3"), s1, s2, this.cfg, AbstractExportTab.id2name(old.setting.getCompatibleLanguageIds(), AbstractExportTab.names_l), AbstractExportTab.id2name(old.setting.getCompatibleContentTypeIds(), AbstractExportTab.names_t), this.getKind(), AbstractExportTab.names_ls, AbstractExportTab.names_ts, null, isWsp);
                if (!dlg.open()) break;
                ent[0] = this.doEdit(dlg.text1.trim(), dlg.text2.trim(), dlg.check2);
                ls = old.setting.getEntries(this.getKind());
                ls2 = new ICLanguageSettingEntry[ls.length];
                x = 0;
                while (x < ls.length) {
                    ls2[x] = ls[x].equals(old.entry) != false ? ent[0] : ls[x];
                    ++x;
                }
                this.cfg.removeExternalSetting(old.setting);
                this.cfg.createExternalSetting(AbstractExportTab.name2id(dlg.sel_langs, AbstractExportTab.names_l), AbstractExportTab.name2id(dlg.sel_types, AbstractExportTab.names_t), null, (ICSettingEntry[])ls2);
                this.update();
                break;
            }
            case 2: {
                if (n == -1) {
                    return;
                }
                its = this.table.getSelection();
                checked = new boolean[its.length];
                t = 0;
                while (t < its.length) {
                    if (checked[t] || its[t] == null) ** GOTO lbl81
                    old = (ExtData)its[t].getData();
                    if (old.entry.isReadOnly() || old.entry.isBuiltIn()) ** GOTO lbl81
                    ls = old.setting.getEntries(this.getKind());
                    lst = new ArrayList<ICSettingEntry>();
                    x = 0;
                    while (x < ls.length) {
                        y = t;
                        while (y < its.length) {
                            if (its[y] == null) break;
                            ob = its[y].getData();
                            if (ob == null || !(ob instanceof ExtData)) ** GOTO lbl72
                            ex = (ExtData)ob;
                            if (!ls[x].equals(ex.entry)) ** GOTO lbl72
                            checked[y] = true;
                            ** GOTO lbl76
lbl72:
                            // 2 sources

                            ++y;
                        }
                        lst.add(ls[x]);
lbl76:
                        // 2 sources

                        ++x;
                    }
                    this.cfg.removeExternalSetting(old.setting);
                    this.cfg.createExternalSetting(old.setting.getCompatibleLanguageIds(), old.setting.getCompatibleContentTypeIds(), old.setting.getCompatibleExtensions(), (ICSettingEntry[])lst.toArray(new ICLanguageSettingEntry[lst.size()]));
lbl81:
                    // 3 sources

                    ++t;
                }
                this.update();
                break;
            }
        }
    }

    public static String[] name2id(String[] ein, Map names) {
        if (ein != null) {
            int k = 0;
            while (k < ein.length) {
                ein[k] = (String)names.get(ein[k]);
                ++k;
            }
        }
        return ein;
    }

    public static String[] id2name(String[] ein, Map names) {
        if (ein != null) {
            int i = 0;
            while (i < ein.length) {
                Iterator it = names.keySet().iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (!ein[i].equals(names.get(s))) continue;
                    ein[i] = s;
                    break;
                }
                ++i;
            }
        }
        return ein;
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        ICConfigurationDescription c1 = src.getConfiguration();
        ICConfigurationDescription c2 = dst.getConfiguration();
        c2.removeExternalSettings();
        ICExternalSetting[] v = c1.getExternalSettings();
        int i = 0;
        while (i < v.length) {
            c2.createExternalSetting(v[i].getCompatibleLanguageIds(), v[i].getCompatibleContentTypeIds(), v[i].getCompatibleExtensions(), v[i].getEntries());
            ++i;
        }
    }

    protected void performDefaults() {
        this.cfg.removeExternalSettings();
        this.updateData(this.getResDesc());
    }

    public boolean canBeVisible() {
        return this.page.isForProject();
    }

    protected static String getLabel(String[] lst, Map names) {
        if (lst == null || lst.length == 0) {
            return ALL;
        }
        if (lst.length > 1) {
            return LIST;
        }
        Iterator it = names.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (!names.get(s).equals(lst[0])) continue;
            return s;
        }
        return lst[0];
    }

    protected static String getList(String[] lst) {
        String s = "";
        int i = 0;
        while (i < lst.length) {
            s = String.valueOf(s) + lst[i] + '\n';
            ++i;
        }
        return s;
    }

    public static Image getWspImage(boolean isWsp) {
        return isWsp ? IMG_WS : IMG_FS;
    }

    static class ExtData {
        ICExternalSetting setting;
        ICSettingEntry entry;

        ExtData(ICExternalSetting _s, ICSettingEntry _e) {
            this.setting = _s;
            this.entry = _e;
        }

        protected String getName() {
            return this.entry.getName();
        }

        protected String getValue() {
            if (this.entry.getKind() == 4) {
                return this.entry.getValue();
            }
            return "";
        }

        protected String getLangStr() {
            return AbstractExportTab.getLabel(this.setting.getCompatibleLanguageIds(), names_l);
        }

        protected String getTypeStr() {
            return AbstractExportTab.getLabel(this.setting.getCompatibleContentTypeIds(), names_t);
        }
    }

    private class RichLabelProvider
    extends LabelProvider
    implements IFontProvider,
    ITableLabelProvider {
        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex > 0) {
                return null;
            }
            ExtData data = (ExtData)element;
            if (data.entry.getKind() == 4) {
                return IMG_MK;
            }
            if ((data.entry.getFlags() & 8) != 0) {
                return IMG_WS;
            }
            return IMG_FS;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            ExtData data = (ExtData)element;
            switch (columnIndex) {
                case 0: {
                    return data.getName();
                }
                case 1: {
                    return data.getValue();
                }
                case 2: {
                    return data.getLangStr();
                }
                case 3: {
                    return data.getTypeStr();
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            ExtData data = (ExtData)element;
            if (data.entry.isBuiltIn()) {
                return null;
            }
            if (data.entry.isReadOnly()) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
            }
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        }
    }
}

