/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.IPagesAfterTemplateSelectionProvider;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUIUtil;
import org.eclipse.cdt.ui.templateengine.pages.UIPagesProvider;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.cdt.ui.templateengine.uitree.UIElementTreeBuilderHelper;
import org.eclipse.cdt.ui.templateengine.uitree.UIElementTreeBuilderManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Element;

public class Template
extends TemplateCore {
    private TemplateDescriptor templateDescriptor = this.getTemplateDescriptor();
    private UIElementTreeBuilderManager uiElementTreeBuilderManager;
    private UIPagesProvider uiPagesProvider;
    private Map pageMap;

    public Template(TemplateInfo templateInfo) throws TemplateInitializationException {
        super(templateInfo);
        this.uiElementTreeBuilderManager = new UIElementTreeBuilderManager(new UIElementTreeBuilderHelper(this.templateDescriptor, templateInfo));
        this.uiPagesProvider = new UIPagesProvider();
    }

    public Map getUIPages() {
        if (this.pageMap == null) {
            this.pageMap = new HashMap();
            List rootPropertyGrouplist = this.templateDescriptor.getPropertyGroupList();
            this.uiPagesProvider.clearOrderVector();
            int i = 0;
            while (i < rootPropertyGrouplist.size()) {
                this.uiElementTreeBuilderManager.setUIElementTreeRootNull();
                this.uiElementTreeBuilderManager.createUIElementTree(null, (Element)rootPropertyGrouplist.get(i));
                this.pageMap.putAll(this.uiPagesProvider.getWizardUIPages(this.uiElementTreeBuilderManager.getUIElementTreeRoot(), this.getValueStore()));
                ++i;
            }
        }
        return this.pageMap;
    }

    public IWizardPage[] getTemplateWizardPages(IWizardPage predatingPage, IWizardPage followingPage, IWizard wizard) {
        IWizardPage prevPage;
        ArrayList<IWizardDataPage> pages = new ArrayList<IWizardDataPage>();
        Map templatePages = this.getUIPages();
        List templatePagesOrderVector = this.getPagesOrderVector();
        if (templatePagesOrderVector.size() != 0) {
            prevPage = predatingPage;
            int i = 0;
            while (i < templatePagesOrderVector.size()) {
                UIWizardPage page = (UIWizardPage)templatePages.get(templatePagesOrderVector.get(i));
                pages.add(page);
                page.setPreviousPage(prevPage);
                if (i + 1 < templatePagesOrderVector.size()) {
                    page.setNextPage((UIWizardPage)templatePages.get(templatePagesOrderVector.get(i + 1)));
                } else {
                    page.setNextPage(followingPage);
                }
                page.setWizard(wizard);
                prevPage = page;
                ++i;
            }
            predatingPage = prevPage;
        }
        try {
            prevPage = predatingPage;
            IWizardDataPage[] extraPages = this.getExtraCreatedPages((IWorkbenchWizard)wizard, PlatformUI.getWorkbench(), null);
            int i = 0;
            while (i < extraPages.length) {
                IWizardDataPage page = extraPages[i];
                pages.add(page);
                page.setPreviousPage(prevPage);
                if (prevPage instanceof IWizardDataPage) {
                    ((IWizardDataPage)prevPage).setNextPage(page);
                }
                page.setWizard(wizard);
                prevPage = page;
                ++i;
            }
            if (prevPage instanceof IWizardDataPage) {
                ((IWizardDataPage)prevPage).setNextPage(followingPage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        followingPage.setPreviousPage(predatingPage);
        return pages.toArray(new IWizardPage[pages.size()]);
    }

    IWizardDataPage[] getExtraCreatedPages(IWorkbenchWizard wizard, IWorkbench workbench, IStructuredSelection selection) {
        TemplateInfo templateInfo = this.getTemplateInfo();
        IPagesAfterTemplateSelectionProvider extraPagesProvider = (IPagesAfterTemplateSelectionProvider)templateInfo.getExtraPagesProvider();
        if (extraPagesProvider != null) {
            return extraPagesProvider.createAdditionalPages(wizard, null, null);
        }
        return new IWizardDataPage[0];
    }

    public List getPagesOrderVector() {
        return this.uiPagesProvider.getOrderVector();
    }

    public UIElementTreeBuilderManager getUIElementTreeBuilderManager() {
        return this.uiElementTreeBuilderManager;
    }

    public IStatus[] executeTemplateProcesses(IProgressMonitor monitor, final boolean showError) {
        this.setDirty();
        TemplateEngine.getDefault().updateSharedDefaults((TemplateCore)this);
        final IStatus[][] result = new IStatus[1][];
        WorkspaceModifyOperation wmo = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    result[0] = Template.this.getProcessHandler().processAll(monitor);
                }
                catch (ProcessFailureException e) {
                    if (showError) {
                        TemplateEngineUIUtil.showError(e.getMessage(), e.getCause());
                    }
                    result[0] = new IStatus[]{new Status(4, CUIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e)};
                }
            }
        };
        try {
            wmo.run(monitor);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getTargetException());
        }
        return result[0];
    }
}

