/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.ui.templateengine.IPagesAfterTemplateSelectionProvider;
import org.eclipse.cdt.ui.templateengine.ITemplatesListProvider;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUIUtil;
import org.eclipse.cdt.ui.templateengine.TemplateListSelectionPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class TemplatesChoiceWizard
extends Wizard
implements ITemplatesListProvider,
IWorkbenchWizard {
    private static final boolean DEBUG = false;
    private TemplateListSelectionPage templateListSelectionPage;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;

    public final void addPages() {
        IWizardDataPage[] pages = this.getPagesBeforeTemplatePages();
        int i = 0;
        while (i < pages.length) {
            this.addPage(pages[i]);
            ++i;
        }
        this.templateListSelectionPage = new TemplateListSelectionPage(this);
        this.addPage((IWizardPage)this.templateListSelectionPage);
        pages = this.getPagesAfterTemplatePages();
        i = 0;
        while (i < pages.length) {
            this.addPage(pages[i]);
            ++i;
        }
    }

    public String getListSelectionTitle() {
        return Messages.getString("TemplatesChoiceWizard.0");
    }

    public String getListSelectionDescription() {
        return Messages.getString("TemplatesChoiceWizard.1");
    }

    public String getListSelectionLabel() {
        return Messages.getString("TemplatesChoiceWizard.2");
    }

    protected abstract IWizardDataPage[] getPagesBeforeTemplatePages();

    protected abstract IWizardDataPage[] getPagesAfterTemplatePages();

    protected abstract IWizardDataPage[] getPagesAfterTemplateSelection();

    IWizardDataPage[] getPagesAfterTemplateSelectionWithExtraPages(Template template) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        IWizardDataPage[] pages = this.getPagesAfterTemplateSelection();
        TemplateInfo templateInfo = template.getTemplateInfo();
        IPagesAfterTemplateSelectionProvider extraPagesProvider = (IPagesAfterTemplateSelectionProvider)templateInfo.getExtraPagesProvider();
        if (extraPagesProvider != null) {
            ArrayList<IWizardDataPage> pageList = new ArrayList<IWizardDataPage>(Arrays.asList(pages));
            IWizardDataPage[] extraPages = extraPagesProvider.createAdditionalPages(this, this.workbench, this.selection);
            pageList.addAll(Arrays.asList(extraPages));
            pages = pageList.toArray(new IWizardDataPage[pageList.size()]);
        }
        return pages;
    }

    IWizardDataPage[] getExtraCreatedPages(Template template) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        TemplateInfo templateInfo = template.getTemplateInfo();
        IPagesAfterTemplateSelectionProvider extraPagesProvider = (IPagesAfterTemplateSelectionProvider)templateInfo.getExtraPagesProvider();
        if (extraPagesProvider != null) {
            ArrayList<IWizardDataPage> pageList = new ArrayList<IWizardDataPage>();
            IWizardDataPage[] extraPages = extraPagesProvider.getCreatedPages(this);
            pageList.addAll(Arrays.asList(extraPages));
            return pageList.toArray(new IWizardDataPage[pageList.size()]);
        }
        return new IWizardDataPage[0];
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TemplatesChoiceWizard.this.finishPage(monitor);
            }
        });
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private boolean finishPage(IProgressMonitor monitor) {
        IStatus[] statuses = this.templateListSelectionPage.getTemplate().executeTemplateProcesses(monitor, false);
        if (statuses.length == 1 && statuses[0].getException() instanceof ProcessFailureException) {
            TemplateEngineUIUtil.showError(statuses[0].getMessage(), statuses[0].getException());
            return false;
        }
        return true;
    }

    public Map getAllDataInNonTemplatePages() {
        HashMap map = new HashMap();
        IWizardDataPage[] pages = this.getPagesBeforeTemplatePages();
        int i = 0;
        while (i < pages.length) {
            map.putAll(pages[i].getPageData());
            ++i;
        }
        pages = this.getPagesAfterTemplateSelection();
        i = 0;
        while (i < pages.length) {
            map.putAll(pages[i].getPageData());
            ++i;
        }
        try {
            pages = this.getExtraCreatedPages(this.getSelectedTemplate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        i = 0;
        while (i < pages.length) {
            map.putAll(pages[i].getPageData());
            ++i;
        }
        pages = this.getPagesAfterTemplatePages();
        i = 0;
        while (i < pages.length) {
            map.putAll(pages[i].getPageData());
            ++i;
        }
        return map;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
    }

    public Template getSelectedTemplate() {
        return this.templateListSelectionPage.getTemplate();
    }

    public void adjustTemplateValues(Template template) {
    }
}

