/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.pages.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectCreationPage
extends WizardNewProjectCreationPage
implements IWizardDataPage {
    private static final String ERROR_SUFFIX = Messages.getString("NewProjectCreationPage.0");
    private static final String ERROR_SUFFIX_TOO_LONG = Messages.getString("NewProjectCreationPage.1");
    private static final Status OK_STATUS = new Status(0, CUIPlugin.getPluginId(), 0, "", null);
    private Map data = new HashMap();
    private IWizardPage next;

    public NewProjectCreationPage(String name) {
        super(name);
        this.setDescription(Messages.getString("NewProjectCreationPage.3"));
    }

    public Map getPageData() {
        String projName = super.getProjectName().trim();
        this.data.put("projectName", projName);
        this.data.put("baseName", this.getBaseName(projName));
        this.data.put("baseNameUpper", this.getBaseName(projName).toUpperCase());
        this.data.put("baseNameLower", this.getBaseName(projName).toLowerCase());
        this.data.put("location", super.getLocationPath().toPortableString());
        return this.data;
    }

    private String getBaseName(String projName) {
        String baseName = projName;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        return baseName;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            IStatus validName = this.isValidName(this.getProjectName());
            if (!validName.isOK()) {
                this.setErrorMessage(validName.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    private IStatus isValidName(String projectName) {
        String baseName = projectName;
        if (!Character.isLetter(baseName.charAt(0))) {
            return new Status(4, CUIPlugin.getPluginId(), 4, String.valueOf(projectName) + ERROR_SUFFIX, null);
        }
        if (baseName.length() > 31) {
            return new Status(4, CUIPlugin.getPluginId(), 4, String.valueOf(projectName) + ERROR_SUFFIX_TOO_LONG, null);
        }
        int i = 1;
        int l = baseName.length();
        while (i < l) {
            char c = baseName.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != ' ') {
                return new Status(4, CUIPlugin.getPluginId(), 4, String.valueOf(projectName) + ERROR_SUFFIX, null);
            }
            ++i;
        }
        return OK_STATUS;
    }

    public void setNextPage(IWizardPage next) {
        this.next = next;
    }

    public IWizardPage getNextPage() {
        if (this.next != null) {
            return this.next;
        }
        return super.getNextPage();
    }
}

