/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree;

import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.ui.templateengine.uitree.IUIElementTreeBuilderHelper;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.SimpleUIElementGroup;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIGroupTypeEnum;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIBooleanWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIBrowseWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UISelectWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UISpecialListWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIStringListWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UITextWidget;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UIElementTreeBuilderHelper
implements IUIElementTreeBuilderHelper {
    private TemplateDescriptor templateDescriptor = null;
    private TemplateInfo templateInfo;
    private Element element;

    public UIElementTreeBuilderHelper(TemplateDescriptor templateDescriptor, TemplateInfo templateInfo) {
        this.templateDescriptor = templateDescriptor;
        this.templateInfo = templateInfo;
    }

    public List getPropertyGroupList() {
        return this.templateDescriptor.getPropertyGroupList();
    }

    public UIElement getUIElement(Element element) {
        this.element = element;
        UIElement retUIElement = null;
        UIAttributes uiAttributes = new UIAttributes(this.templateInfo);
        NamedNodeMap list = element.getAttributes();
        int i = 0;
        int s = list.getLength();
        while (i < s) {
            Node attribute = list.item(i);
            uiAttributes.put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        retUIElement = this.getUIWidget(uiAttributes);
        return retUIElement;
    }

    private UIElement getUIWidget(UIAttributes uiAttributes) {
        String type = (String)uiAttributes.get("type");
        UIElement widgetElement = null;
        String itemName = null;
        String itemValue = null;
        String itemSelected = null;
        String nameStr = null;
        String valueStr = null;
        String selected = null;
        if (new Boolean((String)uiAttributes.get(InputUIElement.HIDDEN)).booleanValue()) {
            return null;
        }
        if (type.equalsIgnoreCase("") || type == null) {
            return null;
        }
        if (type.equalsIgnoreCase(InputUIElement.INPUTTYPE)) {
            widgetElement = new UITextWidget(uiAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.MULTILINETYPE)) {
            widgetElement = new UITextWidget(uiAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.SELECTTYPE)) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            List itemList = TemplateEngine.getChildrenOfElement((Element)this.element);
            int i = 0;
            int l = itemList.size();
            while (i < l) {
                Element itemElement = (Element)itemList.get(i);
                NamedNodeMap itemAttrList = itemElement.getAttributes();
                int j = 0;
                int l1 = itemAttrList.getLength();
                while (j < l1) {
                    Node itemAttr = itemAttrList.item(j);
                    itemName = itemAttr.getNodeName();
                    itemValue = itemAttr.getNodeValue();
                    if (itemName.equals("label")) {
                        selected = itemValue;
                        nameStr = new String(itemValue);
                    } else if (itemName.equals(InputUIElement.NAME)) {
                        valueStr = new String(itemValue);
                    }
                    if (itemName.equals(InputUIElement.SELECTED) && itemValue.equals("true")) {
                        itemSelected = selected;
                    }
                    itemMap.put(nameStr, valueStr);
                    ++j;
                }
                ++i;
            }
            widgetElement = new UISelectWidget(uiAttributes, itemMap, itemSelected);
        }
        if (type.equalsIgnoreCase(InputUIElement.BOOLEANTYPE)) {
            widgetElement = new UIBooleanWidget(uiAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.BROWSETYPE)) {
            widgetElement = new UIBrowseWidget(uiAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.STRINGLISTTYPE)) {
            widgetElement = new UIStringListWidget(uiAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.SPECIALLISTTYPE)) {
            widgetElement = new UISpecialListWidget(uiAttributes);
        }
        if (type.equalsIgnoreCase(UIGroupTypeEnum.PAGES_ONLY.getId())) {
            widgetElement = new SimpleUIElementGroup(uiAttributes);
        }
        type.equalsIgnoreCase(UIGroupTypeEnum.PAGES_TAB.getId());
        return widgetElement;
    }
}

