/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.cdt.ui.wizards.NewCProjectWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewCProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String OP_DESC = "CProjectWizard.op_description";
    private static final String PREFIX = "CProjectWizard";
    private static final String WZ_TITLE = "CProjectWizard.title";
    private static final String WZ_DESC = "CProjectWizard.description";
    private static final String WINDOW_TITLE = "CProjectWizard.windowTitle";
    private String wz_title;
    private String wz_desc;
    protected IConfigurationElement fConfigElement;
    protected NewCProjectWizardPage fMainPage;
    protected IProject newProject;
    List tabItemsList = new ArrayList();

    public NewCProjectWizard() {
        this(CUIPlugin.getResourceString(WZ_TITLE), CUIPlugin.getResourceString(WZ_DESC), CUIPlugin.getResourceString(OP_ERROR));
    }

    public NewCProjectWizard(String title, String description) {
        this(title, description, CUIPlugin.getResourceString(OP_ERROR));
    }

    public NewCProjectWizard(String title, String description, String error) {
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.wz_title = title;
        this.wz_desc = description;
    }

    public void addPages() {
        this.fMainPage = new NewCProjectWizardPage(CUIPlugin.getResourceString(PREFIX));
        this.fMainPage.setTitle(this.wz_title);
        this.fMainPage.setDescription(this.wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
    }

    protected abstract void doRunPrologue(IProgressMonitor var1);

    protected abstract void doRunEpilogue(IProgressMonitor var1);

    protected IStatus isValidName(String name) {
        return new Status(0, "org.eclipse.cdt.ui", 0, "", null);
    }

    protected IStatus isValidLocation(String projectFieldContents) {
        return new Status(0, "org.eclipse.cdt.ui", 0, "", null);
    }

    protected IPath getLocationPath() throws UnsupportedOperationException {
        if (this.fMainPage == null) {
            throw new UnsupportedOperationException();
        }
        return this.fMainPage.getLocationPath();
    }

    public IProject getProjectHandle() throws UnsupportedOperationException {
        if (this.fMainPage == null) {
            throw new UnsupportedOperationException();
        }
        return this.fMainPage.getProjectHandle();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    protected IResource getSelectedResource() {
        return this.getNewProject();
    }

    public boolean performFinish() {
        if (!this.invokeRunnable(this.getRunnable())) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        IResource resource = this.getSelectedResource();
        this.selectAndReveal(resource);
        if (resource != null && resource.getType() == 1) {
            IFile file = (IFile)resource;
            IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
            if (dw != null) {
                try {
                    IWorkbenchPage page = dw.getActivePage();
                    if (page != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)dw.getShell(), (String)CUIPlugin.getResourceString(OP_ERROR), (String)e.getMessage());
                }
            }
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(CPluginImages.DESC_WIZABAN_NEW_PROJ);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(CUIPlugin.getResourceString(WINDOW_TITLE));
    }

    public IRunnableWithProgress getRunnable() {
        return new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor imonitor) throws InvocationTargetException, InterruptedException {
                Exception[] except = new Exception[1];
                NewCProjectWizard.this.getShell().getDisplay().syncExec(new Runnable(this, except){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Exception[] val$except;
                    {
                        this.this$1 = var1_1;
                        this.val$except = exceptionArray;
                    }

                    public void run() {
                        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(this, this.val$except){
                            final /* synthetic */ 2 this$2;
                            private final /* synthetic */ Exception[] val$except;
                            {
                                this.this$2 = var1_1;
                                this.val$except = exceptionArray;
                            }

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Object fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                                fMonitor.beginTask(CUIPlugin.getResourceString("CProjectWizard.op_description"), 3);
                                1.access$0(2.access$0(this.this$2)).doRunPrologue((IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                try {
                                    1.access$0(2.access$0(this.this$2)).doRun((IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                }
                                catch (CoreException e) {
                                    this.val$except[0] = e;
                                }
                                1.access$0(2.access$0(this.this$2)).doRunEpilogue((IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                fMonitor.done();
                            }
                        });
                        try {
                            1.access$0(this.this$1).getContainer().run(false, true, (IRunnableWithProgress)op);
                        }
                        catch (InvocationTargetException e) {
                            this.val$except[0] = e;
                        }
                        catch (InterruptedException e) {
                            this.val$except[0] = e;
                        }
                    }

                    static /* synthetic */ 1 access$0(2 var0) {
                        return var0.this$1;
                    }
                });
                if (except[0] != null) {
                    if (except[0] instanceof InvocationTargetException) {
                        throw (InvocationTargetException)except[0];
                    }
                    if (except[0] instanceof InterruptedException) {
                        throw (InterruptedException)except[0];
                    }
                    throw new InvocationTargetException(except[0]);
                }
            }

            static /* synthetic */ NewCProjectWizard access$0(1 var0) {
                return var0.NewCProjectWizard.this;
            }
        });
    }

    protected boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Shell shell = this.getShell();
            String title = CUIPlugin.getResourceString("CProjectWizard.op_error.title");
            String message = CUIPlugin.getResourceString("CProjectWizard.op_error.message");
            Throwable th = e.getTargetException();
            CUIPlugin.errorDialog(shell, title, message, th, false);
            try {
                this.getProjectHandle().delete(false, false, null);
            }
            catch (CoreException coreException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        this.createNewProject(monitor);
    }

    protected IProject createNewProject(IProgressMonitor monitor) throws CoreException {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = null;
        try {
            newProjectHandle = this.getProjectHandle();
        }
        catch (UnsupportedOperationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, e.getMessage(), null));
        }
        IPath defaultPath = Platform.getLocation();
        IPath newPath = this.getLocationPath();
        if (defaultPath.equals((Object)newPath)) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        this.newProject = this.getBuildSystemId() != null ? CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, this.getBuildSystemId(), monitor) : CCorePlugin.getDefault().createCProject(description, newProjectHandle, monitor, this.getProjectID());
        return this.newProject;
    }

    public abstract String getProjectID();

    public String getBuildSystemId() {
        return null;
    }
}

