/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.io.File;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.gdbjtag.core.GDBJtagDebugger;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class GDBJtagLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    protected String getPluginID() {
        return "org.eclipse.cdt.debug.gdbremote.core";
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.setDefaultSourceLocator(launch, configuration);
        if (mode.equals("debug")) {
            GDBJtagDebugger debugger = new GDBJtagDebugger();
            ICProject project = this.verifyCProject(configuration);
            IPath exePath = this.verifyProgramPath(configuration);
            File exeFile = exePath != null ? exePath.toFile() : null;
            ICDISession session = debugger.createSession(launch, exeFile, (IProgressMonitor)submonitor.newChild(1));
            IBinaryParser.IBinaryObject exeBinary = null;
            if (exePath != null) {
                exeBinary = this.verifyBinary(project, exePath);
            }
            try {
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (i < targets.length) {
                    Process process = targets[i].getProcess();
                    IProcess iprocess = null;
                    if (process != null) {
                        iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                    }
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderProcessLabel("GDB Hardware Debugger"), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeBinary, (boolean)true, (boolean)false, (boolean)false);
                    ++i;
                }
                debugger.doRunSession(launch, session, (IProgressMonitor)submonitor.newChild(1));
            }
            catch (CoreException e) {
                try {
                    session.terminate();
                }
                catch (CDIException cDIException) {}
                throw e;
            }
        }
        this.cancel("TargetConfiguration not supported", 150);
    }
}

