/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class CConventions {
    private static final String scopeResolutionOperator = "::";
    private static final char fgDot = '.';
    private static final String ILLEGAL_FILE_CHARS = "/\\:<>?*|\"";

    public static boolean isLegalIdentifier(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(32) != -1) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int i = 1;
        while (i < length) {
            c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateClassName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nullName"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nameWithBlanks"), null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            IStatus status = CConventions.validateIdentifier(name);
            if (!status.isOK()) {
                return status;
            }
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + scopeResolutionOperator.length()).trim();
            status = CConventions.validateIdentifier(type);
            if (!status.isOK()) {
                return status;
            }
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.dollarName"), null);
            }
            if (scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.leadingUnderscore"), null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.lowercaseName"), null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.invalidName", name), null);
    }

    public static IStatus validateNamespaceName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.namespace.nullName"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.namespace.nameWithBlanks"), null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            IStatus status = CConventions.validateIdentifier(name);
            if (!status.isOK()) {
                return status;
            }
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + scopeResolutionOperator.length()).trim();
            status = CConventions.validateIdentifier(type);
            if (!status.isOK()) {
                return status;
            }
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.namespace.dollarName"), null);
            }
            if (scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.namespace.leadingUnderscore"), null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.invalidName", name), null);
    }

    public static IStatus validateScopeName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nullName"), null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.emptyName"), null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.dotName"), null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nameWithBlanks"), null);
        }
        StringTokenizer st = new StringTokenizer(name, scopeResolutionOperator);
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = (typeName = typeName.trim()).toCharArray();
            if (scannedID == null) {
                return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", typeName), null);
            }
            if (firstToken && scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.leadingUnderscore"), null);
            }
            if (firstToken && scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.lowercaseName"), null);
            }
            firstToken = false;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name) {
        return CConventions.validateIdentifier(name);
    }

    public static IStatus validateIdentifier(String id) {
        if (!CConventions.isLegalIdentifier(id)) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", id), null);
        }
        if (!CConventions.isValidIdentifier(id)) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.invalid", id), null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateMethodName(String name) {
        if (name.startsWith("~")) {
            return CConventions.validateIdentifier(name.substring(1));
        }
        return CConventions.validateIdentifier(name);
    }

    public static IStatus validateIncludeName(IProject project, String name) {
        String[] segments = new Path(name).segments();
        int i = 0;
        while (i < segments.length) {
            IStatus status = i == segments.length - 1 ? CConventions.validateHeaderFileName(project, segments[i]) : CConventions.validateFileName(segments[i]);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static boolean isValidIdentifier(String name) {
        IToken token = null;
        IScanner scanner = ParserFactory.createScanner(new CodeReader(name.toCharArray()), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, null, null, null);
        try {
            token = scanner.nextToken();
        }
        catch (Exception exception) {}
        if (token != null && token.getType() == 1) {
            try {
                scanner.nextToken();
            }
            catch (EndOfFileException endOfFileException) {
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static boolean isLegalFilename(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int len = name.length();
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            if (ILLEGAL_FILE_CHARS.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateFileName(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.filename.nullName"), null);
        }
        if (!CConventions.isLegalFilename(name)) {
            return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.filename.possiblyInvalid"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.filename.nameWithBlanks"), null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateHeaderFileName(IProject project, String name) {
        IStatus val = CConventions.validateFileName(name);
        if (val.getSeverity() == 4) {
            return val;
        }
        if (!CoreModel.isValidHeaderUnitName(project, name)) {
            return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.headerFilename.filetype"), null);
        }
        return val;
    }

    public static IStatus validateSourceFileName(IProject project, String name) {
        IStatus val = CConventions.validateFileName(name);
        if (val.getSeverity() == 4) {
            return val;
        }
        if (!CoreModel.isValidSourceUnitName(project, name)) {
            return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.sourceFilename.filetype"), null);
        }
        return val;
    }

    public static IStatus validateEnumName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.enum.nullName"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.enum.nameWithBlanks"), null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            IStatus status = CConventions.validateIdentifier(name);
            if (!status.isOK()) {
                return status;
            }
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + scopeResolutionOperator.length()).trim();
            status = CConventions.validateIdentifier(type);
            if (!status.isOK()) {
                return status;
            }
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.enum.dollarName"), null);
            }
            if (scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.enum.leadingUnderscore"), null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.enum.lowercaseName"), null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.enum.invalidName"), null);
    }
}

