/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorManager;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IPositionTrackerManager;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IPDOMManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.CContentTypes;
import org.eclipse.cdt.internal.core.CDTLogWriter;
import org.eclipse.cdt.internal.core.CdtVarPathEntryVariableManager;
import org.eclipse.cdt.internal.core.PositionTrackerManager;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class CCorePlugin
extends Plugin {
    public static final int STATUS_CDTPROJECT_EXISTS = 1;
    public static final int STATUS_CDTPROJECT_MISMATCH = 2;
    public static final int CDT_PROJECT_NATURE_ID_MISMATCH = 3;
    public static final String PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String BUILDER_MODEL_ID = "org.eclipse.cdt.core.CBuildModel";
    public static final String BINARY_PARSER_SIMPLE_ID = "BinaryParser";
    public static final String BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.BinaryParser";
    public static final String PREF_BINARY_PARSER = "binaryparser";
    public static final String DEFAULT_BINARY_PARSER_SIMPLE_ID = "ELF";
    public static final String DEFAULT_BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.ELF";
    public static final String PREF_USE_STRUCTURAL_PARSE_MODE = "useStructualParseMode";
    public static final String INDEX_SIMPLE_ID = "CIndex";
    public static final String INDEX_UNIQ_ID = "org.eclipse.cdt.core.CIndex";
    public static final String INDEXER_SIMPLE_ID = "CIndexer";
    public static final String INDEXER_UNIQ_ID = "org.eclipse.cdt.core.CIndexer";
    public static final String PREF_INDEXER = "indexer";
    public static final String DEFAULT_INDEXER = "org.eclipse.cdt.core.fastIndexer";
    public static final String ERROR_PARSER_SIMPLE_ID = "ErrorParser";
    public static final String ERROR_PARSER_UNIQ_ID = "org.eclipse.cdt.core.ErrorParser";
    public static final String DEFAULT_PATHENTRY_STORE_ID = "org.eclipse.cdt.core.cdtPathEntryStore";
    public static final String BUILD_SCANNER_INFO_SIMPLE_ID = "ScannerInfoProvider";
    public static final String BUILD_SCANNER_INFO_UNIQ_ID = "org.eclipse.cdt.core.ScannerInfoProvider";
    public static final String DEFAULT_PROVIDER_ID = "org.eclipse.cdt.core.defaultConfigDataProvider";
    public static final String FORMATTER_EXTPOINT_ID = "CodeFormatter";
    public static final String CORE_ENCODING = "org.eclipse.cdt.core.encoding";
    public static final String CONTENT_TYPE_CSOURCE = "org.eclipse.cdt.core.cSource";
    public static final String CONTENT_TYPE_CHEADER = "org.eclipse.cdt.core.cHeader";
    public static final String CONTENT_TYPE_CXXSOURCE = "org.eclipse.cdt.core.cxxSource";
    public static final String CONTENT_TYPE_CXXHEADER = "org.eclipse.cdt.core.cxxHeader";
    public static final String CONTENT_TYPE_ASMSOURCE = "org.eclipse.cdt.core.asmSource";
    public static final String CONTENT_TYPE_BINARYFILE = "org.eclipse.cdt.core.binaryFile";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public CDTLogWriter cdtLog = null;
    private static CCorePlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private CProjectDescriptionManager fNewCProjectDescriptionManager;
    private CoreModel fCoreModel;
    private PDOMManager pdomManager;
    private CdtVarPathEntryVariableManager fPathEntryVariableManager;
    private static final String MODEL = "org.eclipse.cdt.core/debug/model";
    private static final String PARSER = "org.eclipse.cdt.core/debug/parser";
    private static final String PARSER_EXCEPTIONS = "org.eclipse.cdt.core/debug/parser/exceptions";
    private static final String SCANNER = "org.eclipse.cdt.core/debug/scanner";
    private static final String DELTA = "org.eclipse.cdt.core/debug/deltaprocessor";

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.core.CCorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = CModelManager.getDefault().sharedWorkingCopies).get(factory)) == null) {
            return CModelManager.NoWorkingCopy;
        }
        Collection copies = perFactoryWorkingCopies.values();
        IWorkingCopy[] result = new IWorkingCopy[copies.size()];
        copies.toArray(result);
        return result;
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), arg);
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static IPositionTrackerManager getPositionTrackerManager() {
        return PositionTrackerManager.getInstance();
    }

    public static CCorePlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(String e) {
        CCorePlugin.log(CCorePlugin.createStatus(e));
    }

    public static void log(Throwable e) {
        if (e instanceof CoreException) {
            CCorePlugin.log(((CoreException)e).getStatus());
        } else {
            CCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
        }
    }

    public static IStatus createStatus(String msg) {
        return CCorePlugin.createStatus(msg, null);
    }

    public static IStatus createStatus(String msg, Throwable e) {
        return new Status(4, PLUGIN_ID, 4, msg, e);
    }

    public static void log(IStatus status) {
        CCorePlugin.getDefault().getLog().log(status);
    }

    public CCorePlugin() {
        fgCPlugin = this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.pdomManager.shutdown();
            PositionTrackerManager.getInstance().uninstall();
            if (this.fCoreModel != null) {
                this.fCoreModel.shutdown();
            }
            if (this.cdtLog != null) {
                this.cdtLog.shutdown();
            }
            if (this.fPathEntryVariableManager != null) {
                this.fPathEntryVariableManager.shutdown();
            }
            this.fNewCProjectDescriptionManager.shutdown();
            this.savePluginPreferences();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.cdtLog = new CDTLogWriter(CCorePlugin.getDefault().getStateLocation().append(".log").toFile());
        this.configurePluginDebugOptions();
        this.getPluginPreferences().setDefault(PREF_USE_STRUCTURAL_PARSE_MODE, false);
        PositionTrackerManager.getInstance().install();
        this.fNewCProjectDescriptionManager = CProjectDescriptionManager.getInstance();
        Job post1 = this.fNewCProjectDescriptionManager.startup();
        this.fPathEntryVariableManager = new CdtVarPathEntryVariableManager();
        this.fPathEntryVariableManager.startup();
        this.fCoreModel = CoreModel.getDefault();
        this.fCoreModel.startup();
        this.pdomManager = new PDOMManager();
        Job post2 = this.pdomManager.startup();
        post1.schedule();
        post2.schedule();
    }

    public static HashMap getDefaultOptions() {
        HashMap<String, String> defaultOptions = new HashMap<String, String>(10);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        HashSet optionNames = CModelManager.OptionNames;
        String[] defaultPropertyNames = preferences.defaultPropertyNames();
        int i = 0;
        while (i < defaultPropertyNames.length) {
            String propertyName = defaultPropertyNames[i];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i;
        }
        String[] propertyNames = preferences.propertyNames();
        int i2 = 0;
        while (i2 < propertyNames.length) {
            String propertyName = propertyNames[i2];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i2;
        }
        defaultOptions.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        return defaultOptions;
    }

    public static String getOption(String optionName) {
        if (CORE_ENCODING.equals(optionName)) {
            return ResourcesPlugin.getEncoding();
        }
        if (CModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public static HashMap getOptions() {
        HashMap<String, String> options = new HashMap<String, String>(10);
        CCorePlugin plugin = CCorePlugin.getDefault();
        if (plugin != null) {
            Preferences preferences = plugin.getPluginPreferences();
            HashSet optionNames = CModelManager.OptionNames;
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            int i = 0;
            while (i < defaultPropertyNames.length) {
                String propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName));
                }
                ++i;
            }
            String[] propertyNames = preferences.propertyNames();
            int i2 = 0;
            while (i2 < propertyNames.length) {
                String propertyName = propertyNames[i2];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getString(propertyName).trim());
                }
                ++i2;
            }
            options.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        }
        return options;
    }

    public static void setOptions(HashMap newOptions) {
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        if (newOptions == null) {
            newOptions = CCorePlugin.getDefaultOptions();
        }
        Iterator keys = newOptions.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!CModelManager.OptionNames.contains(key) || key.equals(CORE_ENCODING)) continue;
            String value = (String)newOptions.get(key);
            preferences.setValue(key, value);
        }
        CCorePlugin.getDefault().savePluginPreferences();
    }

    public IConsole getConsole(String id) {
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "CBuildConsole");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String consoleID = configElements[j].getAttribute("id");
                        if (id == null && consoleID == null || id != null && id.equals(consoleID)) {
                            return (IConsole)configElements[j].createExecutableExtension("class");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return new IConsole(){
            private ConsoleOutputStream nullStream = new ConsoleOutputStream(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void write(byte[] b) throws IOException {
                }

                public void write(byte[] b, int off, int len) throws IOException {
                }

                public void write(int c) throws IOException {
                }
            };

            public void start(IProject project) {
            }

            public ConsoleOutputStream getOutputStream() {
                return this.nullStream;
            }

            public ConsoleOutputStream getInfoStream() {
                return this.nullStream;
            }

            public ConsoleOutputStream getErrorStream() {
                return this.nullStream;
            }
        };
    }

    public IConsole getConsole() {
        String consoleID = System.getProperty("org.eclipse.cdt.core.console");
        return this.getConsole(consoleID);
    }

    public ICExtensionReference[] getBinaryParserExtensions(IProject project) throws CoreException {
        ICExtensionReference[] ext = new ICExtensionReference[]{};
        if (project != null) {
            try {
                ICDescriptor cdesc = this.getCProjectDescription(project);
                ICExtensionReference[] cextensions = cdesc.get(BINARY_PARSER_UNIQ_ID, true);
                if (cextensions.length > 0) {
                    ArrayList<ICExtensionReference> list = new ArrayList<ICExtensionReference>(cextensions.length);
                    int i = 0;
                    while (i < cextensions.length) {
                        list.add(cextensions[i]);
                        ++i;
                    }
                    ext = list.toArray(ext);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return ext;
    }

    public IBinaryParser[] getBinaryParser(IProject project) throws CoreException {
        IBinaryParser parser;
        IBinaryParser[] parsers;
        block8: {
            parsers = null;
            if (project != null) {
                try {
                    ICDescriptor cdesc = this.getCProjectDescription(project);
                    ICExtensionReference[] cextensions = cdesc.get(BINARY_PARSER_UNIQ_ID, true);
                    if (cextensions.length <= 0) break block8;
                    ArrayList<IBinaryParser> list = new ArrayList<IBinaryParser>(cextensions.length);
                    int i = 0;
                    while (i < cextensions.length) {
                        IBinaryParser parser2 = null;
                        try {
                            parser2 = (IBinaryParser)((Object)cextensions[i].createExtension());
                        }
                        catch (ClassCastException classCastException) {}
                        if (parser2 != null) {
                            list.add(parser2);
                        }
                        ++i;
                    }
                    parsers = new IBinaryParser[list.size()];
                    list.toArray(parsers);
                }
                catch (CoreException coreException) {}
            }
        }
        if (parsers == null && (parser = this.getDefaultBinaryParser()) != null) {
            parsers = new IBinaryParser[]{parser};
        }
        return parsers;
    }

    public IBinaryParser getDefaultBinaryParser() throws CoreException {
        IExtensionPoint extensionPoint;
        IExtension extension;
        IBinaryParser parser = null;
        String id = this.getPluginPreferences().getDefaultString(PREF_BINARY_PARSER);
        if (id == null || id.length() == 0) {
            id = DEFAULT_BINARY_PARSER_UNIQ_ID;
        }
        if ((extension = (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, BINARY_PARSER_SIMPLE_ID)).getExtension(id)) != null) {
            IConfigurationElement[] element = extension.getConfigurationElements();
            int i = 0;
            while (i < element.length) {
                if (element[i].getName().equalsIgnoreCase("cextension")) {
                    parser = (IBinaryParser)element[i].createExecutableExtension("run");
                    break;
                }
                ++i;
            }
        } else {
            Status s = new Status(4, PLUGIN_ID, -1, CCorePlugin.getResourceString("CCorePlugin.exception.noBinaryFormat"), null);
            throw new CoreException((IStatus)s);
        }
        return parser;
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public static IPDOMManager getPDOMManager() {
        return CCorePlugin.getDefault().pdomManager;
    }

    public static IIndexManager getIndexManager() {
        return CCorePlugin.getDefault().pdomManager;
    }

    public IPathEntryVariableManager getPathEntryVariableManager() {
        return this.fPathEntryVariableManager;
    }

    public ICDescriptor getCProjectDescription(IProject project) throws CoreException {
        return this.fNewCProjectDescriptionManager.getDescriptorManager().getDescriptor(project);
    }

    public ICDescriptor getCProjectDescription(IProject project, boolean create) throws CoreException {
        return this.fNewCProjectDescriptionManager.getDescriptorManager().getDescriptor(project, create);
    }

    public void mapCProjectOwner(IProject project, String id, boolean override) throws CoreException {
        if (!override) {
            this.fNewCProjectDescriptionManager.getDescriptorManager().configure(project, id);
        } else {
            this.fNewCProjectDescriptionManager.getDescriptorManager().convert(project, id);
        }
    }

    public ICDescriptorManager getCDescriptorManager() {
        return this.fNewCProjectDescriptionManager.getDescriptorManager();
    }

    public IProject createCProject(final IProjectDescription description, final IProject projectHandle, IProgressMonitor monitor, final String projectID) throws CoreException, OperationCanceledException {
        CCorePlugin.getWorkspace().run(new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Creating C Project...", 3);
                    if (!projectHandle.exists()) {
                        projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    CCorePlugin.this.mapCProjectOwner(projectHandle, projectID, false);
                    CProjectNature.addCNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                monitor.done();
            }
        }, (ISchedulingRule)CCorePlugin.getWorkspace().getRoot(), 0, monitor);
        return projectHandle;
    }

    public IProject createCDTProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.createCDTProject(description, projectHandle, null, monitor);
    }

    public IProject createCDTProject(final IProjectDescription description, final IProject projectHandle, final String bsId, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        CCorePlugin.getWorkspace().run(new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Creating C Project...", 3);
                    if (!projectHandle.exists()) {
                        projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    CProjectNature.addCNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (bsId != null) {
                        ICConfigurationDescription prefCfg;
                        ICProjectDescription projDes = CCorePlugin.this.createProjectDescription(projectHandle, true);
                        ICConfigurationDescription[] cfgs = projDes.getConfigurations();
                        ICConfigurationDescription cfg = null;
                        int i = 0;
                        while (i < cfgs.length) {
                            if (bsId.equals(cfgs[i].getBuildSystemId())) {
                                cfg = cfgs[i];
                                break;
                            }
                            ++i;
                        }
                        if (cfg == null && (prefCfg = CCorePlugin.this.getPreferenceConfiguration(bsId)) != null) {
                            cfg = projDes.createConfiguration(CDataUtil.genId(prefCfg.getId()), prefCfg.getName(), prefCfg);
                        }
                        if (cfg != null) {
                            CCorePlugin.this.setProjectDescription(projectHandle, projDes);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                }
                monitor.done();
            }
        }, (ISchedulingRule)CCorePlugin.getWorkspace().getRoot(), 0, monitor);
        return projectHandle;
    }

    public void convertProjectFromCtoCC(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        if (projectHandle != null && projectHandle.hasNature("org.eclipse.cdt.core.cnature") && !projectHandle.hasNature("org.eclipse.cdt.core.ccnature")) {
            CCProjectNature.addCCNature(projectHandle, monitor);
        }
    }

    public void convertProjectToC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectHandle.getFullPath());
        this.createCProject(description, projectHandle, monitor, projectID);
    }

    public void convertProjectToNewC(IProject projectHandle, String bsId, IProgressMonitor monitor) throws CoreException {
        if (projectHandle == null || monitor == null || bsId == null) {
            throw new NullPointerException();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectHandle.getFullPath());
        this.createCDTProject(description, projectHandle, bsId, monitor);
    }

    public void convertProjectToCC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        this.createCProject(projectHandle.getDescription(), projectHandle, monitor, projectID);
        this.convertProjectFromCtoCC(projectHandle, monitor);
    }

    public void convertProjectToNewCC(IProject projectHandle, String bsId, IProgressMonitor monitor) throws CoreException {
        if (projectHandle == null || monitor == null || bsId == null) {
            throw new NullPointerException();
        }
        this.createCDTProject(projectHandle.getDescription(), projectHandle, bsId, monitor);
        this.convertProjectFromCtoCC(projectHandle, monitor);
    }

    public IProcessList getProcessList() throws CoreException {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "ProcessList");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            IConfigurationElement defaultContributor = null;
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("processList")) {
                        String platform = configElements[j].getAttribute("platform");
                        if (platform == null) {
                            if (defaultContributor == null) {
                                defaultContributor = configElements[j];
                            }
                        } else if (platform.equals(Platform.getOS())) {
                            return (IProcessList)configElements[0].createExecutableExtension("class");
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (defaultContributor != null) {
                return (IProcessList)defaultContributor.createExecutableExtension("class");
            }
        }
        return null;
    }

    public String[] getAllErrorParsersIDs() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ERROR_PARSER_SIMPLE_ID);
        String[] empty = new String[]{};
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            ArrayList<String> list = new ArrayList<String>(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                list.add(extensions[i].getUniqueIdentifier());
                ++i;
            }
            return list.toArray(empty);
        }
        return empty;
    }

    public IErrorParser[] getErrorParser(String id) {
        IErrorParser[] empty = new IErrorParser[]{};
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ERROR_PARSER_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                ArrayList<IErrorParser> list = new ArrayList<IErrorParser>(extensions.length);
                int i = 0;
                while (i < extensions.length) {
                    String parserID = extensions[i].getUniqueIdentifier();
                    if (id == null && parserID != null || id != null && id.equals(parserID)) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            IErrorParser parser = (IErrorParser)configElements[j].createExecutableExtension("class");
                            list.add(parser);
                            ++j;
                        }
                    }
                    ++i;
                }
                return list.toArray(empty);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return empty;
    }

    public IScannerInfoProvider getScannerInfoProvider(IProject project) {
        return this.fNewCProjectDescriptionManager.getScannerInfoProviderProxy(project);
    }

    public static IContentType getContentType(String filename) {
        return CContentTypes.getContentType(null, filename);
    }

    public static IContentType getContentType(IProject project, String filename) {
        return CContentTypes.getContentType(project, filename);
    }

    public static boolean usesProjectSpecificContentTypes(IProject project) {
        return CContentTypes.usesProjectSpecificContentTypes(project);
    }

    public static void setUseProjectSpecificContentTypes(IProject project, boolean val) {
        CContentTypes.setUseProjectSpecificContentTypes(project, val);
    }

    public void configurePluginDebugOptions() {
        if (CCorePlugin.getDefault().isDebugging()) {
            String option = Platform.getDebugOption((String)PARSER);
            if (option != null) {
                Util.VERBOSE_PARSER = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)PARSER_EXCEPTIONS)) != null) {
                Util.PARSER_EXCEPTIONS = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SCANNER)) != null) {
                Util.VERBOSE_SCANNER = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)MODEL)) != null) {
                Util.VERBOSE_MODEL = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
        }
    }

    public void setStructuralParseMode(boolean useNewParser) {
        this.getPluginPreferences().setValue(PREF_USE_STRUCTURAL_PARSE_MODE, useNewParser);
        this.savePluginPreferences();
    }

    public boolean useStructuralParseMode() {
        return this.getPluginPreferences().getBoolean(PREF_USE_STRUCTURAL_PARSE_MODE);
    }

    public CDOM getDOM() {
        return CDOM.getInstance();
    }

    public ICdtVariableManager getCdtVariableManager() {
        return CdtVariableManager.getDefault();
    }

    public IEnvironmentVariableManager getBuildEnvironmentManager() {
        return EnvironmentVariableManager.getDefault();
    }

    public ICConfigurationDescription getPreferenceConfiguration(String buildSystemId) throws CoreException {
        return this.fNewCProjectDescriptionManager.getPreferenceConfiguration(buildSystemId);
    }

    public ICConfigurationDescription getPreferenceConfiguration(String buildSystemId, boolean write) throws CoreException {
        return this.fNewCProjectDescriptionManager.getPreferenceConfiguration(buildSystemId, write);
    }

    public void setPreferenceConfiguration(String buildSystemId, ICConfigurationDescription des) throws CoreException {
        this.fNewCProjectDescriptionManager.setPreferenceConfiguration(buildSystemId, des);
    }

    public ICProjectDescription createProjectDescription(IProject project, boolean loadIfExists) throws CoreException {
        return this.fNewCProjectDescriptionManager.createProjectDescription(project, loadIfExists);
    }

    public ICProjectDescription createProjectDescription(IProject project, boolean loadIfExists, boolean creating) throws CoreException {
        return this.fNewCProjectDescriptionManager.createProjectDescription(project, loadIfExists, creating);
    }

    public ICProjectDescription getProjectDescription(IProject project) {
        return this.fNewCProjectDescriptionManager.getProjectDescription(project);
    }

    public void setProjectDescription(IProject project, ICProjectDescription des) throws CoreException {
        this.fNewCProjectDescriptionManager.setProjectDescription(project, des);
    }

    public void setProjectDescription(IProject project, ICProjectDescription des, boolean force, IProgressMonitor monitor) throws CoreException {
        this.fNewCProjectDescriptionManager.setProjectDescription(project, des, force, monitor);
    }

    public ICProjectDescription getProjectDescription(IProject project, boolean write) {
        return this.fNewCProjectDescriptionManager.getProjectDescription(project, write);
    }

    public void updateProjectDescriptions(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        this.fNewCProjectDescriptionManager.updateProjectDescriptions(projects, monitor);
    }

    public boolean isNewStyleProject(IProject project) {
        return this.fNewCProjectDescriptionManager.isNewStyleProject(project);
    }

    public boolean isNewStyleProject(ICProjectDescription des) {
        return this.fNewCProjectDescriptionManager.isNewStyleProject(des);
    }

    public ICProjectDescriptionManager getProjectDescriptionManager() {
        return this.fNewCProjectDescriptionManager;
    }
}

