/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public abstract class ResourceChangeHandlerBase
implements IResourceChangeListener {
    private IWorkspaceRoot fRoot = ResourcesPlugin.getWorkspace().getRoot();

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResourceMoveHandler handler = this.createResourceMoveHandler(event);
            this.doHahdleResourceMove(event, handler);
        }
    }

    protected boolean shouldVisit(IProject project) {
        try {
            return project.isOpen() ? project.hasNature("org.eclipse.cdt.core.cnature") : true;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    protected void doHahdleResourceMove(IResourceChangeEvent event, IResourceMoveHandler handler) {
        switch (event.getType()) {
            case 2: {
                IProject project = (IProject)event.getResource();
                if (!this.shouldVisit(project)) break;
                handler.handleProjectClose(project);
                break;
            }
            case 1: {
                IResourceDelta resDelta = event.getDelta();
                if (resDelta == null) break;
                try {
                    DeltaVisitor rcChecker = new DeltaVisitor(handler, resDelta);
                    resDelta.accept((IResourceDeltaVisitor)rcChecker);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
                break;
            }
        }
        handler.done();
    }

    protected abstract IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent var1);

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        private Map fMoveMap = new HashMap();
        private IResourceMoveHandler fHandler;

        public DeltaVisitor(IResourceMoveHandler handler, IResourceDelta rootDelta) {
            this.fHandler = handler;
        }

        private IResource getResource(IPath path, IResource baseResource) {
            switch (baseResource.getType()) {
                case 1: {
                    return ResourceChangeHandlerBase.this.fRoot.getFile(path);
                }
                case 2: {
                    return ResourceChangeHandlerBase.this.fRoot.getFolder(path);
                }
                case 4: {
                    return ResourceChangeHandlerBase.this.fRoot.getProject(path.segment(0));
                }
            }
            throw new IllegalArgumentException();
        }

        private boolean checkInitHandleResourceMove(IResource fromRc, IResource toRc) {
            if (this.fMoveMap.put(fromRc, toRc) == null) {
                return this.fHandler.handleResourceMove(fromRc, toRc);
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource dResource = delta.getResource();
            if (dResource.getType() == 4 && !ResourceChangeHandlerBase.this.shouldVisit((IProject)dResource)) {
                return false;
            }
            boolean resume = true;
            boolean removed = false;
            switch (delta.getKind()) {
                case 2: {
                    removed = true;
                }
                case 4: {
                    int flags = delta.getFlags();
                    if ((flags & 0x2000) != 0) {
                        IPath path = delta.getMovedToPath();
                        if (path == null) break;
                        IResource toRc = this.getResource(path, dResource);
                        resume = this.checkInitHandleResourceMove(dResource, toRc);
                        break;
                    }
                    if ((flags & 0x1000) != 0) {
                        IPath path = delta.getMovedFromPath();
                        if (path == null) break;
                        IResource fromRc = this.getResource(path, dResource);
                        resume = this.checkInitHandleResourceMove(fromRc, dResource);
                        break;
                    }
                    if (!removed) break;
                    resume = this.fHandler.handleResourceRemove(dResource);
                }
            }
            return resume;
        }
    }

    public static interface IResourceMoveHandler {
        public boolean handleResourceMove(IResource var1, IResource var2);

        public boolean handleResourceRemove(IResource var1);

        public void handleProjectClose(IProject var1);

        public void done();
    }
}

