/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryNameKey;

public class SettingsSet {
    public static final int READ_ONLY = 1;
    public static final int WRITABLE = 2;
    private SettingLevel[] fLevels;

    public SettingsSet(int num) {
        this.fLevels = new SettingLevel[num];
        int i = 0;
        while (i < num) {
            this.fLevels[i] = new SettingLevel();
            ++i;
        }
    }

    public SettingLevel[] getLevels() {
        return (SettingLevel[])this.fLevels.clone();
    }

    public void adjustOverrideState() {
        HashSet set = new HashSet();
        int i = 0;
        while (i < this.fLevels.length) {
            SettingLevel level = this.fLevels[i];
            if (level.isOverrideSupported() && level.fOverrideSet != null) {
                set.addAll(level.fOverrideSet);
            }
            this.adjustOverrideState(this.fLevels[i], set);
            ++i;
        }
    }

    private void adjustOverrideState(SettingLevel level, Set overridenSet) {
        EntryInfo[] infos = level.getInfos();
        int i = 0;
        while (i < infos.length) {
            EntryInfo info = infos[i];
            if (overridenSet.add(info.getEntry().getName())) {
                info.makeOverridden(false);
            } else {
                info.makeOverridden(true);
            }
            ++i;
        }
    }

    public ICLanguageSettingEntry[] getEntries() {
        return this.getEntries(3);
    }

    public ICLanguageSettingEntry[] getEntries(int types) {
        this.adjustOverrideState();
        ArrayList entries = new ArrayList();
        int i = 0;
        while (i < this.fLevels.length) {
            if (this.isCompatible(this.fLevels[i], types)) {
                this.getEntries(this.fLevels[i], entries);
            }
            ++i;
        }
        return entries.toArray(new ICLanguageSettingEntry[entries.size()]);
    }

    private void getEntries(SettingLevel level, List list) {
        EntryInfo[] infos = level.getInfos();
        int i = 0;
        while (i < infos.length) {
            EntryInfo info = infos[i];
            if (!info.isOverridden()) {
                list.add(info.getEntry());
            }
            ++i;
        }
    }

    private boolean isCompatible(SettingLevel level, int types) {
        if ((types & 1) == 0 && level.isReadOnly()) {
            return false;
        }
        return (types & 2) != 0 || level.isReadOnly();
    }

    private int getWritableLevelNum() {
        int i = 0;
        while (i < this.fLevels.length) {
            if (!this.fLevels[i].isReadOnly()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getOverrideLevelNum() {
        int i = 0;
        while (i < this.fLevels.length) {
            if (this.fLevels[i].isOverrideSupported()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void applyEntries(ICLanguageSettingEntry[] entries) {
        SettingLevel level;
        HashMap map = this.getEntryLevelMap(3);
        HashMap mapCopy = (HashMap)map.clone();
        Map[] clearedInfos = new Map[this.fLevels.length];
        int i = 0;
        while (i < this.fLevels.length) {
            if (!this.fLevels[i].isReadOnly()) {
                clearedInfos[i] = this.fLevels[i].clearAndGetMap();
            }
            ++i;
        }
        int writableLevel = this.getWritableLevelNum();
        int i2 = 0;
        while (i2 < entries.length) {
            int levelNum;
            Integer levelInteger;
            ICLanguageSettingEntry entry = entries[i2];
            EntryNameKey key = new EntryNameKey(entry);
            Object[] o = (Object[])map.get(key);
            if (o != null) {
                mapCopy.remove(key);
                levelInteger = (Integer)o[0];
            } else {
                levelInteger = null;
            }
            int n = levelNum = levelInteger != null ? levelInteger : writableLevel;
            if (levelNum >= 0 && !(level = this.fLevels[levelNum]).isReadOnly()) {
                EntryInfo info;
                Map clearedInfo = clearedInfos[levelNum];
                Object customInfo = null;
                if (clearedInfo != null && (info = (EntryInfo)clearedInfo.get(key)) != null && entry.equalsByContents(info.getEntry())) {
                    customInfo = info.getCustomInfo();
                }
                level.addEntry(entry, customInfo);
            }
            ++i2;
        }
        int overrideLevel = this.getOverrideLevelNum();
        if (overrideLevel >= 0 && (level = this.fLevels[overrideLevel]).isOverrideSupported() && !mapCopy.isEmpty()) {
            Iterator iter = mapCopy.keySet().iterator();
            while (iter.hasNext()) {
                String str = ((EntryNameKey)iter.next()).getEntry().getName();
                if (str == null) continue;
                level.addOverrideName(str);
            }
        }
        this.adjustOverrideState();
    }

    public HashMap getEntryLevelMap(int types) {
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.fLevels.length) {
            if (this.isCompatible(this.fLevels[i], types)) {
                this.addLevelInfoToMap(this.fLevels[i], i, map);
            }
            ++i;
        }
        return map;
    }

    private void addLevelInfoToMap(SettingLevel level, int l, Map map) {
        EntryInfo[] infos = level.getInfos();
        int i = 0;
        while (i < infos.length) {
            EntryInfo info = infos[i];
            EntryNameKey key = info.getNameKey();
            if (!map.containsKey(key)) {
                map.put(key, new Object[]{new Integer(l), info.getEntry()});
            }
            ++i;
        }
    }

    public static class EntryInfo {
        private ICLanguageSettingEntry fEntry;
        private EntryNameKey fNameKey;
        private boolean fIsOverRidden;
        private Object fCustomInfo;

        private EntryInfo(ICLanguageSettingEntry entry, Object customInfo) {
            this.fEntry = entry;
            this.fCustomInfo = customInfo;
        }

        public EntryNameKey getNameKey() {
            if (this.fNameKey == null) {
                this.fNameKey = new EntryNameKey(this.fEntry);
            }
            return this.fNameKey;
        }

        private void makeOverridden(boolean overrridden) {
            this.fIsOverRidden = overrridden;
        }

        public ICLanguageSettingEntry getEntry() {
            return this.fEntry;
        }

        public boolean isOverridden() {
            return this.fIsOverRidden;
        }

        public Object getCustomInfo() {
            return this.fCustomInfo;
        }
    }

    public class SettingLevel {
        private int fFlagsToSet;
        private int fFlagsToClear;
        private boolean fIsReadOnly;
        private boolean fIsOverrideSupported;
        private LinkedHashMap fEntries = new LinkedHashMap();
        HashSet fOverrideSet;
        private Object fContext;

        private SettingLevel() {
        }

        public boolean isReadOnly() {
            return this.fIsReadOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.fIsReadOnly = readOnly;
        }

        public boolean isOverrideSupported() {
            return this.fIsOverrideSupported;
        }

        public void setOverrideSupported(boolean supported) {
            this.fIsOverrideSupported = supported;
        }

        public void setFlagsToSet(int flags) {
            this.fFlagsToSet = flags;
        }

        public boolean containsOverrideInfo() {
            return this.fOverrideSet != null;
        }

        public void setFlagsToClear(int flags) {
            this.fFlagsToClear = flags;
        }

        public int getFlagsToSet() {
            return this.fFlagsToSet;
        }

        public int getFlagsToClear() {
            return this.fFlagsToClear;
        }

        public int getFlags(int baseFlags) {
            return (baseFlags | this.fFlagsToSet) & ~this.fFlagsToClear;
        }

        public Set getOverrideSet() {
            if (this.fOverrideSet != null) {
                return (HashSet)this.fOverrideSet.clone();
            }
            return new HashSet();
        }

        public void addEntries(ICLanguageSettingEntry[] entries) {
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    this.addEntry(entries[i]);
                    ++i;
                }
            }
        }

        public void addEntries(List list) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                this.addEntry((ICLanguageSettingEntry)list.get(i));
                ++i;
            }
        }

        public void addEntry(ICLanguageSettingEntry entry) {
            this.addEntry(entry, null);
        }

        public void addEntry(ICLanguageSettingEntry entry, Object customInfo) {
            entry = CDataUtil.createEntry(entry, this.fFlagsToSet, this.fFlagsToClear);
            EntryInfo info = new EntryInfo(entry, customInfo);
            this.fEntries.put(info.getNameKey(), info);
        }

        public void addOverrideName(String name) {
            if (this.fOverrideSet == null) {
                this.fOverrideSet = new HashSet();
            }
            this.fOverrideSet.add(name);
        }

        public void addOverrideNameSet(Set set) {
            if (set == null) {
                return;
            }
            if (this.fOverrideSet != null) {
                this.fOverrideSet.addAll(set);
            } else if (set.size() != 0) {
                this.fOverrideSet = new HashSet(set);
            }
        }

        public void removeOverrideName(String name) {
            if (this.fOverrideSet == null) {
                return;
            }
            this.fOverrideSet.remove(name);
            if (this.fOverrideSet.size() == 0) {
                this.fOverrideSet = null;
            }
        }

        public void clear() {
            this.fEntries.clear();
            this.fOverrideSet = null;
        }

        public Map clearAndGetMap() {
            LinkedHashMap map = this.fEntries;
            this.fEntries = new LinkedHashMap();
            this.fOverrideSet = null;
            return map;
        }

        public EntryInfo[] getInfos() {
            return this.fEntries.values().toArray(new EntryInfo[this.fEntries.size()]);
        }

        public ICLanguageSettingEntry[] getEntries() {
            List list = this.getEntriesList(false);
            return list.toArray(new ICLanguageSettingEntry[list.size()]);
        }

        public ICLanguageSettingEntry[] getEntries(boolean includeOverridden) {
            List list = this.getEntriesList(includeOverridden);
            return list.toArray(new ICLanguageSettingEntry[list.size()]);
        }

        public List getEntriesList(boolean includeOverridden) {
            ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>();
            EntryInfo[] infos = this.getInfos();
            int i = 0;
            while (i < infos.length) {
                if (includeOverridden || !infos[i].isOverridden()) {
                    list.add(infos[i].getEntry());
                }
                ++i;
            }
            return list;
        }

        public Object getContext() {
            return this.fContext;
        }

        public void setContext(Object context) {
            this.fContext = context;
        }
    }
}

