/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SharedDefaults
extends HashMap {
    private static final long serialVersionUID = 0L;
    public Document document;
    private File parsedXML;
    private File backUpSharedXML;
    private HashMap sharedDefaultsMap = new HashMap();
    private HashMap persistDataMap = new HashMap();
    private HashMap tableDataMap = new HashMap();
    private static final String SHARED_DEFAULTS_DOT_XML = "shareddefaults.xml";
    private static final String SHARED_DEFAULTS_DOT_BACKUP_DOT_XML = "shareddefaults.backup.xml";
    public static final String SET = "SET";
    public static final String GET = "GET";
    public static final String ResourceFolder = "resources";
    private static SharedDefaults SHAREDDEFAULTS = new SharedDefaults();

    public static SharedDefaults getInstance() {
        return SHAREDDEFAULTS;
    }

    public SharedDefaults() {
        this.parsedXML = TemplateEngineHelper.getSharedDefaultLocation(SHARED_DEFAULTS_DOT_XML);
        this.backUpSharedXML = TemplateEngineHelper.getSharedDefaultLocation(SHARED_DEFAULTS_DOT_BACKUP_DOT_XML);
        if (this.backUpSharedXML.exists()) {
            this.swapXML();
        }
        this.initSharedDefaults();
    }

    private void initSharedDefaults() {
        String key = null;
        String value = null;
        try {
            long length = this.parsedXML.length();
            if (length == 0L) {
                this.parsedXML = this.createDefaultXMLFormat(this.parsedXML);
            }
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log(exp);
        }
        List sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int listSize = sharedElementList.size();
        int i = 0;
        while (i < listSize) {
            Element xmlElement = (Element)sharedElementList.get(i);
            key = xmlElement.getAttribute("id");
            value = xmlElement.getAttribute("value");
            if (key != null && !key.trim().equals("")) {
                this.sharedDefaultsMap.put(key, value);
            }
            ++i;
        }
    }

    public void updateShareDefaultsMap(Map sharedMap) {
        this.sharedDefaultsMap.putAll(sharedMap);
        this.persistSharedValueMap();
    }

    public void persistSharedValueMap() {
        this.generateSharedXML(this.backUpSharedXML);
        this.generateSharedXML(this.parsedXML);
        this.swapXML();
    }

    public Map getSharedDefaultsMap() {
        return this.sharedDefaultsMap;
    }

    public void addToBackEndStorage(String name, String value) {
        if (this.sharedDefaultsMap != null) {
            this.tableDataMap.putAll(this.sharedDefaultsMap);
        }
        this.tableDataMap.put(name, value);
        this.updateShareDefaultsMap(this.tableDataMap);
    }

    public void updateToBackEndStorage(String updateName, String updateValue) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log(exp);
        }
        this.persistDataMap.putAll(this.sharedDefaultsMap);
        List sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int elementListSize = sharedElementList.size();
        int i = 0;
        while (i < elementListSize) {
            Element xmlElement = (Element)sharedElementList.get(i);
            String name = xmlElement.getAttribute("id");
            if (updateName.equals(name)) {
                this.persistDataMap.put(updateName, updateValue);
            }
            ++i;
        }
        this.updateShareDefaultsMap(this.persistDataMap);
    }

    public void deleteBackEndStorage(String[] deleteName) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log(exp);
        }
        List sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int elementListSize = sharedElementList.size();
        int i = 0;
        while (i < elementListSize) {
            Element xmlElement = (Element)sharedElementList.get(i);
            String name = xmlElement.getAttribute("id");
            int k = 0;
            while (k < deleteName.length) {
                if (deleteName[k].equals(name)) {
                    xmlElement.removeAttribute(name);
                    this.sharedDefaultsMap.remove(name);
                }
                ++k;
            }
            ++i;
        }
        this.updateShareDefaultsMap(this.sharedDefaultsMap);
    }

    /*
     * Exception decompiling
     */
    private File createDefaultXMLFormat(File xmlFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 152->158)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateSharedXML(File xmlFile) {
        Document d;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            TemplateEngineUtil.log(e);
            return;
        }
        Node rootElement = d.appendChild(d.createElement("SharedRoot"));
        Iterator i = this.sharedDefaultsMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Element element = (Element)rootElement.appendChild(d.createElement("SharedProperty"));
            element.setAttribute("id", key);
            element.setAttribute("value", (String)this.sharedDefaultsMap.get(key));
        }
        DOMSource domSource = new DOMSource(d);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StreamResult fileResult = new StreamResult(xmlFile);
        try {
            transFactory.newTransformer().transform(domSource, fileResult);
        }
        catch (Throwable t) {
            TemplateEngineUtil.log(t);
        }
    }

    private void swapXML() {
        if (this.parsedXML.exists()) {
            this.parsedXML.delete();
        }
        this.backUpSharedXML.renameTo(this.parsedXML);
    }
}

