/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.templateengine.SharedDefaults;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateEngine {
    public static String TEMPLATES_EXTENSION_ID = "org.eclipse.cdt.core.templates";
    public static String TEMPLATE_ASSOCIATIONS_EXTENSION_ID = "org.eclipse.cdt.core.templateAssociations";
    private static TemplateEngine TEMPLATE_ENGINE;
    private Map templateInfoMap = new LinkedHashMap();

    private TemplateEngine() {
        this.initializeTemplateInfoMap();
    }

    public TemplateCore[] getTemplates() {
        TemplateInfo[] templateInfoArray = this.getTemplateInfos();
        ArrayList<TemplateCore> tcores = new ArrayList<TemplateCore>();
        int i = 0;
        while (i < templateInfoArray.length) {
            TemplateInfo info = templateInfoArray[i];
            try {
                tcores.add(TemplateCore.getTemplate(info));
            }
            catch (TemplateInitializationException e) {
                CCorePlugin.log(CCorePlugin.createStatus(e.getMessage(), e));
            }
            ++i;
        }
        return tcores.toArray(new TemplateCore[tcores.size()]);
    }

    public TemplateCore getFirstTemplate(String projectType, String toolChain, String usageFilter) {
        TemplateInfo[] infos = this.getTemplateInfos(projectType, toolChain, usageFilter);
        if (infos.length > 0) {
            try {
                return TemplateCore.getTemplate(infos[0]);
            }
            catch (TemplateInitializationException tie) {
                CCorePlugin.log(tie);
            }
        }
        return null;
    }

    public TemplateCore getFirstTemplate(String projectType) {
        return this.getFirstTemplate(projectType, null, null);
    }

    public TemplateCore[] getTemplates(String projectType, String toolChain, String usageFilter) {
        TemplateInfo[] templateInfoArray = this.getTemplateInfos(projectType, toolChain, usageFilter);
        ArrayList<TemplateCore> templatesList = new ArrayList<TemplateCore>();
        int i = 0;
        while (i < templateInfoArray.length) {
            TemplateInfo info = templateInfoArray[i];
            try {
                templatesList.add(TemplateCore.getTemplate(info));
            }
            catch (TemplateInitializationException tie) {
                CCorePlugin.log(tie);
            }
            ++i;
        }
        return templatesList.toArray(new TemplateCore[templatesList.size()]);
    }

    public TemplateCore[] getTemplates(String projectType, String toolChain) {
        return this.getTemplates(projectType, toolChain, null);
    }

    public TemplateCore[] getTemplates(String projectType) {
        return this.getTemplates(projectType, null);
    }

    public TemplateCore getTemplateById(String templateId) {
        TemplateCore[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            TemplateCore template = templates[i];
            if (template.getTemplateId().equalsIgnoreCase(templateId)) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public static Map getSharedDefaults() {
        return SharedDefaults.getInstance().getSharedDefaultsMap();
    }

    public void updateSharedDefaults(TemplateCore template) {
        HashMap tobePersisted = new HashMap();
        Map valueStore = template.getValueStore();
        Iterator i = template.getPersistTrueIDs().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            tobePersisted.put(key, valueStore.get(key));
        }
        SharedDefaults.getInstance().updateShareDefaultsMap(tobePersisted);
    }

    public static TemplateEngine getDefault() {
        if (TEMPLATE_ENGINE == null) {
            TEMPLATE_ENGINE = new TemplateEngine();
        }
        return TEMPLATE_ENGINE;
    }

    private void initializeTemplateInfoMap() {
        String templateId = null;
        String location = null;
        String pluginId = null;
        String projectType = null;
        String filterPattern = null;
        boolean isCategory = false;
        Object extraPagesProvider = null;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATES_EXTENSION_ID).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            pluginId = extension.getNamespaceIdentifier();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement config = configElements[j];
                templateId = config.getAttribute("id");
                location = config.getAttribute("location");
                projectType = config.getAttribute("projectType");
                filterPattern = config.getAttribute("filterPattern");
                isCategory = Boolean.valueOf(config.getAttribute("isCategory"));
                String providerAttribute = config.getAttribute("pagesAfterTemplateSelectionProvider");
                if (providerAttribute != null) {
                    try {
                        extraPagesProvider = config.createExecutableExtension("pagesAfterTemplateSelectionProvider");
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(CCorePlugin.createStatus("Unable to create extra pages for " + providerAttribute, e));
                    }
                }
                IConfigurationElement[] toolChainConfigs = config.getChildren("toolChain");
                LinkedHashSet<String> toolChainIdSet = new LinkedHashSet<String>();
                int k = 0;
                while (k < toolChainConfigs.length) {
                    toolChainIdSet.add(toolChainConfigs[k].getAttribute("id"));
                    ++k;
                }
                TemplateInfo templateInfo = new TemplateInfo(templateId, projectType, filterPattern, location, pluginId, toolChainIdSet, extraPagesProvider, isCategory);
                if (!this.templateInfoMap.containsKey(projectType)) {
                    this.templateInfoMap.put(projectType, new ArrayList());
                }
                ((List)this.templateInfoMap.get(projectType)).add(templateInfo);
                ++j;
            }
            ++i;
        }
        this.addToolChainsToTemplates();
    }

    private void addToolChainsToTemplates() {
        String templateId = null;
        TemplateCore[] templates = this.getTemplates();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATE_ASSOCIATIONS_EXTENSION_ID).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement config = configElements[j];
                templateId = config.getAttribute("id");
                IConfigurationElement[] toolChainConfigs = config.getChildren("toolChain");
                LinkedHashSet<String> toolChainIdSet = new LinkedHashSet<String>();
                int k = 0;
                while (k < toolChainConfigs.length) {
                    toolChainIdSet.add(toolChainConfigs[k].getAttribute("id"));
                    ++k;
                }
                k = 0;
                while (k < templates.length) {
                    String id = templates[k].getTemplateInfo().getTemplateId();
                    if (id == null) {
                        id = templates[k].getTemplateId();
                    }
                    if (id != null && id.equals(templateId)) {
                        toolChainIdSet.addAll(Arrays.asList(templates[k].getTemplateInfo().getToolChainIds()));
                        templates[k].getTemplateInfo().setToolChainSet(toolChainIdSet);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public TemplateInfo[] getTemplateInfos(String projectType, String toolChain, String usageFilter) {
        List templateInfoList = (List)this.templateInfoMap.get(projectType.trim());
        ArrayList<TemplateInfo> matchedTemplateInfoList = new ArrayList<TemplateInfo>();
        if (templateInfoList != null) {
            Iterator i = templateInfoList.iterator();
            while (i.hasNext()) {
                TemplateInfo templateInfo = (TemplateInfo)i.next();
                String filterPattern = templateInfo.getFilterPattern();
                String[] toolChains = templateInfo.getToolChainIds();
                if (toolChain != null) {
                    int j = 0;
                    while (j < toolChains.length) {
                        if (toolChains[j].equals(toolChain)) {
                            if (usageFilter != null && filterPattern.matches(usageFilter)) {
                                matchedTemplateInfoList.add(templateInfo);
                            } else if (usageFilter == null) {
                                matchedTemplateInfoList.add(templateInfo);
                            }
                        }
                        ++j;
                    }
                    continue;
                }
                if (usageFilter != null && filterPattern.matches(usageFilter)) {
                    matchedTemplateInfoList.add(templateInfo);
                    continue;
                }
                if (usageFilter != null) continue;
                matchedTemplateInfoList.add(templateInfo);
            }
        }
        return matchedTemplateInfoList.toArray(new TemplateInfo[matchedTemplateInfoList.size()]);
    }

    public TemplateInfo[] getTemplateInfos(String projectType, String toolChain) {
        return this.getTemplateInfos(projectType, toolChain, null);
    }

    public TemplateInfo[] getTemplateInfos(String projectType) {
        return this.getTemplateInfos(projectType, null, null);
    }

    public TemplateInfo[] getTemplateInfos() {
        ArrayList infoList = new ArrayList();
        Iterator i = this.templateInfoMap.values().iterator();
        while (i.hasNext()) {
            infoList.addAll((List)i.next());
        }
        return infoList.toArray(new TemplateInfo[infoList.size()]);
    }

    public Map getTemplateInfoMap() {
        return this.templateInfoMap;
    }

    public URL getTemplateSchemaURL() throws IOException {
        return FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.cdt.core").getEntry("schema/TemplateDescriptorSchema.xsd"));
    }

    public static List getChildrenOfElement(Element element) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                list.add(child);
            }
            ++i;
        }
        return list;
    }

    public static List getChildrenOfElementByTag(Element element, String tag) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(tag)) {
                list.add(child);
            }
            ++i;
        }
        return list;
    }
}

