/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessParameter;
import org.w3c.dom.Element;

public class ProcessArgument {
    static final String ELEM_NAME = "name";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_ELEMENT = "element";
    private static final String ELEM_SIMPLE = "simple";
    private static final String ELEM_SIMPLE_ARRAY = "simple-array";
    private static final String ELEM_COMPLEX = "complex";
    private static final String ELEM_COMPLEX_ARRAY = "complex-array";
    private String name;
    private byte type;
    private String simpleValue;
    private String[] simpleValueArray;
    private ProcessArgument[] complexValue;
    private ProcessArgument[][] complexValueArray;
    private String resolvedSimpleValue;
    private String[] resolvedSimpleValueArray;
    private TemplateCore template;
    private Set macros;
    private boolean resolved;
    private ProcessParameter externalParam;

    public ProcessArgument(TemplateCore template, Element elem) {
        block9: {
            String elemName;
            block11: {
                block10: {
                    block8: {
                        this.template = template;
                        this.name = elem.getAttribute(ELEM_NAME);
                        elemName = elem.getNodeName();
                        if (!elemName.equals(ELEM_SIMPLE)) break block8;
                        this.type = 1;
                        this.simpleValue = elem.getAttribute(ELEM_VALUE);
                        this.collectMacros(this.simpleValue);
                        break block9;
                    }
                    if (!elemName.equals(ELEM_SIMPLE_ARRAY)) break block10;
                    this.type = (byte)2;
                    List valueElements = TemplateEngine.getChildrenOfElementByTag(elem, ELEM_ELEMENT);
                    this.simpleValueArray = new String[valueElements.size()];
                    int i = 0;
                    int l = valueElements.size();
                    while (i < l) {
                        this.simpleValueArray[i] = ((Element)valueElements.get(i)).getAttribute(ELEM_VALUE);
                        this.collectMacros(this.simpleValueArray[i]);
                        ++i;
                    }
                    break block9;
                }
                if (!elemName.equals(ELEM_COMPLEX)) break block11;
                this.type = (byte)3;
                List children = TemplateEngine.getChildrenOfElement(elem);
                this.complexValue = new ProcessArgument[children.size()];
                int i = 0;
                int l = children.size();
                while (i < l) {
                    this.complexValue[i] = new ProcessArgument(template, (Element)children.get(i));
                    Set subMacros = this.complexValue[i].getMacros();
                    if (this.macros == null) {
                        this.macros = new HashSet();
                    }
                    if (subMacros != null) {
                        this.macros.addAll(subMacros);
                    }
                    ++i;
                }
                break block9;
            }
            if (!elemName.equals(ELEM_COMPLEX_ARRAY)) break block9;
            this.type = (byte)4;
            List valueElements = TemplateEngine.getChildrenOfElementByTag(elem, ELEM_ELEMENT);
            this.complexValueArray = new ProcessArgument[valueElements.size()][];
            int i = 0;
            int l = valueElements.size();
            while (i < l) {
                List children = TemplateEngine.getChildrenOfElement((Element)valueElements.get(i));
                this.complexValueArray[i] = new ProcessArgument[children.size()];
                int j = 0;
                int l2 = children.size();
                while (j < l2) {
                    this.complexValueArray[i][j] = new ProcessArgument(template, (Element)children.get(j));
                    Set subMacros = this.complexValueArray[i][j].getMacros();
                    if (subMacros != null) {
                        if (this.macros == null) {
                            this.macros = new HashSet();
                        }
                        this.macros.addAll(subMacros);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ProcessArgument(TemplateCore template, ProcessParameter param) {
        this.template = template;
        this.name = param.getName();
        this.type = param.getType();
        this.macros = new HashSet();
        this.macros.add(this.name);
        this.simpleValue = ProcessHelper.getReplaceMarker(this.name);
        this.externalParam = param;
    }

    private void collectMacros(String value) {
        if (value == null) {
            return;
        }
        if (this.macros == null) {
            this.macros = new HashSet();
        }
        this.macros.addAll(ProcessHelper.getReplaceKeys(value));
    }

    public String getName() {
        return this.name;
    }

    public byte getParameterType() {
        return this.type;
    }

    public String getSimpleValue() {
        return this.resolved ? this.resolvedSimpleValue : this.simpleValue;
    }

    public String[] getSimpleArrayValue() {
        return this.resolved ? this.resolvedSimpleValueArray : this.simpleValueArray;
    }

    public ProcessArgument[] getComplexValue() {
        return this.complexValue;
    }

    public ProcessArgument[][] getComplexArrayValue() {
        return this.complexValueArray;
    }

    public boolean isOfParameterType(ProcessParameter param) {
        if (param.getType() != this.type || !param.getName().equals(this.name)) {
            return false;
        }
        switch (this.type) {
            case 1: {
                return this.simpleValue != null || param.isNullable();
            }
            case 2: {
                return true;
            }
            case 3: {
                ProcessParameter[] params = param.getComplexChildren();
                if (params.length != this.complexValue.length) {
                    return false;
                }
                int i = 0;
                while (i < this.complexValue.length) {
                    if (!this.complexValue[i].isOfParameterType(params[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 4: {
                ProcessParameter[] params = param.getComplexChildren();
                int i = 0;
                while (i < this.complexValueArray.length) {
                    ProcessArgument[] complexValue = this.complexValueArray[i];
                    if (params.length != complexValue.length) {
                        return false;
                    }
                    int j = 0;
                    while (j < complexValue.length) {
                        if (!complexValue[j].isOfParameterType(params[j])) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean areAllMacrosExpandable() {
        switch (this.type) {
            case 1: 
            case 2: {
                if (this.type == 1 && this.externalParam != null) {
                    return this.externalParam.isNullable() || this.template.getValueStore().get(this.name) != null;
                }
                if (this.macros == null || this.macros.size() == 0) {
                    return true;
                }
                Map valueStore = this.template.getValueStore();
                Iterator i = this.macros.iterator();
                while (i.hasNext()) {
                    String macro = (String)i.next();
                    if (valueStore.get(macro) != null) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                int i = 0;
                while (i < this.complexValue.length) {
                    ProcessArgument arg = this.complexValue[i];
                    if (!arg.areAllMacrosExpandable()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 4: {
                int i = 0;
                while (i < this.complexValueArray.length) {
                    ProcessArgument[] complexValue = this.complexValueArray[i];
                    int j = 0;
                    while (j < complexValue.length) {
                        ProcessArgument arg = complexValue[j];
                        if (!arg.areAllMacrosExpandable()) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
        }
        return true;
    }

    public String getFirstNonExpandableMacro() {
        switch (this.type) {
            case 1: 
            case 2: {
                if (this.macros == null || this.macros.size() == 0) {
                    return null;
                }
                Map valueStore = this.template.getValueStore();
                Iterator i = this.macros.iterator();
                while (i.hasNext()) {
                    String macro = (String)i.next();
                    if (valueStore.get(macro) != null) continue;
                    return macro;
                }
                return null;
            }
            case 3: {
                int i = 0;
                while (i < this.complexValue.length) {
                    ProcessArgument arg = this.complexValue[i];
                    String macro = arg.getFirstNonExpandableMacro();
                    if (macro != null) {
                        return macro;
                    }
                    ++i;
                }
                return null;
            }
            case 4: {
                int i = 0;
                while (i < this.complexValueArray.length) {
                    ProcessArgument[] complexValue = this.complexValueArray[i];
                    int j = 0;
                    while (j < complexValue.length) {
                        ProcessArgument arg = complexValue[j];
                        String macro = arg.getFirstNonExpandableMacro();
                        if (macro != null) {
                            return macro;
                        }
                        ++j;
                    }
                    ++i;
                }
                return null;
            }
        }
        return null;
    }

    public Set getMacros() {
        return this.macros;
    }

    public void resolve() {
        Map valueStore = this.template.getValueStore();
        switch (this.type) {
            case 1: {
                if (this.externalParam != null) {
                    this.resolvedSimpleValue = (String)this.template.getValueStore().get(this.name);
                    break;
                }
                this.resolvedSimpleValue = this.simpleValue;
                if (this.macros == null || this.macros.isEmpty()) break;
                this.resolvedSimpleValue = ProcessHelper.getValueAfterExpandingMacros(this.resolvedSimpleValue, this.macros, valueStore);
                break;
            }
            case 2: {
                this.resolvedSimpleValueArray = this.simpleValueArray;
                if (this.macros == null || this.macros.isEmpty()) break;
                int i = 0;
                while (i < this.resolvedSimpleValueArray.length) {
                    this.resolvedSimpleValueArray[i] = ProcessHelper.getValueAfterExpandingMacros(this.resolvedSimpleValueArray[i], this.macros, valueStore);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.complexValue.length) {
                    ProcessArgument arg = this.complexValue[i];
                    arg.resolve();
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.complexValueArray.length) {
                    ProcessArgument[] complexValue = this.complexValueArray[i];
                    int j = 0;
                    while (j < complexValue.length) {
                        ProcessArgument arg = complexValue[j];
                        arg.resolve();
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.name);
        b.append(":");
        switch (this.type) {
            case 1: {
                return b.append(this.getSimpleValue()).toString();
            }
            case 2: {
                b.append("{");
                String[] strings = this.getSimpleArrayValue();
                int i = 0;
                while (i < strings.length) {
                    b.append(strings[i]).append(", ");
                    ++i;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
            case 3: {
                b.append("{");
                ProcessArgument[] args = this.getComplexValue();
                int i = 0;
                while (i < args.length) {
                    ProcessArgument arg = args[i];
                    b.append(arg).append(", ");
                    ++i;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
            case 4: {
                b.append("{");
                ProcessArgument[][] argssCA = this.getComplexArrayValue();
                int i = 0;
                while (i < argssCA.length) {
                    ProcessArgument[] argsCA = argssCA[i];
                    b.append("{");
                    int j = 0;
                    while (j < argsCA.length) {
                        ProcessArgument arg = argsCA[j];
                        b.append(arg).append(", ");
                        ++j;
                    }
                    if (b.charAt(b.length() - 1) == ' ') {
                        b.replace(b.length() - 2, b.length(), "}, ");
                    } else {
                        b.append("}, ");
                    }
                    ++i;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
        }
        return "";
    }
}

