/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LocalProjectScope
implements IScopeContext {
    private static final String QUALIFIER_EXT = ".prj-";
    public static final String SCOPE = "project-local";
    private String fContext;

    public LocalProjectScope(IProject context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.fContext = context.getName();
    }

    public LocalProjectScope(String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException();
        }
        this.fContext = projectName;
    }

    public IPath getLocation() {
        return null;
    }

    public String getName() {
        return SCOPE;
    }

    public IEclipsePreferences getNode(String qualifier) {
        return new InstanceScope().getNode(String.valueOf(qualifier) + QUALIFIER_EXT + this.fContext);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LocalProjectScope)) {
            return false;
        }
        LocalProjectScope other = (LocalProjectScope)obj;
        return this.fContext.equals(other.fContext);
    }

    public int hashCode() {
        return this.fContext.hashCode();
    }

    private static Preferences getPPP(String name) {
        return new LocalProjectScope(name).getNode("org.eclipse.cdt.core");
    }

    public static void deletePreferences(IPath prjToDelete, IPath movedTo) {
        try {
            Preferences prefs = LocalProjectScope.getPPP(prjToDelete.lastSegment());
            if (movedTo != null) {
                Preferences target = LocalProjectScope.getPPP(movedTo.lastSegment());
                LocalProjectScope.copyPrefs(prefs, target);
            }
            LocalProjectScope.deletePrefs(prefs);
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private static void deletePrefs(Preferences prefs) throws BackingStoreException {
        prefs.clear();
        String[] children = prefs.childrenNames();
        int i = 0;
        while (i < children.length) {
            String child = children[i];
            prefs.node(child).removeNode();
            ++i;
        }
        prefs.flush();
        prefs.removeNode();
    }

    private static void copyPrefs(Preferences prefs, Preferences target) throws BackingStoreException {
        String[] keys = prefs.keys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            String val = prefs.get(key, null);
            if (val != null) {
                target.put(key, val);
            }
            ++i;
        }
        String[] children = prefs.childrenNames();
        int i2 = 0;
        while (i2 < children.length) {
            String child = children[i2];
            LocalProjectScope.copyPrefs(prefs.node(child), target.node(child));
            ++i2;
        }
        target.flush();
    }
}

