/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.c.CParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class CFunction
extends PlatformObject
implements IFunction,
ICInternalFunction {
    private IASTStandardFunctionDeclarator[] declarators = null;
    private IASTFunctionDeclarator definition;
    private static final int FULLY_RESOLVED = 1;
    private static final int RESOLUTION_IN_PROGRESS = 2;
    private int bits = 0;
    protected IFunctionType type = null;
    static /* synthetic */ Class class$0;

    public CFunction(IASTFunctionDeclarator declarator) {
        if (declarator != null) {
            if (declarator.getParent() instanceof IASTFunctionDefinition || declarator instanceof ICASTKnRFunctionDeclarator) {
                this.definition = declarator;
            } else {
                this.declarators = new IASTStandardFunctionDeclarator[]{(IASTStandardFunctionDeclarator)declarator};
            }
        }
    }

    public IASTNode getPhysicalNode() {
        if (this.definition != null) {
            return this.definition;
        }
        if (this.declarators != null && this.declarators.length > 0) {
            return this.declarators[0];
        }
        return null;
    }

    public void addDeclarator(IASTFunctionDeclarator fnDeclarator) {
        if (fnDeclarator.getParent() instanceof IASTFunctionDefinition || fnDeclarator instanceof ICASTKnRFunctionDeclarator) {
            if (this.definition == fnDeclarator) {
                return;
            }
            this.updateParameterBindings(fnDeclarator);
            this.definition = fnDeclarator;
            return;
        }
        this.updateParameterBindings(fnDeclarator);
        if (this.declarators == null) {
            this.declarators = new IASTStandardFunctionDeclarator[]{(IASTStandardFunctionDeclarator)fnDeclarator};
            return;
        }
        int i = 0;
        while (i < this.declarators.length) {
            if (this.declarators[i] == null) {
                this.declarators[i] = (IASTStandardFunctionDeclarator)fnDeclarator;
                return;
            }
            ++i;
        }
        IASTStandardFunctionDeclarator[] tmp = new IASTStandardFunctionDeclarator[this.declarators.length * 2];
        System.arraycopy(this.declarators, 0, tmp, 0, this.declarators.length);
        tmp[this.declarators.length] = (IASTStandardFunctionDeclarator)fnDeclarator;
        this.declarators = tmp;
    }

    protected IASTTranslationUnit getTranslationUnit() {
        if (this.definition != null) {
            return this.definition.getTranslationUnit();
        }
        if (this.declarators != null) {
            return this.declarators[0].getTranslationUnit();
        }
        return null;
    }

    private void resolveAllDeclarations() {
        if ((this.bits & 3) == 0) {
            Class<?> clazz;
            this.bits |= 2;
            IASTTranslationUnit tu = this.getTranslationUnit();
            if (tu != null) {
                CPPVisitor.getDeclarations(tu, this);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarators = (IASTStandardFunctionDeclarator[])ArrayUtil.trim(clazz, this.declarators);
            this.bits |= 1;
            this.bits &= 0xFFFFFFFD;
        }
    }

    public IParameter[] getParameters() {
        IParameter[] result;
        block6: {
            IASTFunctionDeclarator dtor;
            block5: {
                result = IParameter.EMPTY_PARAMETER_ARRAY;
                dtor = (IASTFunctionDeclarator)this.getPhysicalNode();
                if (dtor == null && (this.bits & 1) == 0) {
                    this.resolveAllDeclarations();
                    dtor = (IASTFunctionDeclarator)this.getPhysicalNode();
                }
                if (!(dtor instanceof IASTStandardFunctionDeclarator)) break block5;
                IASTParameterDeclaration[] params = ((IASTStandardFunctionDeclarator)dtor).getParameters();
                int size = params.length;
                result = new IParameter[size];
                if (size <= 0) break block6;
                int i = 0;
                while (i < size) {
                    IASTParameterDeclaration p = params[i];
                    result[i] = (IParameter)p.getDeclarator().getName().resolveBinding();
                    ++i;
                }
                break block6;
            }
            if (dtor instanceof ICASTKnRFunctionDeclarator) {
                IASTName[] names = ((ICASTKnRFunctionDeclarator)dtor).getParameterNames();
                result = new IParameter[names.length];
                if (names.length > 0) {
                    int i = 0;
                    while (i < names.length) {
                        IASTDeclarator decl = CVisitor.getKnRParameterDeclarator((ICASTKnRFunctionDeclarator)dtor, names[i]);
                        result[i] = decl != null ? (IParameter)decl.getName().resolveBinding() : new CParameter.CParameterProblem(names[i], 8, names[i].toCharArray());
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    public String getName() {
        return this.getASTName().toString();
    }

    public char[] getNameCharArray() {
        return this.getASTName().toCharArray();
    }

    private IASTName getASTName() {
        IASTDeclarator dtor = this.definition != null ? this.definition : this.declarators[0];
        IASTDeclarator nested = dtor.getNestedDeclarator();
        while (nested != null && nested.getPointerOperators().length == 0) {
            dtor = nested;
            nested = nested.getNestedDeclarator();
        }
        return dtor.getName();
    }

    public IScope getScope() {
        IASTFunctionDeclarator dtor = (IASTFunctionDeclarator)this.getPhysicalNode();
        if (dtor != null) {
            return CVisitor.getContainingScope(dtor.getParent());
        }
        return null;
    }

    public IScope getFunctionScope() {
        if (this.definition != null) {
            IASTFunctionDefinition def = (IASTFunctionDefinition)this.definition.getParent();
            return def.getScope();
        }
        return null;
    }

    public IFunctionType getType() {
        if (this.type == null) {
            IASTDeclarator functionDtor = (IASTDeclarator)this.getPhysicalNode();
            if (functionDtor == null && (this.bits & 1) == 0) {
                this.resolveAllDeclarations();
                functionDtor = (IASTDeclarator)this.getPhysicalNode();
            }
            if (functionDtor != null) {
                while (functionDtor.getNestedDeclarator() != null) {
                    functionDtor = functionDtor.getNestedDeclarator();
                }
                IType tempType = CVisitor.createType(functionDtor);
                if (tempType instanceof IFunctionType) {
                    this.type = (IFunctionType)tempType;
                }
            }
        }
        return this.type;
    }

    public IBinding resolveParameter(IASTName paramName) {
        IASTName[] ps;
        if (paramName.getBinding() != null) {
            return paramName.getBinding();
        }
        CParameter binding = null;
        int idx = 0;
        IASTNode parent = paramName.getParent();
        while (parent instanceof IASTDeclarator && !(parent instanceof ICASTKnRFunctionDeclarator)) {
            parent = parent.getParent();
        }
        ICASTKnRFunctionDeclarator fKnRDtor = null;
        IASTDeclarator knrParamDtor = null;
        if (parent instanceof IASTParameterDeclaration) {
            IASTStandardFunctionDeclarator fdtor = (IASTStandardFunctionDeclarator)parent.getParent();
            IASTParameterDeclaration[] ps2 = fdtor.getParameters();
            while (idx < ps2.length) {
                if (parent != ps2[idx]) {
                    ++idx;
                    continue;
                }
                break;
            }
        } else if (parent instanceof IASTSimpleDeclaration) {
            fKnRDtor = (ICASTKnRFunctionDeclarator)parent.getParent();
            ps = fKnRDtor.getParameterNames();
            char[] n = paramName.toCharArray();
            while (idx < ps.length) {
                if (!CharArrayUtils.equals(ps[idx].toCharArray(), n)) {
                    ++idx;
                    continue;
                }
                break;
            }
        } else {
            fKnRDtor = (ICASTKnRFunctionDeclarator)parent;
            ps = fKnRDtor.getParameterNames();
            while (idx < ps.length) {
                if (ps[idx] == paramName) break;
                ++idx;
            }
            knrParamDtor = CVisitor.getKnRParameterDeclarator(fKnRDtor, paramName);
            if (knrParamDtor != null) {
                paramName = knrParamDtor.getName();
            }
        }
        binding = new CParameter(paramName);
        IASTParameterDeclaration temp = null;
        if (this.definition != null) {
            IASTName[] parameterNames;
            if (this.definition instanceof IASTStandardFunctionDeclarator) {
                IASTParameterDeclaration[] parameters = ((IASTStandardFunctionDeclarator)this.definition).getParameters();
                if (parameters.length > idx) {
                    temp = parameters[idx];
                    temp.getDeclarator().getName().setBinding(binding);
                }
            } else if (this.definition instanceof ICASTKnRFunctionDeclarator && (parameterNames = (fKnRDtor = (ICASTKnRFunctionDeclarator)this.definition).getParameterNames()).length > idx) {
                IASTName n = parameterNames[idx];
                n.setBinding(binding);
                IASTDeclarator dtor = CVisitor.getKnRParameterDeclarator(fKnRDtor, n);
                if (dtor != null) {
                    dtor.getName().setBinding(binding);
                }
            }
        }
        if (this.declarators != null) {
            int j = 0;
            while (j < this.declarators.length && this.declarators[j] != null) {
                if (this.declarators[j].getParameters().length > idx) {
                    temp = this.declarators[j].getParameters()[idx];
                    temp.getDeclarator().getName().setBinding(binding);
                }
                ++j;
            }
        }
        return binding;
    }

    protected void updateParameterBindings(IASTFunctionDeclarator fdtor) {
        IParameter[] params = this.getParameters();
        if (fdtor instanceof IASTStandardFunctionDeclarator) {
            IASTParameterDeclaration[] nps = ((IASTStandardFunctionDeclarator)fdtor).getParameters();
            if (params.length < nps.length) {
                return;
            }
            int i = 0;
            while (i < nps.length) {
                IASTName name = nps[i].getDeclarator().getName();
                name.setBinding(params[i]);
                if (params[i] instanceof CParameter) {
                    ((CParameter)params[i]).addDeclaration(name);
                }
                ++i;
            }
        } else {
            IASTName[] ns = ((ICASTKnRFunctionDeclarator)fdtor).getParameterNames();
            if (params.length > 0 && params.length != ns.length) {
                return;
            }
            int i = 0;
            while (i < params.length) {
                IASTName name = ns[i];
                name.setBinding(params[i]);
                IASTDeclarator dtor = CVisitor.getKnRParameterDeclarator((ICASTKnRFunctionDeclarator)fdtor, name);
                if (dtor != null) {
                    dtor.getName().setBinding(params[i]);
                    if (params[i] instanceof CParameter) {
                        ((CParameter)params[i]).addDeclaration(dtor.getName());
                    }
                }
                ++i;
            }
        }
    }

    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    public boolean hasStorageClass(int storage) {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        IASTFunctionDeclarator dtor = this.definition;
        IASTStandardFunctionDeclarator[] ds = this.declarators;
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean isInline() {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        IASTFunctionDeclarator dtor = this.definition;
        IASTStandardFunctionDeclarator[] ds = this.declarators;
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (!declSpec.isInline()) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    public boolean takesVarArgs() {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        if (this.definition != null) {
            if (this.definition instanceof IASTStandardFunctionDeclarator) {
                return ((IASTStandardFunctionDeclarator)this.definition).takesVarArgs();
            }
            return false;
        }
        if (this.declarators != null && this.declarators.length > 0) {
            return this.declarators[0].takesVarArgs();
        }
        return false;
    }

    public void setFullyResolved(boolean resolved) {
        this.bits = resolved ? (this.bits |= 1) : (this.bits &= 0xFFFFFFFE);
    }

    public ILinkage getLinkage() throws CoreException {
        return Linkage.C_LINKAGE;
    }
}

