/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.core.runtime.CoreException;

public class WritableCIndex
extends CIndex
implements IWritableIndex {
    private final IWritableIndexFragment fWritableFragment;
    private boolean fIsWriteLocked = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.index.WritableCIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public WritableCIndex(IWritableIndexFragment writable, IIndexFragment[] readonly) {
        super(WritableCIndex.concat(writable, readonly));
        this.fWritableFragment = writable;
    }

    private static IIndexFragment[] concat(IIndexFragment writable, IIndexFragment[] readonly) {
        IIndexFragment[] result = new IIndexFragment[1 + readonly.length];
        result[0] = writable;
        System.arraycopy(readonly, 0, result, 1, readonly.length);
        return result;
    }

    public IWritableIndexFragment getWritableFragment() {
        return this.fWritableFragment;
    }

    public IIndexFragmentFile getWritableFile(IIndexFileLocation location) throws CoreException {
        return this.fWritableFragment.getFile(location);
    }

    public IIndexFragmentFile addFile(IIndexFileLocation fileLocation) throws CoreException {
        return this.fWritableFragment.addFile(fileLocation);
    }

    private boolean isWritableFragment(IIndexFragment frag) {
        return frag == this.fWritableFragment;
    }

    public void setFileContent(IIndexFragmentFile file, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorMacroDefinition[] macros, IASTName[][] names) throws CoreException {
        IIndexFragment indexFragment = file.getIndexFragment();
        if (!this.isWritableFragment(indexFragment)) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Attempt to update file of read-only fragment");
            }
        } else {
            int i = 0;
            while (i < includes.length) {
                IWritableIndex.IncludeInformation ii = includes[i];
                if (ii.fLocation != null) {
                    ii.fTargetFile = this.addFile(ii.fLocation);
                }
                ++i;
            }
            ((IWritableIndexFragment)indexFragment).addFileContent(file, includes, macros, names);
        }
    }

    public void clear() throws CoreException {
        this.fWritableFragment.clear();
    }

    public boolean isWritableFile(IIndexFragmentFile file) {
        return this.isWritableFragment(file.getIndexFragment());
    }

    public void clearFile(IIndexFragmentFile file, Collection clearedContexts) throws CoreException {
        IIndexFragment indexFragment = file.getIndexFragment();
        if (!this.isWritableFragment(indexFragment)) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Attempt to clear file of read-only fragment");
            }
        } else {
            ((IWritableIndexFragment)indexFragment).clearFile(file, clearedContexts);
        }
    }

    public synchronized void acquireReadLock() throws InterruptedException {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError((Object)"Read locks are not allowed while write-locked.");
        }
        super.acquireReadLock();
    }

    public synchronized void releaseReadLock() {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError((Object)"Read locks are not allowed while write-locked.");
        }
        super.releaseReadLock();
    }

    public synchronized void acquireWriteLock(int giveupReadlockCount) throws InterruptedException {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError((Object)"Multiple write locks is not allowed");
        }
        if (!$assertionsDisabled && giveupReadlockCount != this.getReadLockCount()) {
            throw new AssertionError((Object)"Unexpected read lock is not allowed");
        }
        this.fWritableFragment.acquireWriteLock(giveupReadlockCount);
        this.fIsWriteLocked = true;
    }

    public synchronized void releaseWriteLock(int establishReadlockCount) {
        this.releaseWriteLock(establishReadlockCount, true);
    }

    public synchronized void releaseWriteLock(int establishReadlockCount, boolean flush) {
        if (!$assertionsDisabled && !this.fIsWriteLocked) {
            throw new AssertionError((Object)"No write lock to be released");
        }
        if (!$assertionsDisabled && establishReadlockCount != this.getReadLockCount()) {
            throw new AssertionError((Object)"Unexpected read lock is not allowed");
        }
        this.fIsWriteLocked = false;
        this.fWritableFragment.releaseWriteLock(establishReadlockCount, flush);
    }

    public void flush() throws CoreException {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError();
        }
        this.fWritableFragment.flush();
    }
}

