/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.indexer.StandaloneFullIndexer;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexerTask;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class StandaloneFullIndexerTask
extends StandaloneIndexerTask {
    private static final Object REQUIRED = new Object();
    private static final Object MISSING = new Object();
    private static final Object SKIP = new Object();
    private List fChanged = new ArrayList();
    private List fRemoved = new ArrayList();
    private IWritableIndex fIndex = null;
    private Map filePathsToParse = new HashMap();
    private Map fIflCache = new HashMap();

    public StandaloneFullIndexerTask(StandaloneFullIndexer indexer, List added, List changed, List removed) {
        super(indexer);
        this.fChanged.addAll(added);
        this.fChanged.addAll(changed);
        this.fRemoved.addAll(removed);
        this.updateInfo(0, 0, this.fChanged.size() + this.fRemoved.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws IOException {
        long start = System.currentTimeMillis();
        try {
            Object var7_7;
            String tu;
            this.setupIndex();
            this.registerTUsInReaderFactory(this.fChanged);
            ArrayList<String> headers = new ArrayList<String>();
            List sources = this.fChanged;
            Iterator iter = this.fChanged.iterator();
            while (iter.hasNext()) {
                tu = (String)iter.next();
                if (this.isValidSourceUnitName(tu)) continue;
                headers.add(tu);
                iter.remove();
            }
            Iterator i = this.fRemoved.iterator();
            while (i.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                tu = (String)i.next();
                this.removeTU(this.fIndex, this.getIndexFileLocation(tu), 0);
                if (this.isValidSourceUnitName(tu)) {
                    this.updateInfo(1, 0, 0);
                    continue;
                }
                this.updateInfo(0, 1, -1);
            }
            this.fIndex.acquireReadLock();
            try {
                this.parseTUs(this.fIndex, 1, sources, headers, monitor);
                var7_7 = null;
                this.fIndex.releaseReadLock();
            }
            catch (Throwable throwable) {
                var7_7 = null;
                this.fIndex.releaseReadLock();
                throw throwable;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
        this.traceEnd(start);
    }

    private void setupIndex() throws CoreException {
        this.fIndex = this.fIndexer.getIndex();
        this.fIndex.resetCacheCounters();
    }

    private void registerTUsInReaderFactory(Collection sources) throws IOException, CoreException {
        int removed = 0;
        this.filePathsToParse = new HashMap();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            String sourcePath = (String)iter.next();
            String path = new File(sourcePath).getCanonicalPath();
            IIndexFileLocation location = this.getIndexFileLocation(path);
            if (this.updateAll()) {
                this.filePathsToParse.put(location, REQUIRED);
            } else if (this.updateChangedTimestamps() && this.isOutdated(location, this.fIndex.getFile(location))) {
                this.filePathsToParse.put(location, REQUIRED);
            } else {
                iter.remove();
                ++removed;
                continue;
            }
            this.updateInfo(0, 0, -removed);
        }
    }

    protected IIndexFileLocation findLocation(String absolutePath) {
        IIndexFileLocation result = (IIndexFileLocation)this.fIflCache.get(absolutePath);
        if (result == null) {
            result = new IndexFileLocation(URIUtil.toURI((String)absolutePath), absolutePath);
            this.fIflCache.put(absolutePath, result);
        }
        return result;
    }

    protected IASTTranslationUnit createAST(AbstractLanguage lang, CodeReader codeReader, IScannerInfo scanInfo, int options, IProgressMonitor pm) throws CoreException {
        IASTTranslationUnit ast = lang.getASTTranslationUnit(codeReader, scanInfo, ((StandaloneFullIndexer)this.fIndexer).getCodeReaderFactory(), null, options, this.fIndexer.getParserLog());
        if (pm.isCanceled()) {
            return null;
        }
        return ast;
    }

    protected boolean needToUpdate(IIndexFileLocation location, int confighash) throws CoreException {
        if (super.needToUpdate(location, confighash)) {
            Object required = this.filePathsToParse.get(location);
            if (required == null) {
                required = MISSING;
                this.filePathsToParse.put(location, required);
            }
            return required != SKIP;
        }
        return false;
    }

    protected boolean postAddToIndex(IIndexFileLocation location, IIndexFile file) throws CoreException {
        Object required = this.filePathsToParse.get(location);
        this.filePathsToParse.put(location, SKIP);
        return required == REQUIRED;
    }
}

