/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class SourceRoot
extends CContainer
implements ISourceRoot {
    ICSourceEntry sourceEntry;

    public SourceRoot(ICElement parent, IResource res, ICSourceEntry entry) {
        super(parent, res);
        this.sourceEntry = entry;
        IPath path = this.getPath();
        IPath cpath = this.getParent().getPath();
        if (path.segmentCount() > cpath.segmentCount()) {
            IPath p = path.removeFirstSegments(cpath.segmentCount());
            this.setElementName(p.toString());
        }
    }

    public ICSourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    public boolean isOnSourceEntry(ICElement element) {
        IPath path = element.getPath();
        return this.isOnSourceEntry(path);
    }

    public boolean isOnSourceEntry(IResource res) {
        IPath path = res.getFullPath();
        return this.isOnSourceEntry(path);
    }

    public boolean isOnSourceEntry(IPath path) {
        return this.sourceEntry.getFullPath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, this.sourceEntry.fullExclusionPatternChars());
    }
}

