/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.dom.NullCodeReaderFactory;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.index.IndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.model.ASTHolderTUInfo;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelBuilder2;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CreateIncludeOperation;
import org.eclipse.cdt.internal.core.model.CreateNamespaceOperation;
import org.eclipse.cdt.internal.core.model.CreateWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.content.IContentType;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    private IPath location = null;
    private String contentTypeId;
    protected IProblemRequestor problemRequestor;
    SourceManipulationInfo sourceManipulationInfo = null;
    private ILanguage fLanguageOfContext;

    public TranslationUnit(ICElement parent, IFile file, String idType) {
        super(parent, (IResource)file, 60);
        this.setContentTypeID(idType);
    }

    public TranslationUnit(ICElement parent, IPath path, String idType) {
        super(parent, null, path.toString(), 60);
        this.setContentTypeID(idType);
        this.setLocation(path);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String includeName, boolean isStd, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateIncludeOperation op = new CreateIncludeOperation(includeName, isStd, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getInclude(includeName);
    }

    public IUsing createUsing(String usingName, boolean isDirective, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateIncludeOperation op = new CreateIncludeOperation(usingName, isDirective, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getUsing(usingName);
    }

    public INamespace createNamespace(String namespace, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateNamespaceOperation op = new CreateNamespaceOperation(namespace, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getNamespace(namespace);
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            ISourceRange range = ((ISourceReference)((Object)celements[i])).getSourceRange();
            int startLine = range.getStartLine();
            int endLine = range.getEndLine();
            if (line >= startLine && line <= endLine) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public ICElement getElementAtOffset(int pos) throws CModelException {
        ICElement e = this.getSourceElementAtOffset(pos);
        if (e == this) {
            return null;
        }
        return e;
    }

    public ICElement[] getElementsAtOffset(int pos) throws CModelException {
        ICElement[] e = this.getSourceElementsAtOffset(pos);
        if (e.length == 1 && e[0] == this) {
            return CElement.NO_ELEMENTS;
        }
        return e;
    }

    public ICElement getElement(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (name.equals(celements[i].getElementName())) {
                    return celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        String[] names = name.split("::");
        ICElement current = this;
        int j = 0;
        while (j < names.length) {
            if (current instanceof IParent) {
                try {
                    ICElement[] celements = ((IParent)((Object)current)).getChildren();
                    current = null;
                    int i = 0;
                    while (i < celements.length) {
                        if (names[j].equals(celements[i].getElementName())) {
                            current = celements[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (CModelException cModelException) {
                    current = null;
                }
            } else {
                current = null;
            }
            ++j;
        }
        return current;
    }

    public IInclude getInclude(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 75 && name.equals(celements[i].getElementName())) {
                    return (IInclude)celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 75) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 62 && name.equals(celements[i].getElementName())) {
                    return (IUsing)celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IUsing[0]);
    }

    public INamespace getNamespace(String name) {
        try {
            String[] names = name.split("::");
            ICElement current = this;
            int j = 0;
            while (j < names.length) {
                if (current instanceof IParent) {
                    ICElement[] celements = ((IParent)((Object)current)).getChildren();
                    current = null;
                    int i = 0;
                    while (i < celements.length) {
                        if (celements[i].getElementType() == 61 && name.equals(celements[i].getElementName())) {
                            current = celements[i];
                            break;
                        }
                        ++i;
                    }
                } else {
                    current = null;
                }
                ++j;
            }
            if (current instanceof INamespace) {
                return (INamespace)current;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public INamespace[] getNamespaces() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 61) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new INamespace[0]);
    }

    protected void setLocation(IPath loc) {
        this.location = loc;
    }

    public IPath getLocation() {
        if (this.location == null) {
            IFile file = this.getFile();
            if (file != null) {
                this.location = file.getLocation();
            } else {
                return this.getPath();
            }
        }
        return this.location;
    }

    public IFile getFile() {
        IResource res = this.getResource();
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().copy(container, sibling, rename, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().delete(force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().move(container, sibling, rename, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().rename(name, force, monitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() throws CModelException {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ITranslationUnit)) {
            return false;
        }
        return super.equals(o) && !((ITranslationUnit)o).isWorkingCopy();
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = CModelManager.getDefault().sharedWorkingCopies).get(factory)) == null) {
            return null;
        }
        return (WorkingCopy)perFactoryWorkingCopies.get(this);
    }

    public synchronized CElementInfo getElementInfo(IProgressMonitor monitor) throws CModelException {
        return super.getElementInfo(monitor);
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        ITranslationUnit original;
        IResource r;
        TranslationUnitInfo unitInfo = (TranslationUnitInfo)info;
        CModelManager.getDefault().removeChildrenInfo(this);
        this.parse(newElements, pm);
        if (this.isWorkingCopy() && (r = (original = ((IWorkingCopy)((Object)this)).getOriginalElement()).getResource()) != null && r instanceof IFile) {
            unitInfo.fTimestamp = ((IFile)r).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (CModelException cModelException) {
            return new char[0];
        }
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return this.getSharedWorkingCopy(monitor, factory, null);
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        WorkingCopy workingCopy;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        CModelManager manager = CModelManager.getDefault();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        HashMap perFactoryWorkingCopies = (HashMap)sharedWorkingCopies.get(factory);
        if (perFactoryWorkingCopies == null) {
            perFactoryWorkingCopies = new HashMap();
            sharedWorkingCopies.put(factory, perFactoryWorkingCopies);
        }
        if ((workingCopy = (WorkingCopy)perFactoryWorkingCopies.get(this)) != null) {
            ++workingCopy.useCount;
            return workingCopy;
        }
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, perFactoryWorkingCopies, factory, requestor);
        op.runOperation(monitor);
        return (IWorkingCopy)op.getResultElements()[0];
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        IFile file = this.getFile();
        WorkingCopy workingCopy = file != null ? new WorkingCopy(this.getParent(), file, this.getContentTypeId(), factory) : new WorkingCopy(this.getParent(), this.getLocation(), this.getContentTypeId(), factory);
        workingCopy.open(monitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    protected void openParent(Object childInfo, Map newElements, IProgressMonitor pm) throws CModelException {
        block2: {
            try {
                super.openParent(childInfo, newElements, pm);
            }
            catch (CModelException e) {
                if (this.isWorkingCopy()) break block2;
                throw e;
            }
        }
    }

    public boolean isConsistent() throws CModelException {
        return this.isOpen() && CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    public void makeConsistent(IProgressMonitor monitor, boolean forced) throws CModelException {
        this.makeConsistent(forced, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IASTTranslationUnit makeConsistent(boolean computeAST, IProgressMonitor monitor) throws CModelException {
        CElementInfo info;
        block10: {
            if (!computeAST && this.isConsistent()) {
                return null;
            }
            CModelManager manager = CModelManager.getDefault();
            boolean hadTemporaryCache = manager.hasTemporaryCache();
            info = computeAST ? new ASTHolderTUInfo(this) : this.createElementInfo();
            try {
                HashMap newElements = manager.getTemporaryCache();
                this.openWhenClosed(info, monitor);
                if (newElements.get(this) == null) {
                    Iterator iterator = newElements.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw this.newNotPresentException();
                        }
                        ICElement element = (ICElement)iterator.next();
                        if (!(element instanceof Openable)) continue;
                        ((Openable)element).closeBuffer();
                    }
                }
                if (!hadTemporaryCache) {
                    manager.putInfos(this, newElements);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!hadTemporaryCache) {
                    manager.resetTemporaryCache();
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (hadTemporaryCache) break block10;
                manager.resetTemporaryCache();
            }
        }
        if (info instanceof ASTHolderTUInfo) {
            IASTTranslationUnit ast = ((ASTHolderTUInfo)info).fAST;
            ((ASTHolderTUInfo)info).fAST = null;
            return ast;
        }
        return null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IResource resource = this.getResource();
            if (resource != null && resource.getType() == 1) {
                buffer.setContents(Util.getResourceContentsAsCharArray((IFile)resource));
            } else {
                IPath path = this.getLocation();
                File file = path.toFile();
                if (file != null && file.isFile()) {
                    try {
                        FileInputStream stream = new FileInputStream(file);
                        buffer.setContents(Util.getInputStreamAsCharArray(stream, (int)file.length(), null));
                    }
                    catch (IOException iOException) {
                        buffer.setContents(new char[0]);
                    }
                } else {
                    buffer.setContents(new char[0]);
                }
            }
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public Map parse() {
        throw new UnsupportedOperationException("Deprecated method");
    }

    private void parse(Map newElements, IProgressMonitor monitor) {
        boolean quickParseMode = !CCorePlugin.getDefault().useStructuralParseMode();
        IContributedModelBuilder mb = LanguageManager.getInstance().getContributedModelBuilderFor(this);
        if (mb == null) {
            this.parseUsingCModelBuilder(newElements, quickParseMode, monitor);
        } else {
            this.parseUsingContributedModelBuilder(mb, quickParseMode, monitor);
        }
    }

    private void parseUsingCModelBuilder(Map newElements, boolean quickParseMode, IProgressMonitor monitor) {
        try {
            new CModelBuilder2(this, monitor).parse(quickParseMode);
        }
        catch (OperationCanceledException oce) {
            if (this.isWorkingCopy()) {
                throw oce;
            }
        }
        catch (Exception exception) {
            Util.debugLog("Exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
    }

    private void parseUsingContributedModelBuilder(IContributedModelBuilder mb, boolean quickParseMode, IProgressMonitor monitor) {
        try {
            mb.parse(quickParseMode);
        }
        catch (Exception exception) {
            Util.debugLog("Exception in contributed model builder", IDebugLogConstants.MODEL);
        }
    }

    public IProblemRequestor getProblemRequestor() {
        return this.problemRequestor;
    }

    public boolean isHeaderUnit() {
        return "org.eclipse.cdt.core.cHeader".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxHeader".equals(this.contentTypeId);
    }

    public boolean isSourceUnit() {
        if (this.isHeaderUnit()) {
            return false;
        }
        return "org.eclipse.cdt.core.cSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.asmSource".equals(this.contentTypeId) || LanguageManager.getInstance().isContributedContentType(this.contentTypeId);
    }

    public boolean isCLanguage() {
        return "org.eclipse.cdt.core.cSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cHeader".equals(this.contentTypeId);
    }

    public boolean isCXXLanguage() {
        return "org.eclipse.cdt.core.cxxSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxHeader".equals(this.contentTypeId);
    }

    public boolean isASMLanguage() {
        return "org.eclipse.cdt.core.asmSource".equals(this.contentTypeId);
    }

    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        if (this.location != null) {
            return this.location.toFile().exists();
        }
        return false;
    }

    public ILanguage getLanguage() throws CoreException {
        ILanguage language = null;
        ICProject cProject = this.getCProject();
        IProject project = cProject.getProject();
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription configuration = description == null ? null : description.getActiveConfiguration();
        IFile file = this.getFile();
        language = file != null ? LanguageManager.getInstance().getLanguageForFile(file, configuration, this.contentTypeId) : LanguageManager.getInstance().getLanguageForFile(this.getLocation(), this.getCProject().getProject(), configuration, this.contentTypeId);
        return language;
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    protected void setContentTypeID(String id) {
        this.contentTypeId = id;
    }

    protected void closing(Object info) throws CModelException {
        IContentType cType = CCorePlugin.getContentType(this.getCProject().getProject(), this.getElementName());
        if (cType != null) {
            this.setContentTypeID(cType.getId());
        }
        super.closing(info);
    }

    public void setIsStructureKnown(boolean wasSuccessful) {
        try {
            this.getElementInfo().setIsStructureKnown(wasSuccessful);
        }
        catch (CModelException cModelException) {}
    }

    public IASTTranslationUnit getAST() throws CoreException {
        return this.getAST(null, 0);
    }

    public IASTTranslationUnit getAST(IIndex index, int style) throws CoreException {
        ITranslationUnit configureWith;
        IScannerInfo scanInfo;
        ICodeReaderFactory codeReaderFactory = (style & 4) != 0 ? NullCodeReaderFactory.getInstance() : SavedCodeReaderFactory.getInstance();
        if (index != null && (style & 2) != 0) {
            codeReaderFactory = new IndexBasedCodeReaderFactory(this.getCProject(), index, codeReaderFactory);
        }
        if ((scanInfo = (configureWith = this.getSourceContextTU(index, style)).getScannerInfo((style & 8) == 0)) == null) {
            return null;
        }
        CodeReader reader = this.getCodeReader();
        if (reader != null) {
            ILanguage language;
            this.fLanguageOfContext = language = configureWith.getLanguage();
            if (language != null) {
                if (language instanceof AbstractLanguage) {
                    int options = 0;
                    if ((style & 1) != 0) {
                        options |= 1;
                    }
                    if ((style & 0x10) != 0) {
                        options |= 2;
                    }
                    return ((AbstractLanguage)language).getASTTranslationUnit(reader, scanInfo, codeReaderFactory, index, options, ParserUtil.getParserLogService());
                }
                return language.getASTTranslationUnit(reader, scanInfo, codeReaderFactory, index, ParserUtil.getParserLogService());
            }
        }
        return null;
    }

    private ITranslationUnit getSourceContextTU(IIndex index, int style) {
        ITranslationUnit configureWith = this;
        if (index != null && (style & 0x20) != 0) {
            try {
                ITranslationUnit tu;
                this.fLanguageOfContext = null;
                IIndexFile context = null;
                IIndexFile indexFile = index.getFile(IndexLocationFactory.getIFL(this));
                if (indexFile != null) {
                    HashSet<IIndexFile> visited = new HashSet<IIndexFile>();
                    visited.add(indexFile);
                    indexFile = this.getParsedInContext(indexFile);
                    while (indexFile != null && visited.add(indexFile)) {
                        context = indexFile;
                        indexFile = this.getParsedInContext(indexFile);
                    }
                }
                if (context != null && (tu = CoreModelUtil.findTranslationUnitForLocation(context.getLocation(), this.getCProject())) != null && tu.isSourceUnit()) {
                    configureWith = tu;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return configureWith;
    }

    private IIndexFile getParsedInContext(IIndexFile indexFile) throws CoreException {
        IIndexInclude include = indexFile.getParsedInContext();
        if (include != null) {
            return include.getIncludedBy();
        }
        return null;
    }

    public IASTCompletionNode getCompletionNode(IIndex index, int style, int offset) throws CoreException {
        ILanguage language;
        ICodeReaderFactory codeReaderFactory;
        if (index != null && (style & 6) != 0) {
            ICodeReaderFactory fallbackFactory = (style & 6) != 0 ? NullCodeReaderFactory.getInstance() : SavedCodeReaderFactory.getInstance();
            codeReaderFactory = new IndexBasedCodeReaderFactory(this.getCProject(), index, fallbackFactory);
        } else {
            codeReaderFactory = SavedCodeReaderFactory.getInstance();
        }
        ITranslationUnit configureWith = this.getSourceContextTU(index, style);
        IScannerInfo scanInfo = configureWith.getScannerInfo((style & 8) == 0);
        if (scanInfo == null) {
            return null;
        }
        CodeReader reader = this.getCodeReader();
        this.fLanguageOfContext = language = configureWith.getLanguage();
        if (language != null) {
            return language.getCompletionNode(reader, scanInfo, codeReaderFactory, index, ParserUtil.getParserLogService(), offset);
        }
        return null;
    }

    public CodeReader getCodeReader() {
        IPath location = this.getLocation();
        CodeReader reader = this.isWorkingCopy() || location == null ? (location == null ? new CodeReader(this.getContents()) : new CodeReader(location.toOSString(), this.getContents())) : ParserUtil.createReader(location.toOSString(), null);
        return reader;
    }

    public IScannerInfo getScannerInfo(boolean force) {
        IScannerInfo scanInfo;
        IResource infoResource;
        IResource resource = this.getResource();
        ICProject project = this.getCProject();
        IProject rproject = project.getProject();
        Object object = infoResource = resource != null ? resource : rproject;
        if (!force && CoreModel.isScannerInformationEmpty(infoResource)) {
            return null;
        }
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(rproject);
        if (provider != null && (scanInfo = provider.getScannerInformation(infoResource)) != null) {
            return scanInfo;
        }
        if (force) {
            return new ScannerInfo();
        }
        return null;
    }

    public ILanguage getLanguageOfContext() throws CoreException {
        ILanguage result = this.fLanguageOfContext;
        return result != null ? result : this.getLanguage();
    }
}

