/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;

public class CModelListener
implements IElementChangedListener,
IResourceChangeListener {
    private PDOMManager fManager;

    public CModelListener(PDOMManager manager) {
        this.fManager = manager;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        try {
            this.processDelta(event.getDelta());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private void processDelta(ICElementDelta delta) throws CoreException {
        int type = delta.getElement().getElementType();
        block0 : switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i]);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject project = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 1: {
                        this.fManager.addProject(project);
                        break block0;
                    }
                    case 4: {
                        this.fManager.changeProject(project, delta);
                        break block0;
                    }
                    case 2: {
                        this.fManager.removeProject(project, delta);
                    }
                }
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 16) {
            this.fManager.handlePostBuildEvent();
        }
    }
}

