/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.ApplyVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.MacroCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class PDOM
extends PlatformObject
implements IIndexFragment,
IPDOM {
    public static final String FRAGMENT_PROPERTY_VALUE_FORMAT_ID = "org.eclipse.cdt.internal.core.pdom.PDOM";
    public static final int CURRENT_VERSION = 39;
    public static final int MIN_SUPPORTED_VERSION = 36;
    public static final int MIN_VERSION_TO_WRITE_NESTED_BINDINGS_INDEX = 37;
    public static final int MIN_VERSION_TO_WRITE_MACROS_INDEX = 38;
    public static final int EARLIEST_FORWARD_COMPATIBLE_VERSION = 36;
    public static final int LINKAGES = 1028;
    public static final int FILE_INDEX = 1032;
    public static final int PROPERTIES = 1036;
    public static final int HAS_NESTED_BINDING_BTREES = 1040;
    public static final int HAS_MACRO_BTREES = 1041;
    public static final int MACRO_BTREE = 1044;
    public static final int END = 1048;
    protected Database db;
    private BTree fileIndex;
    private BTree fMacroIndex = null;
    private Map fLinkageIDCache = new HashMap();
    private File fPath;
    private IIndexLocationConverter locationConverter;
    private Map fPDOMLinkageFactoryCache;
    private boolean fHasBTreeForNestedBindings;
    private boolean fHasBTreeForMacros;
    private HashMap fResultCache = new HashMap();
    private List listeners;
    private Object mutex = new Object();
    private int lockCount;
    private int waitingReaders;
    private long lastWriteAccess = 0L;
    private long lastReadAccess = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName(FRAGMENT_PROPERTY_VALUE_FORMAT_ID);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PDOM(File dbPath, IIndexLocationConverter locationConverter, Map linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public PDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map linkageFactoryMappings) throws CoreException {
        this.fPDOMLinkageFactoryCache = linkageFactoryMappings;
        this.loadDatabase(dbPath, cache);
        this.locationConverter = locationConverter;
    }

    protected boolean isPermanentlyReadOnly() {
        return true;
    }

    private void loadDatabase(File dbPath, ChunkCache cache) throws CoreException {
        this.fPath = dbPath;
        boolean lockDB = this.db == null || this.lockCount != 0;
        this.db = new Database(this.fPath, cache, 39, this.isPermanentlyReadOnly());
        this.fileIndex = null;
        this.fMacroIndex = null;
        this.db.setLocked(lockDB);
        int version = this.db.getVersion();
        if (version >= 36) {
            this.readLinkages();
            this.fHasBTreeForNestedBindings = this.db.getByte(1040) == 1;
            boolean bl = this.fHasBTreeForMacros = this.db.getByte(1041) == 1;
            if (!this.isPermanentlyReadOnly()) {
                if (version >= 37 && !this.fHasBTreeForNestedBindings) {
                    this.fHasBTreeForNestedBindings = true;
                    this.db.putByte(1040, (byte)1);
                }
                if (version >= 38 && !this.fHasBTreeForMacros) {
                    this.fHasBTreeForMacros = true;
                    this.db.putByte(1041, (byte)1);
                }
            }
        }
        this.db.setLocked(this.lockCount != 0);
    }

    public IIndexLocationConverter getLocationConverter() {
        return this.locationConverter;
    }

    public boolean isCurrentVersion() throws CoreException {
        return this.db.getVersion() == 39;
    }

    public boolean isSupportedVersion() throws CoreException {
        return this.db.getVersion() >= 36;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        Iterator iter = this.fLinkageIDCache.values().iterator();
        while (iter.hasNext()) {
            PDOMLinkage linkage = (PDOMLinkage)iter.next();
            linkage.accept(visitor);
        }
    }

    public void addListener(IListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireChange() {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IListener)i.next()).handleChange(this);
        }
    }

    public Database getDB() {
        return this.db;
    }

    public BTree getFileIndex() throws CoreException {
        if (this.fileIndex == null) {
            this.fileIndex = new BTree(this.getDB(), 1032, new PDOMFile.Comparator(this.getDB()));
        }
        return this.fileIndex;
    }

    public IIndexFragmentFile getFile(IIndexFileLocation location) throws CoreException {
        return PDOMFile.findFile(this, this.getFileIndex(), location, this.locationConverter);
    }

    public List getAllFileLocations() throws CoreException {
        final ArrayList locations = new ArrayList();
        this.getFileIndex().accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 0;
            }

            public boolean visit(int record) throws CoreException {
                PDOMFile file = new PDOMFile(PDOM.this, record);
                locations.add(file.getLocation());
                return true;
            }
        });
        return locations;
    }

    protected IIndexFragmentFile addFile(IIndexFileLocation location) throws CoreException {
        IIndexFragmentFile file = this.getFile(location);
        if (file == null) {
            PDOMFile pdomFile = new PDOMFile(this, location);
            this.getFileIndex().insert(pdomFile.getRecord());
            file = pdomFile;
        }
        return file;
    }

    protected void clearFileIndex() throws CoreException {
        this.db.putInt(1032, 0);
        this.fileIndex = null;
    }

    protected void clear() throws CoreException {
        if (!$assertionsDisabled && this.lockCount >= 0) {
            throw new AssertionError();
        }
        this.db.clear(39);
        this.db.putByte(1040, (byte)1);
        this.db.putByte(1041, (byte)1);
        this.fHasBTreeForNestedBindings = true;
        this.fHasBTreeForMacros = true;
        this.clearCaches();
    }

    void reloadFromFile(File file) throws CoreException {
        if (!$assertionsDisabled && this.lockCount >= 0) {
            throw new AssertionError();
        }
        File oldFile = this.fPath;
        this.clearCaches();
        try {
            this.db.close();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        this.loadDatabase(file, this.db.getChunkCache());
        this.db.setExclusiveLock();
        oldFile.delete();
    }

    public boolean isEmpty() throws CoreException {
        return this.getFirstLinkageRecord() == 0;
    }

    public IName[] getDefinitions(IBinding binding) throws CoreException {
        if (binding instanceof PDOMBinding) {
            ArrayList<PDOMName> names = new ArrayList<PDOMName>();
            PDOMName name = ((PDOMBinding)binding).getFirstDefinition();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
            return names.toArray(new IIndexName[names.size()]);
        }
        return IIndexFragmentName.EMPTY_NAME_ARRAY;
    }

    public IName[] getReferences(IBinding binding) throws CoreException {
        if (binding instanceof PDOMBinding) {
            ArrayList<PDOMName> names = new ArrayList<PDOMName>();
            PDOMName name = ((PDOMBinding)binding).getFirstReference();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
            return names.toArray(new IIndexName[names.size()]);
        }
        return IIndexFragmentName.EMPTY_NAME_ARRAY;
    }

    public IIndexFragmentBinding findBinding(IASTName name) throws CoreException {
        PDOMLinkage linkage = this.adaptLinkage(name.getLinkage());
        if (linkage != null) {
            return linkage.resolveBinding(name);
        }
        return null;
    }

    public IIndexBinding[] findBindings(Pattern pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new Pattern[]{pattern}, isFullyQualified, filter, monitor);
    }

    public IIndexFragmentBinding[] findBindings(Pattern[] pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        BindingFinder finder = new BindingFinder(pattern, isFullyQualified, filter, monitor);
        Iterator iter = this.fLinkageIDCache.values().iterator();
        while (iter.hasNext()) {
            PDOMLinkage linkage = (PDOMLinkage)iter.next();
            if (!filter.acceptLinkage(linkage)) continue;
            try {
                linkage.accept(finder);
            }
            catch (CoreException e) {
                if (e.getStatus() != Status.OK_STATUS) {
                    throw e;
                }
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        return finder.getBindings();
    }

    public IIndexFragmentBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList result = new ArrayList();
        Iterator iter = this.fLinkageIDCache.values().iterator();
        while (iter.hasNext()) {
            PDOMLinkage linkage = (PDOMLinkage)iter.next();
            if (!filter.acceptLinkage(linkage)) continue;
            ArrayList<Object> bindings = new ArrayList<Object>();
            bindings.add(linkage);
            int i = 0;
            while (i < names.length) {
                char[] name = names[i];
                IndexFilter levelFilter = i == names.length - 1 ? filter : IndexFilter.ALL;
                BindingCollector collector = new BindingCollector(linkage, name, levelFilter, false, true);
                Iterator in = bindings.iterator();
                while (in.hasNext()) {
                    PDOMNode node = (PDOMNode)in.next();
                    node.accept(collector);
                }
                bindings.clear();
                bindings.addAll(Arrays.asList(collector.getBindings()));
                ++i;
            }
            result.addAll(bindings);
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    private void readLinkages() throws CoreException {
        int record = this.getFirstLinkageRecord();
        while (record != 0) {
            String linkageID = PDOMLinkage.getId(this, record).getString();
            IPDOMLinkageFactory factory = (IPDOMLinkageFactory)this.fPDOMLinkageFactoryCache.get(linkageID);
            if (factory != null) {
                PDOMLinkage linkage = factory.getLinkage(this, record);
                this.fLinkageIDCache.put(linkageID, linkage);
            }
            record = PDOMLinkage.getNextLinkageRecord(this, record);
        }
    }

    public PDOMLinkage getLinkage(String linkageID) throws CoreException {
        return (PDOMLinkage)this.fLinkageIDCache.get(linkageID);
    }

    public PDOMLinkage createLinkage(String linkageID) throws CoreException {
        IPDOMLinkageFactory factory;
        PDOMLinkage pdomLinkage = (PDOMLinkage)this.fLinkageIDCache.get(linkageID);
        if (pdomLinkage == null && (factory = (IPDOMLinkageFactory)this.fPDOMLinkageFactoryCache.get(linkageID)) != null) {
            return factory.createLinkage(this);
        }
        return pdomLinkage;
    }

    public PDOMLinkage getLinkage(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        Iterator i = this.fLinkageIDCache.values().iterator();
        while (i.hasNext()) {
            PDOMLinkage linkage = (PDOMLinkage)i.next();
            if (linkage.getRecord() != record) continue;
            return linkage;
        }
        String id = PDOMLinkage.getId(this, record).getString();
        return this.createLinkage(id);
    }

    private int getFirstLinkageRecord() throws CoreException {
        return this.db.getInt(1028);
    }

    public IIndexLinkage[] getLinkages() {
        Collection values = this.fLinkageIDCache.values();
        return values.toArray(new IIndexLinkage[values.size()]);
    }

    public PDOMLinkage[] getLinkageImpls() {
        Collection values = this.fLinkageIDCache.values();
        return values.toArray(new PDOMLinkage[values.size()]);
    }

    public void insertLinkage(PDOMLinkage linkage) throws CoreException {
        linkage.setNext(this.db.getInt(1028));
        this.db.putInt(1028, linkage.getRecord());
        this.fLinkageIDCache.put(linkage.getID(), linkage);
    }

    public PDOMBinding getBinding(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        PDOMNode node = PDOMNode.getLinkage(this, record).getNode(record);
        return node instanceof PDOMBinding ? (PDOMBinding)node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquireReadLock() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            ++this.waitingReaders;
            try {
                while (this.lockCount < 0) {
                    this.mutex.wait();
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                --this.waitingReaders;
                throw throwable;
            }
            {
                Object var2_4 = null;
                --this.waitingReaders;
                ++this.lockCount;
                this.db.setLocked(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReadLock() {
        boolean clearCache = false;
        Object object = this.mutex;
        synchronized (object) {
            if (!$assertionsDisabled && this.lockCount <= 0) {
                throw new AssertionError((Object)"No lock to release");
            }
            this.lastReadAccess = System.currentTimeMillis();
            if (this.lockCount > 0) {
                --this.lockCount;
            }
            this.mutex.notifyAll();
            clearCache = this.lockCount == 0;
            this.db.setLocked(this.lockCount != 0);
        }
        if (clearCache) {
            this.clearResultCache();
        }
    }

    public void acquireWriteLock() throws InterruptedException {
        this.acquireWriteLock(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock(int giveupReadLocks) throws InterruptedException {
        if (!$assertionsDisabled && this.isPermanentlyReadOnly()) {
            throw new AssertionError();
        }
        Object object = this.mutex;
        synchronized (object) {
            if (giveupReadLocks > 0) {
                if (!$assertionsDisabled && this.lockCount < giveupReadLocks) {
                    throw new AssertionError((Object)"Not enough locks to release");
                }
                if (this.lockCount < giveupReadLocks) {
                    giveupReadLocks = this.lockCount;
                }
            } else {
                giveupReadLocks = 0;
            }
            while (this.lockCount > giveupReadLocks || this.waitingReaders > 0) {
                this.mutex.wait();
            }
            this.lockCount = -1;
            this.db.setExclusiveLock();
        }
    }

    public final void releaseWriteLock() {
        this.releaseWriteLock(0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock(int establishReadLocks, boolean flush) {
        this.clearResultCache();
        try {
            this.db.giveUpExclusiveLock(flush);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        if (!$assertionsDisabled && this.lockCount != -1) {
            throw new AssertionError();
        }
        this.lastWriteAccess = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            if (this.lockCount < 0) {
                this.lockCount = establishReadLocks;
            }
            this.mutex.notifyAll();
            this.db.setLocked(this.lockCount != 0);
        }
        this.fireChange();
    }

    public long getLastWriteAccess() {
        return this.lastWriteAccess;
    }

    public long getLastReadAccess() {
        return this.lastReadAccess;
    }

    protected PDOMLinkage adaptLinkage(ILinkage linkage) throws CoreException {
        return (PDOMLinkage)this.fLinkageIDCache.get(linkage.getID());
    }

    public IIndexFragmentBinding adaptBinding(IBinding binding) throws CoreException {
        PDOMBinding pdomBinding;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((pdomBinding = (PDOMBinding)binding.getAdapter(clazz)) != null && pdomBinding.getPDOM() == this) {
            return pdomBinding;
        }
        PDOMLinkage linkage = this.adaptLinkage(binding.getLinkage());
        if (linkage != null) {
            return linkage.adaptBinding(binding);
        }
        return null;
    }

    public IIndexFragmentBinding adaptBinding(IIndexFragmentBinding binding) throws CoreException {
        if (binding != null) {
            return this.adaptBinding((IBinding)binding);
        }
        return null;
    }

    public IIndexFragmentBinding findBinding(IIndexFragmentName indexName) throws CoreException {
        if (indexName instanceof PDOMName) {
            PDOMName pdomName = (PDOMName)indexName;
            return pdomName.getPDOMBinding();
        }
        return null;
    }

    public IIndexFragmentName[] findNames(IBinding binding, int options) throws CoreException {
        IIndexFragmentBinding proxyBinding = this.adaptBinding(binding);
        if (proxyBinding != null) {
            return this.findNames(proxyBinding, options);
        }
        return IIndexFragmentName.EMPTY_NAME_ARRAY;
    }

    public IIndexFragmentName[] findNames(IIndexFragmentBinding binding, int options) throws CoreException {
        PDOMBinding pdomBinding = (PDOMBinding)this.adaptBinding(binding);
        if (pdomBinding != null) {
            PDOMName name;
            ArrayList<PDOMName> names = new ArrayList<PDOMName>();
            if ((options & 1) != 0) {
                name = pdomBinding.getFirstDeclaration();
                while (name != null) {
                    names.add(name);
                    name = name.getNextInBinding();
                }
            }
            if ((options & 2) != 0) {
                name = pdomBinding.getFirstDefinition();
                while (name != null) {
                    names.add(name);
                    name = name.getNextInBinding();
                }
            }
            if ((options & 4) != 0) {
                name = pdomBinding.getFirstReference();
                while (name != null) {
                    names.add(name);
                    name = name.getNextInBinding();
                }
            }
            return names.toArray(new IIndexFragmentName[names.size()]);
        }
        return IIndexFragmentName.EMPTY_NAME_ARRAY;
    }

    public IIndexFragmentInclude[] findIncludedBy(IIndexFragmentFile file) throws CoreException {
        PDOMFile pdomFile = this.adaptFile(file);
        if (pdomFile != null) {
            ArrayList<PDOMInclude> result = new ArrayList<PDOMInclude>();
            PDOMInclude i = pdomFile.getFirstIncludedBy();
            while (i != null) {
                result.add(i);
                i = i.getNextInIncludedBy();
            }
            return result.toArray(new PDOMInclude[result.size()]);
        }
        return new PDOMInclude[0];
    }

    private PDOMFile adaptFile(IIndexFragmentFile file) throws CoreException {
        if (file.getIndexFragment() == this && file instanceof PDOMFile) {
            return (PDOMFile)file;
        }
        return (PDOMFile)this.getFile(file.getLocation());
    }

    public File getPath() {
        return this.fPath;
    }

    public IIndexFragmentBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        Iterator iter = this.fLinkageIDCache.values().iterator();
        while (iter.hasNext()) {
            PDOMLinkage linkage = (PDOMLinkage)iter.next();
            if (!filter.acceptLinkage(linkage)) continue;
            BindingCollector visitor = new BindingCollector(linkage, prefix, filter, true, false);
            visitor.setMonitor(monitor);
            try {
                linkage.accept(visitor);
                if (!filescope) {
                    if (this.fHasBTreeForNestedBindings) {
                        linkage.getNestedBindingsIndex().accept(visitor);
                    } else {
                        linkage.accept(new ApplyVisitor(linkage, visitor));
                    }
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
            IBinding[] bindings = visitor.getBindings();
            int j = 0;
            while (j < bindings.length) {
                result.add(bindings[j]);
                ++j;
            }
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    public IIndexMacro[] findMacros(char[] prefix, boolean isPrefix, boolean isCaseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (!this.fHasBTreeForMacros) {
            return IIndexMacro.EMPTY_INDEX_MACRO_ARRAY;
        }
        ArrayList result = new ArrayList();
        MacroCollector visitor = new MacroCollector(this, prefix, isPrefix, isCaseSensitive);
        visitor.setMonitor(monitor);
        try {
            this.getMacroIndex().accept(visitor);
            result.addAll(visitor.getMacroList());
        }
        catch (OperationCanceledException operationCanceledException) {}
        return result.toArray(new IIndexMacro[result.size()]);
    }

    private BTree getMacroIndex() {
        if (this.fMacroIndex == null) {
            this.fMacroIndex = new BTree(this.db, 1044, new FindBinding.MacroBTreeComparator(this));
        }
        return this.fMacroIndex;
    }

    public void afterAddMacro(PDOMMacro macro) throws CoreException {
        this.getMacroIndex().insert(macro.getRecord());
    }

    public void beforeRemoveMacro(PDOMMacro macro) throws CoreException {
        this.getMacroIndex().delete(macro.getRecord());
    }

    public String getProperty(String propertyName) throws CoreException {
        if ("org.eclipse.cdt.internal.core.index.fragment.format.id".equals(propertyName)) {
            return FRAGMENT_PROPERTY_VALUE_FORMAT_ID;
        }
        if ("org.eclipse.cdt.internal.core.index.fragment.format.version".equals(propertyName)) {
            return "" + this.db.getVersion();
        }
        return new DBProperties(this.db, 1036).getProperty(propertyName);
    }

    public void close() throws CoreException {
        this.db.close();
        this.clearCaches();
    }

    private void clearCaches() {
        this.fileIndex = null;
        this.fMacroIndex = null;
        this.fLinkageIDCache.clear();
        this.clearResultCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearResultCache() {
        HashMap hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.clear();
        }
    }

    public long getCacheHits() {
        return this.db.getCacheHits();
    }

    public long getCacheMisses() {
        return this.db.getCacheMisses();
    }

    public void resetCacheCounters() {
        this.db.resetCacheCounters();
    }

    protected void flush() throws CoreException {
        this.db.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedResult(Object binding) {
        HashMap hashMap = this.fResultCache;
        synchronized (hashMap) {
            return this.fResultCache.get(binding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCachedResult(Object key, Object result) {
        HashMap hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.put(key, result);
        }
    }

    public String createKeyForCache(int record, char[] name) {
        return new StringBuffer(name.length + 2).append((char)(record >> 16)).append((char)record).append(name).toString();
    }

    private static class BindingFinder
    implements IPDOMVisitor {
        private final Pattern[] pattern;
        private final IProgressMonitor monitor;
        private final ArrayList currentPath = new ArrayList();
        private final ArrayList matchStack = new ArrayList();
        private List bindings = new ArrayList();
        private boolean isFullyQualified;
        private BitSet matchesUpToLevel;
        private IndexFilter filter;

        public BindingFinder(Pattern[] pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) {
            this.pattern = pattern;
            this.monitor = monitor;
            this.isFullyQualified = isFullyQualified;
            this.filter = filter;
            this.matchesUpToLevel = new BitSet();
            this.matchesUpToLevel.set(0);
            this.matchStack.add(this.matchesUpToLevel);
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (this.monitor.isCanceled()) {
                throw new CoreException(Status.OK_STATUS);
            }
            if (node instanceof PDOMBinding) {
                PDOMBinding binding = (PDOMBinding)node;
                String name = binding.getName();
                int lastIdx = this.pattern.length - 1;
                if (this.matchesUpToLevel.get(lastIdx) && this.pattern[lastIdx].matcher(name).matches() && this.filter.acceptBinding(binding)) {
                    this.bindings.add(binding);
                }
                if (binding.mayHaveChildren()) {
                    boolean visitNextLevel = false;
                    BitSet updatedMatchesUpToLevel = new BitSet();
                    if (!this.isFullyQualified) {
                        updatedMatchesUpToLevel.set(0);
                        visitNextLevel = true;
                    }
                    int i = 0;
                    while (i < lastIdx) {
                        if (this.matchesUpToLevel.get(i) && this.pattern[i].matcher(name).matches()) {
                            updatedMatchesUpToLevel.set(i + 1);
                            visitNextLevel = true;
                        }
                        ++i;
                    }
                    if (visitNextLevel) {
                        this.matchStack.add(this.matchesUpToLevel);
                        this.matchesUpToLevel = updatedMatchesUpToLevel;
                        this.currentPath.add(binding);
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
            int idx = this.currentPath.size() - 1;
            if (idx >= 0 && this.currentPath.get(idx) == node) {
                this.currentPath.remove(idx);
                this.matchesUpToLevel = (BitSet)this.matchStack.remove(this.matchStack.size() - 1);
            }
        }

        public IIndexFragmentBinding[] getBindings() {
            return this.bindings.toArray(new IIndexFragmentBinding[this.bindings.size()]);
        }
    }

    public static interface IListener {
        public void handleChange(PDOM var1);
    }
}

