/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerASTVisitor;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerStatistics;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public abstract class PDOMWriter {
    public static int SKIP_ALL_REFERENCES;
    public static int SKIP_TYPE_REFERENCES;
    public static int SKIP_NO_REFERENCES;
    protected boolean fShowActivity;
    protected boolean fShowProblems;
    protected IndexerStatistics fStatistics;
    private IndexerProgress fInfo = new IndexerProgress();
    private int fSkipReferences = SKIP_NO_REFERENCES;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.PDOMWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SKIP_ALL_REFERENCES = -1;
        SKIP_TYPE_REFERENCES = 1;
        SKIP_NO_REFERENCES = 0;
    }

    public PDOMWriter() {
        this.fStatistics = new IndexerStatistics();
    }

    public void setShowActivity(boolean val) {
        this.fShowActivity = val;
    }

    public void setShowProblems(boolean val) {
        this.fShowProblems = val;
    }

    public void setSkipReferences(int options) {
        this.fSkipReferences = options;
    }

    protected abstract boolean needToUpdate(IIndexFileLocation var1, int var2) throws CoreException;

    protected abstract boolean postAddToIndex(IIndexFileLocation var1, IIndexFile var2) throws CoreException;

    protected abstract IIndexFileLocation findLocation(String var1);

    public void addSymbols(IASTTranslationUnit ast, IWritableIndex index, int readlockCount, int configHash, IProgressMonitor pm) throws InterruptedException, CoreException {
        this.addSymbols(ast, index, readlockCount, true, configHash, null, pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSymbols(IASTTranslationUnit ast, IWritableIndex index, int readlockCount, boolean flushIndex, int configHash, ITodoTaskUpdater taskUpdater, IProgressMonitor pm) throws InterruptedException, CoreException {
        block40: {
            symbolMap = new HashMap<K, V>();
            stati = new ArrayList<IStatus>();
            orderedPaths = null;
            try {
                contextIncludes = new HashSet<E>();
                orderedPaths = this.extractSymbols(ast, symbolMap, configHash, contextIncludes);
                i = 0;
                while (i < orderedPaths.length) {
                    block42: {
                        block41: {
                            if (!pm.isCanceled()) break block41;
                            break block42;
                        }
                        path = orderedPaths[i];
                        arrayLists = (ArrayList[])symbolMap.get(path);
                        start = System.currentTimeMillis();
                        names = arrayLists[2];
                        reported = false;
                        j = names.iterator();
                        if (true) ** GOTO lbl59
                    }
lbl21:
                    // 2 sources

                    while (true) {
                        var23_34 = null;
                        var25_37 = this.fInfo;
                        synchronized (var25_37) {
                            ++this.fInfo.fCompletedSources;
                            return;
                        }
                        break;
                    }
                    do {
                        na = (IASTName[])j.next();
                        name = na[0];
                        try {
                            binding = name.resolveBinding();
                            if (binding instanceof IProblemBinding) {
                                this.reportProblem((IProblemBinding)binding);
                                continue;
                            }
                            if (name.isReference()) {
                                if (this.fSkipReferences == PDOMWriter.SKIP_TYPE_REFERENCES && this.isTypeReferenceBinding(binding) && !this.isInheritanceSpec(name)) {
                                    na[0] = null;
                                    --this.fStatistics.fReferenceCount;
                                }
                                ++this.fStatistics.fReferenceCount;
                                continue;
                            }
                            ++this.fStatistics.fDeclarationCount;
                        }
                        catch (RuntimeException e) {
                            if (!reported) {
                                stati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorResolvingName, (Object)name.toString(), (Object)path.getURI().getPath()), e));
                            }
                            reported = true;
                            j.remove();
                        }
                        catch (PDOMNotImplementedError e) {
                            if (!reported) {
                                stati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorResolvingName, (Object)name.toString(), (Object)path.getURI().getPath()), e));
                            }
                            reported = true;
                            j.remove();
                        }
lbl59:
                        // 6 sources

                    } while (j.hasNext());
                    this.fStatistics.fResolutionTime = (int)((long)this.fStatistics.fResolutionTime + (System.currentTimeMillis() - start));
                    ++i;
                }
                isFirstRequest = true;
                isFirstAddition = true;
                index.acquireWriteLock(readlockCount);
                start = System.currentTimeMillis();
                try {
                    i = 0;
                    while (i < orderedPaths.length) {
                        if (pm.isCanceled()) {
                            var21_29 = null;
                            index.releaseWriteLock(readlockCount, flushIndex);
                            ** continue;
                        }
                        path = orderedPaths[i];
                        if (path != null) {
                            if (this.fShowActivity) {
                                System.out.println("Indexer: adding " + path.getURI());
                            }
                            try {
                                file = this.addToIndex(index, path, symbolMap, configHash, contextIncludes);
                            }
                            catch (RuntimeException e) {
                                stati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)path.getURI().getPath()), e));
                                break;
                            }
                            catch (PDOMNotImplementedError e) {
                                stati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)path.getURI().getPath()), e));
                                break;
                            }
                            wasRequested = this.postAddToIndex(path, file);
                            var20_28 = this.fInfo;
                            synchronized (var20_28) {
                                if (wasRequested) {
                                    if (isFirstRequest) {
                                        isFirstRequest = false;
                                    } else {
                                        --this.fInfo.fTotalSourcesEstimate;
                                    }
                                }
                                if (isFirstAddition) {
                                    isFirstAddition = false;
                                } else {
                                    ++this.fInfo.fCompletedHeaders;
                                }
                            }
                        }
                        ++i;
                    }
                    var21_29 = null;
                    index.releaseWriteLock(readlockCount, flushIndex);
                }
                catch (Throwable var22_33) {
                    var21_29 = null;
                    index.releaseWriteLock(readlockCount, flushIndex);
                    throw var22_33;
                }
                this.fStatistics.fAddToIndexTime = (int)((long)this.fStatistics.fAddToIndexTime + (System.currentTimeMillis() - start));
                if (taskUpdater != null) {
                    taskUpdater.updateTasks(ast.getComments(), orderedPaths);
                }
                var23_36 = null;
                var25_39 = this.fInfo;
                ** GOTO lbl131
            }
            catch (Throwable var24_41) {
                var23_35 = null;
                var25_38 = this.fInfo;
                synchronized (var25_38) {
                    ** try [egrp 6[TRYBLOCK] [12 : 737->756)] { 
lbl129:
                    // 1 sources

                    ++this.fInfo.fCompletedSources;
                    throw var24_41;
                }
lbl131:
                // 1 sources

                synchronized (var25_39) {
                    ** try [egrp 6[TRYBLOCK] [12 : 737->756)] { 
lbl133:
                    // 1 sources

                    ++this.fInfo.fCompletedSources;
                    break block40;
                }
lbl-1000:
                // 1 sources

                {
                    catch (Throwable v2) {
                        throw v2;
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                catch (Throwable v3) {
                    throw v3;
                }
            }
        }
        if (stati.isEmpty() != false) return;
        path = null;
        path = orderedPaths != null && orderedPaths.length > 0 ? orderedPaths[orderedPaths.length - 1].getURI().getPath() : ast.getFilePath().toString();
        msg = NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)path);
        if (stati.size() != 1) throw new CoreException((IStatus)new MultiStatus("org.eclipse.cdt.core", 0, stati.toArray(new IStatus[stati.size()]), msg, null));
        status = (IStatus)stati.get(0);
        if (msg.equals(status.getMessage()) == false) throw new CoreException((IStatus)new MultiStatus("org.eclipse.cdt.core", 0, stati.toArray(new IStatus[stati.size()]), msg, null));
        throw new CoreException(status);
    }

    private IIndexFileLocation[] extractSymbols(IASTTranslationUnit ast, final Map symbolMap, int confighash, Collection contextIncludes) throws CoreException {
        IIndexFileLocation astLocation;
        LinkedHashSet<IIndexFileLocation> orderedIFLs = new LinkedHashSet<IIndexFileLocation>();
        ArrayList<IIndexFileLocation> iflStack = new ArrayList<IIndexFileLocation>();
        HashMap<IIndexFileLocation, IASTPreprocessorIncludeStatement> firstIncludePerTarget = new HashMap<IIndexFileLocation, IASTPreprocessorIncludeStatement>();
        IIndexFileLocation aboveStackIFL = astLocation = this.findLocation(ast.getFilePath());
        IASTPreprocessorIncludeStatement[] includes = ast.getIncludeDirectives();
        int i = 0;
        while (i < includes.length) {
            IASTPreprocessorIncludeStatement include = includes[i];
            IASTFileLocation tmpLoc = include.getFileLocation();
            IIndexFileLocation nextIFL = tmpLoc != null ? this.findLocation(tmpLoc.getFileName()) : astLocation;
            while (!aboveStackIFL.equals(nextIFL)) {
                if (!iflStack.isEmpty()) {
                    if (this.needToUpdate(aboveStackIFL, confighash)) {
                        this.prepareInMap(symbolMap, aboveStackIFL);
                        orderedIFLs.add(aboveStackIFL);
                    }
                    aboveStackIFL = (IIndexFileLocation)iflStack.remove(iflStack.size() - 1);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                iflStack.add(aboveStackIFL);
                aboveStackIFL = nextIFL;
                break;
            }
            if (this.needToUpdate(nextIFL, confighash)) {
                this.prepareInMap(symbolMap, nextIFL);
                this.addToMap(symbolMap, 0, nextIFL, include);
            }
            if (include.isResolved()) {
                iflStack.add(nextIFL);
                aboveStackIFL = this.findLocation(include.getPath());
                if (include.isActive() && !firstIncludePerTarget.containsKey(aboveStackIFL)) {
                    firstIncludePerTarget.put(aboveStackIFL, include);
                }
            } else if (include.isActive()) {
                this.reportProblem(include);
            }
            ++i;
        }
        iflStack.add(aboveStackIFL);
        while (!iflStack.isEmpty()) {
            aboveStackIFL = (IIndexFileLocation)iflStack.remove(iflStack.size() - 1);
            if (!this.needToUpdate(aboveStackIFL, confighash)) continue;
            this.prepareInMap(symbolMap, aboveStackIFL);
            orderedIFLs.add(aboveStackIFL);
        }
        Iterator iterator = orderedIFLs.iterator();
        while (iterator.hasNext()) {
            IndexFileLocation loc = (IndexFileLocation)iterator.next();
            Object contextInclude = firstIncludePerTarget.get(loc);
            if (contextInclude == null) continue;
            contextIncludes.add(contextInclude);
        }
        IASTPreprocessorMacroDefinition[] macros = ast.getMacroDefinitions();
        int i2 = 0;
        while (i2 < macros.length) {
            IASTPreprocessorMacroDefinition macro = macros[i2];
            IASTFileLocation sourceLoc = macro.getFileLocation();
            if (sourceLoc != null) {
                IIndexFileLocation path2 = this.findLocation(sourceLoc.getFileName());
                this.addToMap(symbolMap, 1, path2, macro);
            }
            ++i2;
        }
        ast.accept(new IndexerASTVisitor(){

            public void visit(IASTName name, IASTName caller) {
                if (PDOMWriter.this.fSkipReferences == SKIP_ALL_REFERENCES && name.isReference() && !PDOMWriter.this.isInheritanceSpec(name)) {
                    return;
                }
                IASTFileLocation nameLoc = (name = PDOMASTAdapter.getAdapterIfAnonymous(name)).getFileLocation();
                if (nameLoc != null) {
                    IIndexFileLocation location = PDOMWriter.this.findLocation(nameLoc.getFileName());
                    PDOMWriter.this.addToMap(symbolMap, 2, location, new IASTName[]{name, caller});
                }
            }
        });
        return orderedIFLs.toArray(new IIndexFileLocation[orderedIFLs.size()]);
    }

    protected boolean isInheritanceSpec(IASTName name) {
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            return true;
        }
        if (parentNode instanceof IASTDeclSpecifier) {
            IASTDeclSpecifier ds = (IASTDeclSpecifier)parentNode;
            return ds.getStorageClass() == 1;
        }
        return false;
    }

    private boolean isTypeReferenceBinding(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef || binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias || binding instanceof ICPPClassTemplate;
    }

    private void reportProblem(IASTPreprocessorIncludeStatement problem) {
        ++this.fStatistics.fUnresolvedIncludes;
        if (this.fShowProblems) {
            String msg = "Indexer: unresolved include";
            IASTFileLocation loc = problem.getFileLocation();
            if (loc != null && loc.getFileName() != null) {
                msg = String.valueOf(msg) + " at " + loc.getFileName() + ": " + loc.getStartingLineNumber();
            }
            System.out.println(msg);
        }
    }

    private void reportProblem(IProblemBinding problem) {
        ++this.fStatistics.fProblemBindingCount;
        if (this.fShowProblems) {
            String msg = "Indexer: problem at " + problem.getFileName() + ": " + problem.getLineNumber();
            String pmsg = problem.getMessage();
            if (pmsg != null && pmsg.length() > 0) {
                msg = String.valueOf(msg) + "; " + problem.getMessage();
            }
            System.out.println(msg);
        }
    }

    private void addToMap(Map map, int idx, IIndexFileLocation location, Object thing) {
        List[] lists = (List[])map.get(location);
        if (lists != null) {
            lists[idx].add(thing);
        }
    }

    private boolean prepareInMap(Map map, IIndexFileLocation location) {
        if (map.get(location) == null) {
            ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
            map.put(location, lists);
        }
        return false;
    }

    private IIndexFragmentFile addToIndex(IWritableIndex index, IIndexFileLocation location, Map symbolMap, int configHash, Set contextIncludes) throws CoreException {
        HashSet clearedContexts = Collections.EMPTY_SET;
        IIndexFragmentFile file = index.getWritableFile(location);
        if (file != null) {
            clearedContexts = new HashSet();
            index.clearFile(file, clearedContexts);
        } else {
            file = index.addFile(location);
        }
        file.setTimestamp(this.getLastModified(location));
        file.setScannerConfigurationHashcode(configHash);
        ArrayList[] lists = (ArrayList[])symbolMap.get(location);
        if (lists != null) {
            ArrayList list = lists[1];
            IASTPreprocessorMacroDefinition[] macros = list.toArray(new IASTPreprocessorMacroDefinition[list.size()]);
            list = lists[2];
            IASTName[][] names = (IASTName[][])list.toArray((T[])new IASTName[list.size()][]);
            list = lists[0];
            IWritableIndex.IncludeInformation[] includeInfos = new IWritableIndex.IncludeInformation[list.size()];
            int i = 0;
            while (i < list.size()) {
                IASTPreprocessorIncludeStatement include = (IASTPreprocessorIncludeStatement)list.get(i);
                IWritableIndex.IncludeInformation info = includeInfos[i] = new IWritableIndex.IncludeInformation();
                info.fStatement = include;
                if (include.isResolved()) {
                    info.fLocation = this.findLocation(include.getPath());
                    info.fIsContext = include.isActive() && (contextIncludes.contains(include) || clearedContexts.contains(info.fLocation));
                }
                ++i;
            }
            index.setFileContent(file, includeInfos, macros, names);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexerProgress getProgressInformation() {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            return new IndexerProgress(this.fInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInfo(int completedSources, int completedHeaders, int totalEstimate) {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            this.fInfo.fCompletedHeaders += completedHeaders;
            this.fInfo.fCompletedSources += completedSources;
            this.fInfo.fTotalSourcesEstimate += totalEstimate;
        }
    }

    protected long getLastModified(IIndexFileLocation location) throws CoreException {
        return EFS.getStore((URI)location.getURI()).fetchInfo().getLastModified();
    }
}

