/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCFunction
extends PDOMBinding
implements IFunction {
    public static final int NUM_PARAMS = 24;
    public static final int FIRST_PARAM = 28;
    private static final int FUNCTION_TYPE = 32;
    private static final int ANNOTATIONS = 36;
    public static final int RECORD_SIZE = 37;

    public PDOMCFunction(PDOM pdom, PDOMNode parent, IFunction function) throws CoreException {
        super(pdom, parent, function.getNameCharArray());
        byte annotations;
        IParameter[] parameters;
        IFunctionType type;
        try {
            type = function.getType();
            parameters = function.getParameters();
            annotations = PDOMCAnnotation.encodeAnnotation(function);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        this.setType(this.getLinkageImpl(), type);
        this.setParameters(parameters);
        pdom.getDB().putByte(this.record + 36, annotations);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IFunction) {
            byte newAnnotation;
            IParameter[] newParams;
            IFunctionType newType;
            IFunction func = (IFunction)newBinding;
            try {
                newType = func.getType();
                newParams = func.getParameters();
                newAnnotation = PDOMCAnnotation.encodeAnnotation(func);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
            IFunctionType oldType = this.getType();
            this.setType(linkage, newType);
            PDOMCParameter oldParams = this.getFirstParameter();
            this.setParameters(newParams);
            if (oldType != null) {
                linkage.deleteType(oldType, this.record);
            }
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
            this.pdom.getDB().putByte(this.record + 36, newAnnotation);
        }
    }

    private void setType(PDOMLinkage linkage, IFunctionType ft) throws CoreException {
        PDOMNode typeNode;
        int rec = 0;
        if (ft != null && (typeNode = linkage.addType(this, ft)) != null) {
            rec = typeNode.getRecord();
        }
        this.pdom.getDB().putInt(this.record + 32, rec);
    }

    private void setParameters(IParameter[] params) throws CoreException {
        this.pdom.getDB().putInt(this.record + 24, params.length);
        this.pdom.getDB().putInt(this.record + 28, 0);
        int i = 0;
        while (i < params.length) {
            this.setFirstParameter(new PDOMCParameter(this.pdom, (PDOMNode)this, params[i]));
            ++i;
        }
    }

    public PDOMCParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCParameter(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public PDOMCFunction(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 37;
    }

    public int getNodeType() {
        return 6;
    }

    public IFunctionType getType() {
        try {
            int offset = this.pdom.getDB().getInt(this.record + 32);
            return offset == 0 ? null : new PDOMCFunctionType(this.pdom, offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 4);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 1);
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 24);
            IParameter[] params = new IParameter[n];
            PDOMCParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 2);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 5);
    }

    public IScope getFunctionScope() throws DOMException {
        return null;
    }
}

