/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassType
extends PDOMCPPBinding
implements ICPPClassType,
ICPPClassScope,
IPDOMMemberOwner,
IIndexType,
IIndexScope,
ICPPDelegateCreator {
    private static final int FIRSTBASE = 24;
    private static final int KEY = 28;
    private static final int MEMBERLIST = 32;
    protected static final int RECORD_SIZE = 36;

    public PDOMCPPClassType(PDOM pdom, PDOMNode parent, ICPPClassType classType) throws CoreException {
        super(pdom, parent, classType.getNameCharArray());
        this.setKind(classType);
    }

    public PDOMCPPClassType(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setKind(ct);
            super.update(linkage, newBinding);
        }
    }

    private void setKind(ICPPClassType ct) throws CoreException {
        try {
            this.pdom.getDB().putByte(this.record + 28, (byte)ct.getKey());
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public void addMember(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 32, this.getLinkageImpl());
        list.addMember(member);
    }

    protected int getRecordSize() {
        return 36;
    }

    public int getNodeType() {
        return 7;
    }

    public PDOMCPPBase getFirstBase() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 24);
        return rec != 0 ? new PDOMCPPBase(this.pdom, rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        int rec = base != null ? base.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 24, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef || type instanceof ICPPDelegate) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPClassType && !(type instanceof ProblemBinding)) {
            ICPPClassType ctype = (ICPPClassType)type;
            ctype = (ICPPClassType)PDOMASTAdapter.getAdapterIfAnonymous(ctype);
            try {
                if (ctype.getKey() == this.getKey()) {
                    char[][] qname = ctype.getQualifiedNameCharArray();
                    return this.hasQualifiedName(qname, qname.length - 1);
                }
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public ICPPBase[] getBases() throws DOMException {
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            ICPPBase[] bases = list.toArray(new ICPPBase[list.size()]);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPBase[0];
        }
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 32, this.getLinkageImpl());
        list.accept(visitor);
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            this.accept(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    public ICPPMethod[] getMethods() throws DOMException {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(true);
            this.acceptInHierarchy(new HashSet(), methods);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPMethod[0];
        }
    }

    public ICPPMethod[] getImplicitMethods() {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(true, false);
            this.accept(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    private void acceptInHierarchy(Set visited, IPDOMVisitor visitor) throws CoreException {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        visitor.visit(this);
        this.accept(visitor);
        PDOMCPPBase base = this.getFirstBase();
        while (base != null) {
            IBinding baseClass = base.getBaseClass();
            if (baseClass != null && baseClass instanceof PDOMCPPClassType) {
                ((PDOMCPPClassType)baseClass).acceptInHierarchy(visited, visitor);
            }
            base = base.getNextBase();
        }
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        PDOMClassUtil.MethodCollector myMethods = new PDOMClassUtil.MethodCollector(false, true);
        HashSet visited = new HashSet();
        try {
            this.acceptInHierarchy(visited, myMethods);
            return myMethods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPMethod[0];
        }
    }

    public IField[] getFields() throws DOMException {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            this.acceptInHierarchy(new HashSet(), visitor);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IField[0];
        }
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            this.accept(visitor);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPField[0];
        }
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        try {
            NestedClassCollector visitor = new NestedClassCollector();
            this.accept(visitor);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPClassType[0];
        }
    }

    public IScope getCompositeScope() throws DOMException {
        return this;
    }

    public int getKey() throws DOMException {
        try {
            return this.pdom.getDB().getByte(this.record + 28);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }

    public boolean isGloballyQualified() throws DOMException {
        try {
            return this.getParentNode() instanceof PDOMLinkage;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public ICPPClassType getClassType() {
        return this;
    }

    public void addChild(PDOMNode member) throws CoreException {
        this.addMember(member);
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
        try {
            this.accept(visitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return visitor.getConstructors();
    }

    public boolean isFullyCached() {
        return true;
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        try {
            char[] nameChars = name.toCharArray();
            if (this.getDBName().equals(nameChars)) {
                if (CPPClassScope.isConstructorReference(name)) {
                    return CPPSemantics.resolveAmbiguities(name, this.getConstructors());
                }
                return this;
            }
            Object[] candidates = this.getBindingsViaCache(nameChars);
            return CPPSemantics.resolveAmbiguities(name, candidates);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) throws DOMException {
        IBinding[] result = null;
        try {
            char[] nameChars = name.toCharArray();
            if (!prefixLookup) {
                return this.getBindingsViaCache(nameChars);
            }
            BindingCollector visitor = new BindingCollector(this.getLinkageImpl(), nameChars, IndexFilter.ALL_DECLARED_OR_IMPLICIT, prefixLookup, !prefixLookup);
            if (this.getDBName().comparePrefix(nameChars, false) == 0) {
                visitor.visit(this);
            }
            this.accept(visitor);
            result = visitor.getBindings();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return result;
    }

    private IBinding[] getBindingsViaCache(char[] name) throws CoreException {
        String key = this.pdom.createKeyForCache(this.record, name);
        IBinding[] result = (IBinding[])this.pdom.getCachedResult(key);
        if (result != null) {
            return result;
        }
        BindingCollector visitor = new BindingCollector(this.getLinkageImpl(), name, IndexFilter.ALL_DECLARED_OR_IMPLICIT, false, true);
        if (this.getDBName().compare(name, true) == 0) {
            visitor.visit(this);
        }
        this.accept(visitor);
        result = visitor.getBindings();
        this.pdom.putCachedResult(key, result);
        return result;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public Object clone() {
        this.fail();
        return null;
    }

    public IField findField(String name) throws DOMException {
        this.fail();
        return null;
    }

    public IBinding[] getFriends() throws DOMException {
        this.fail();
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public void removeBase(PDOMName pdomName) throws CoreException {
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        int nameRec = pdomName.getRecord();
        while (base != null) {
            PDOMName name = base.getBaseClassSpecifierNameImpl();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = base;
            base = base.getNextBase();
        }
        if (base != null) {
            if (predecessor != null) {
                predecessor.setNextBase(base.getNextBase());
            } else {
                this.setFirstBase(base.getNextBase());
            }
            base.delete();
        }
    }

    public IIndexBinding getScopeBinding() {
        return this;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPClassType.CPPClassTypeDelegate(name, this);
    }

    private static class NestedClassCollector
    implements IPDOMVisitor {
        private List nestedClasses = new ArrayList();

        private NestedClassCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPClassType) {
                this.nestedClasses.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPClassType[] getNestedClasses() {
            return this.nestedClasses.toArray(new ICPPClassType[this.nestedClasses.size()]);
        }
    }
}

