/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;

public abstract class IndexerASTVisitor
extends ASTVisitor {
    private IASTName fDefinitionName;
    private IASTNode fDefinitionNode;
    private ArrayList fStack = new ArrayList();

    public IndexerASTVisitor() {
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitDeclSpecifiers = true;
    }

    public abstract void visit(IASTName var1, IASTName var2);

    public final int visit(IASTName name) {
        if (!(name instanceof ICPPASTQualifiedName) && name != this.fDefinitionName) {
            this.visit(name, this.fDefinitionName);
        }
        return 3;
    }

    private void push(IASTName name, IASTNode node) {
        if (this.fDefinitionName != null) {
            this.fStack.add(new Object[]{this.fDefinitionName, this.fDefinitionNode});
        }
        this.fDefinitionName = name = this.getLastInQualified(name);
        this.fDefinitionNode = node;
    }

    private IASTName getLastInQualified(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            name = ((ICPPASTQualifiedName)name).getLastName();
        }
        return name;
    }

    private void pop(IASTNode node) {
        if (node == this.fDefinitionNode) {
            if (this.fStack.isEmpty()) {
                this.fDefinitionName = null;
                this.fDefinitionNode = null;
            } else {
                Object[] old = (Object[])this.fStack.remove(this.fStack.size() - 1);
                this.fDefinitionName = (IASTName)old[0];
                this.fDefinitionNode = (IASTNode)old[1];
            }
        }
    }

    public int visit(IASTDeclaration decl) {
        IASTSimpleDeclaration sdecl;
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDeclarator declarator;
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            IASTDeclarator nestedDeclarator = declarator = fdef.getDeclarator();
            while (nestedDeclarator.getNestedDeclarator() != null) {
                nestedDeclarator = nestedDeclarator.getNestedDeclarator();
            }
            IASTName name = this.getLastInQualified(nestedDeclarator.getName());
            this.visit(name, this.fDefinitionName);
            this.push(name, decl);
        } else if (decl instanceof IASTSimpleDeclaration && (sdecl = (IASTSimpleDeclaration)decl).getDeclSpecifier().getStorageClass() == 1) {
            IASTDeclarator[] declarators = sdecl.getDeclarators();
            int i = 0;
            while (i < declarators.length) {
                IASTDeclarator declarator = declarators[i];
                if (declarator.getPointerOperators().length == 0 && declarator.getNestedDeclarator() == null) {
                    IASTName name = this.getLastInQualified(declarator.getName());
                    this.visit(name, this.fDefinitionName);
                    this.push(name, decl);
                }
                ++i;
            }
        }
        return 3;
    }

    public int leave(IASTDeclaration decl) {
        this.pop(decl);
        return 3;
    }

    public int visit(IASTDeclSpecifier declspec) {
        IASTName name;
        IASTCompositeTypeSpecifier cts;
        if (declspec instanceof ICPPASTCompositeTypeSpecifier) {
            cts = (ICPPASTCompositeTypeSpecifier)declspec;
            name = this.getLastInQualified(cts.getName());
            this.visit(name, this.fDefinitionName);
            this.push(name, declspec);
        }
        if (declspec instanceof ICASTCompositeTypeSpecifier) {
            cts = (ICASTCompositeTypeSpecifier)declspec;
            name = cts.getName();
            this.visit(name, this.fDefinitionName);
            this.push(name, declspec);
        }
        return 3;
    }

    public int leave(IASTDeclSpecifier declspec) {
        this.pop(declspec);
        return 3;
    }

    public int visit(IASTInitializer initializer) {
        IASTNode cand;
        if (!(this.fDefinitionNode instanceof IASTFunctionDefinition) && (cand = initializer.getParent()) instanceof IASTDeclarator) {
            this.push(((IASTDeclarator)cand).getName(), initializer);
        }
        return 3;
    }

    public int leave(IASTInitializer initializer) {
        this.pop(initializer);
        return 3;
    }
}

