/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class EnvironmentCollector {
    private Map fEnfironmentMap = new HashMap();

    public IEnvironmentVariable addVariable(IEnvironmentVariable var) {
        if (var == null) {
            return null;
        }
        String name = var.getName();
        if ((name = EnvVarOperationProcessor.normalizeName(name)) != null) {
            IEnvironmentVariable old = (IEnvironmentVariable)this.fEnfironmentMap.get(name);
            if (old != null) {
                var = EnvVarOperationProcessor.performOperation(old, var);
            }
            this.fEnfironmentMap.put(name, var);
        }
        return var;
    }

    public void addVariables(IEnvironmentVariable[] vars) {
        if (vars == null) {
            return;
        }
        int i = 0;
        while (i < vars.length) {
            this.addVariable(vars[i]);
            ++i;
        }
    }

    public IEnvironmentVariable getVariable(String name) {
        if ((name = EnvVarOperationProcessor.normalizeName(name)) != null) {
            return (IEnvironmentVariable)this.fEnfironmentMap.get(name);
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables() {
        return this.fEnfironmentMap.values().toArray(new IEnvironmentVariable[this.fEnfironmentMap.size()]);
    }
}

