/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ArtifactTab
extends AbstractCBuildPropertyTab {
    public static final String PROPERTY = "org.eclipse.cdt.build.core.buildArtefactType";
    private Label l4;
    private Text t2;
    private Text t3;
    private Text t4;
    private Combo c1;
    private int savedPos = -1;
    private IConfiguration fCfg;
    private IBuildObjectProperties fProp;
    private IBuildPropertyValue[] values;
    private ITool targetTool;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(this.usercomp, 0);
        l1.setLayoutData((Object)new GridData(1));
        l1.setText(Messages.getString("ArtifactTab.0"));
        this.c1 = new Combo(this.usercomp, 2060);
        this.c1.setLayoutData((Object)new GridData(768));
        this.c1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtifactTab.this.typeChanged();
            }
        });
        Label l2 = new Label(this.usercomp, 0);
        l2.setLayoutData((Object)new GridData(1));
        l2.setText(Messages.getString("ArtifactTab.1"));
        this.t2 = new Text(this.usercomp, 2048);
        this.t2.setLayoutData((Object)new GridData(768));
        this.t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtifactTab.this.fCfg.setArtifactName(ArtifactTab.this.t2.getText());
            }
        });
        Label l3 = new Label(this.usercomp, 0);
        l3.setLayoutData((Object)new GridData(1));
        l3.setText(Messages.getString("ArtifactTab.2"));
        this.t3 = new Text(this.usercomp, 2048);
        this.t3.setLayoutData((Object)new GridData(768));
        this.t3.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtifactTab.this.fCfg.setArtifactExtension(ArtifactTab.this.t3.getText());
            }
        });
        this.l4 = new Label(this.usercomp, 0);
        this.l4.setLayoutData((Object)new GridData(1));
        this.l4.setText(Messages.getString("ArtifactTab.3"));
        this.t4 = new Text(this.usercomp, 2048);
        this.t4.setLayoutData((Object)new GridData(768));
        this.t4.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArtifactTab.this.targetTool != null) {
                    ArtifactTab.this.targetTool.setOutputPrefixForPrimaryOutput(ArtifactTab.this.t4.getText());
                }
            }
        });
        this.updateData(this.getResDesc());
    }

    private void typeChanged() {
        if (this.fProp == null) {
            return;
        }
        int n = this.c1.getSelectionIndex();
        if (n != this.savedPos) {
            this.savedPos = n;
            try {
                this.fProp.setProperty(PROPERTY, this.values[n].getId());
            }
            catch (CoreException ex) {
                ManagedBuilderUIPlugin.log(ex);
            }
            this.updateData(this.getResDesc());
        }
    }

    public void updateData(ICResourceDescription cfgd) {
        String s;
        if (cfgd == null) {
            return;
        }
        this.fCfg = this.getCfg();
        this.fProp = this.fCfg.getBuildProperties();
        this.values = this.fProp.getSupportedValues(PROPERTY);
        this.c1.removeAll();
        this.c1.setData((Object)this.values);
        int i = 0;
        while (i < this.values.length) {
            this.c1.add(this.values[i].getName());
            ++i;
        }
        this.c1.setText("");
        IBuildProperty pr = this.fProp.getProperty(PROPERTY);
        if (pr != null) {
            s = pr.getValue().getId();
            int i2 = 0;
            while (i2 < this.values.length) {
                if (s.equals(this.values[i2].getId())) {
                    this.c1.select(i2);
                    this.savedPos = i2;
                    break;
                }
                ++i2;
            }
        }
        if ((s = this.fCfg.getArtifactName()) == null || s.trim().length() == 0) {
            s = this.getResDesc().getConfiguration().getProjectDescription().getName();
            this.getCfg().setArtifactName(CWizardHandler.removeSpaces((String)s));
        }
        this.t2.setText(s);
        this.t3.setText(this.fCfg.getArtifactExtension());
        this.targetTool = this.fCfg.calculateTargetTool();
        if (this.targetTool != null) {
            if (this.l4 != null) {
                this.l4.setVisible(true);
            }
            if (this.t4 != null) {
                this.t4.setVisible(true);
                this.t4.setText(this.targetTool.getOutputPrefix());
            }
        } else {
            if (this.l4 != null) {
                this.l4.setVisible(false);
            }
            if (this.t4 != null) {
                this.t4.setVisible(false);
            }
        }
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        IConfiguration cfg1 = this.getCfg(src.getConfiguration());
        IConfiguration cfg2 = this.getCfg(dst.getConfiguration());
        cfg2.setArtifactName(cfg1.getArtifactName());
        cfg2.setArtifactExtension(cfg1.getArtifactExtension());
        ITool t1 = cfg1.calculateTargetTool();
        ITool t2 = cfg2.calculateTargetTool();
        if (t1 != null && t2 != null) {
            t2.setOutputPrefixForPrimaryOutput(t1.getOutputPrefix());
        }
        try {
            IBuildPropertyValue bv;
            IBuildProperty bp = cfg1.getBuildProperties().getProperty(PROPERTY);
            if (bp != null && (bv = bp.getValue()) != null) {
                String s = bv.getId();
                cfg2.getBuildProperties().setProperty(PROPERTY, s);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log((Throwable)e);
        }
    }

    public void performDefaults() {
        this.fCfg.setArtifactName(this.fCfg.getManagedProject().getDefaultArtifactName());
        this.fCfg.setArtifactExtension(null);
        if (this.targetTool != null) {
            this.targetTool.setOutputPrefixForPrimaryOutput(null);
        }
        this.updateData(this.getResDesc());
    }

    public boolean canBeVisible() {
        if (this.page.isForProject()) {
            return this.getCfg().getBuilder().isManagedBuildOn();
        }
        return false;
    }

    protected void updateButtons() {
    }
}

