/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIImages;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractCWizard
extends CNewWizard {
    private static final String os = Platform.getOS();
    private static final String arch = Platform.getOSArch();
    private static final String ALL = "all";
    protected static final Image IMG0 = CPluginImages.get((String)"org.eclipse.cdt.ui.cfolder_obj.gif");
    protected static final Image IMG1 = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_CAT);
    protected static final Image IMG2 = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_TOOL);
    protected Composite parent;
    protected IWizardItemsListListener listener;

    public void setDependentControl(Composite _parent, IWizardItemsListListener _listener) {
        this.parent = _parent;
        this.listener = _listener;
    }

    protected boolean isValid(IToolChain tc, boolean supportedOnly, IWizard w) {
        if (!this.isLanguageCompatible(tc, w)) {
            return false;
        }
        if (!supportedOnly) {
            return true;
        }
        if (tc == null || !tc.isSupported() || tc.isAbstract() || tc.isSystemObject()) {
            return false;
        }
        ITargetPlatform tp = tc.getTargetPlatform();
        if (tp != null) {
            List<String> archList;
            List<String> osList = Arrays.asList(tc.getOSList());
            return !(!osList.contains(ALL) && !osList.contains(os) || !(archList = Arrays.asList(tc.getArchList())).contains(ALL) && !archList.contains(arch));
        }
        return true;
    }

    protected boolean isLanguageCompatible(IToolChain tc, IWizard w) {
        if (w == null) {
            return true;
        }
        if (!(w instanceof CDTCommonProjectWizard)) {
            return true;
        }
        ITool[] tools = tc.getTools();
        CDTCommonProjectWizard wz = (CDTCommonProjectWizard)w;
        Object[] langIDs = wz.getLanguageIDs();
        Object[] ctypeIDs = wz.getContentTypeIDs();
        Object[] exts = wz.getExtensions();
        if (this.empty(langIDs) && this.empty(ctypeIDs) && this.empty(exts)) {
            return true;
        }
        int i = 0;
        while (i < tools.length) {
            Object[] its = tools[i].getInputTypes();
            if (this.empty(its)) {
                String[] s;
                if (!this.empty(exts) && this.contains((String[])exts, s = tools[i].getAllInputExtensions())) {
                    return true;
                }
            } else {
                int j = 0;
                while (j < its.length) {
                    String lang;
                    if (!this.empty(langIDs) && this.contains((String[])langIDs, new String[]{lang = its[j].getLanguageId(tools[i])})) {
                        return true;
                    }
                    if (!this.empty(ctypeIDs)) {
                        String[] ct1 = its[j].getSourceContentTypeIds();
                        String[] ct2 = its[j].getHeaderContentTypeIds();
                        if (this.contains((String[])ctypeIDs, ct1) || this.contains((String[])ctypeIDs, ct2)) {
                            return true;
                        }
                    }
                    if (!this.empty(exts)) {
                        String[] ex1 = its[j].getHeaderExtensions(tools[i]);
                        String[] ex2 = its[j].getSourceExtensions(tools[i]);
                        if (this.contains((String[])exts, ex1) || this.contains((String[])exts, ex2)) {
                            return true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean empty(Object[] s) {
        return s == null || s.length == 0;
    }

    private boolean contains(String[] s1, String[] s2) {
        int i = 0;
        while (i < s1.length) {
            int j = 0;
            while (j < s2.length) {
                if (s1[i].equals(s2[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

