/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.COutputEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.IMatchKeyProvider;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedConfigStorageElement;
import org.eclipse.cdt.managedbuilder.internal.core.MapStorageElement;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildBuildData;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IFileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.IReservedMacroNameSupplier;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class Builder
extends BuildObject
implements IBuilder,
IMatchKeyProvider,
IRealBuildObjectAssociation {
    private static final String EMPTY_STRING = "";
    private IBuilder superClass;
    private String superClassId;
    private IToolChain parent;
    private String unusedChildren;
    private String errorParserIds;
    private Boolean isAbstract;
    private String command;
    private String args;
    private IConfigurationElement buildFileGeneratorElement;
    private String versionsSupported;
    private String convertToId;
    private FileContextBuildMacroValues fileContextBuildMacroValues;
    private String builderVariablePattern;
    private Boolean isVariableCaseSensitive;
    private String[] reservedMacroNames;
    private IReservedMacroNameSupplier reservedMacroNameSupplier;
    private IConfigurationElement reservedMacroNameSupplierElement;
    private String autoBuildTarget;
    private Boolean autoBuildEnabled;
    private String incrementalBuildTarget;
    private Boolean incrementalBuildEnabled;
    private String cleanBuildTarget;
    private Boolean cleanBuildEnabled;
    private Boolean managedBuildOn;
    private Boolean keepEnvVarInBuildfile;
    private Boolean supportsManagedBuild;
    private String[] customizedErrorParserIds;
    private HashMap customizedEnvironment;
    private Boolean appendEnvironment;
    private String buildPath;
    private HashMap customBuildProperties;
    private String ignoreErrCmd;
    private String parallelBuildCmd;
    private Boolean stopOnErr;
    private Integer parallelNum;
    private Boolean parallelBuildOn;
    private boolean isTest;
    private boolean isExtensionBuilder = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;
    private BuildBuildData fBuildData;
    private Boolean fSupportsCustomizedBuild;
    private List identicalList;
    private ICOutputEntry[] outputEntries;

    public Builder(IToolChain parent, IManagedConfigElement element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionBuilder = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionBuilder(this);
    }

    public Builder(ToolChain parent, IBuilder superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionBuilder = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionBuilder(this);
        } else {
            this.fBuildData = new BuildBuildData(this);
            this.setDirty(true);
        }
    }

    public Builder(IToolChain parent, ICStorageElement element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionBuilder = false;
        this.fBuildData = new BuildBuildData(this);
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
    }

    public Builder(IToolChain parent, String Id, String name, Builder builder) {
        this.parent = parent;
        this.superClass = builder.superClass;
        if (this.superClass != null && builder.superClassId != null) {
            this.superClassId = new String(builder.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        boolean copyIds = Id.equals(builder.getId());
        this.setManagedBuildRevision(builder.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionBuilder = false;
        if (builder.versionsSupported != null) {
            this.versionsSupported = new String(builder.versionsSupported);
        }
        if (builder.convertToId != null) {
            this.convertToId = new String(builder.convertToId);
        }
        if (builder.unusedChildren != null) {
            this.unusedChildren = new String(builder.unusedChildren);
        }
        if (builder.errorParserIds != null) {
            this.errorParserIds = new String(builder.errorParserIds);
        }
        if (builder.isAbstract != null) {
            this.isAbstract = new Boolean(builder.isAbstract);
        }
        if (builder.command != null) {
            this.command = new String(builder.command);
        }
        if (builder.args != null) {
            this.args = new String(builder.args);
        }
        this.autoBuildTarget = builder.autoBuildTarget;
        this.autoBuildEnabled = builder.autoBuildEnabled;
        this.incrementalBuildTarget = builder.incrementalBuildTarget;
        this.incrementalBuildEnabled = builder.incrementalBuildEnabled;
        this.cleanBuildTarget = builder.cleanBuildTarget;
        this.cleanBuildEnabled = builder.cleanBuildEnabled;
        this.managedBuildOn = builder.managedBuildOn;
        this.keepEnvVarInBuildfile = builder.keepEnvVarInBuildfile;
        this.supportsManagedBuild = builder.supportsManagedBuild;
        if (builder.customizedErrorParserIds != null) {
            this.customizedErrorParserIds = (String[])builder.customizedErrorParserIds.clone();
        }
        if (builder.customizedEnvironment != null) {
            this.customizedEnvironment = (HashMap)builder.customizedEnvironment.clone();
        }
        this.appendEnvironment = builder.appendEnvironment;
        this.buildPath = builder.buildPath;
        if (builder.customBuildProperties != null) {
            this.customBuildProperties = (HashMap)builder.customBuildProperties.clone();
        }
        this.buildFileGeneratorElement = builder.buildFileGeneratorElement;
        if (builder.fileContextBuildMacroValues != null) {
            this.fileContextBuildMacroValues = (FileContextBuildMacroValues)builder.fileContextBuildMacroValues.clone();
            this.fileContextBuildMacroValues.setBuilder(this);
        }
        this.builderVariablePattern = builder.builderVariablePattern;
        if (builder.isVariableCaseSensitive != null) {
            this.isVariableCaseSensitive = new Boolean(builder.isVariableCaseSensitive);
        }
        if (builder.reservedMacroNames != null) {
            this.reservedMacroNames = (String[])builder.reservedMacroNames.clone();
        }
        this.reservedMacroNameSupplierElement = builder.reservedMacroNameSupplierElement;
        this.reservedMacroNameSupplier = builder.reservedMacroNameSupplier;
        this.fBuildData = new BuildBuildData(this);
        this.stopOnErr = builder.stopOnErr;
        this.ignoreErrCmd = builder.ignoreErrCmd;
        this.parallelBuildCmd = builder.parallelBuildCmd;
        this.parallelNum = builder.parallelNum;
        this.parallelBuildOn = builder.parallelBuildOn;
        if (builder.outputEntries != null) {
            this.outputEntries = (ICOutputEntry[])builder.outputEntries.clone();
        }
        if (copyIds) {
            this.isDirty = builder.isDirty;
        } else {
            this.setDirty(true);
        }
    }

    public void copySettings(Builder builder, boolean allBuildSettings) {
        try {
            if (this.isAutoBuildEnable() != builder.isAutoBuildEnable()) {
                this.setAutoBuildEnable(builder.isAutoBuildEnable());
            }
        }
        catch (CoreException coreException) {}
        try {
            if (this.isIncrementalBuildEnabled() != builder.isIncrementalBuildEnabled()) {
                this.setIncrementalBuildEnable(builder.isIncrementalBuildEnabled());
            }
        }
        catch (CoreException coreException) {}
        try {
            if (this.isFullBuildEnabled() != builder.isFullBuildEnabled()) {
                this.setFullBuildEnable(builder.isFullBuildEnabled());
            }
        }
        catch (CoreException coreException) {}
        try {
            if (this.isCleanBuildEnabled() != builder.isCleanBuildEnabled()) {
                this.setCleanBuildEnable(builder.isCleanBuildEnabled());
            }
        }
        catch (CoreException coreException) {}
        if (this.isStopOnError() != builder.isStopOnError() && this.supportsStopOnError(builder.isStopOnError())) {
            try {
                this.setStopOnError(builder.isStopOnError());
            }
            catch (CoreException coreException) {}
        }
        if (this.getParallelizationNum() != builder.getParallelizationNum() && this.supportsParallelBuild()) {
            try {
                this.setParallelizationNum(builder.getParallelizationNum());
            }
            catch (CoreException coreException) {}
        }
        if (this.isParallelBuildOn() != builder.isParallelBuildOn() && this.supportsParallelBuild()) {
            try {
                this.setParallelBuildOn(builder.isParallelBuildOn());
            }
            catch (CoreException coreException) {}
        }
        if (builder.keepEnvironmentVariablesInBuildfile() && this.canKeepEnvironmentVariablesInBuildfile()) {
            this.setKeepEnvironmentVariablesInBuildfile(builder.keepEnvironmentVariablesInBuildfile());
        }
        if (this.isManagedBuildOn() != builder.isManagedBuildOn() && this.supportsBuild(builder.isManagedBuildOn())) {
            try {
                this.setManagedBuildOn(builder.isManagedBuildOn());
            }
            catch (CoreException coreException) {}
        }
        if (builder.customizedErrorParserIds != null) {
            this.customizedErrorParserIds = (String[])builder.customizedErrorParserIds.clone();
        }
        if (builder.customizedEnvironment != null) {
            this.customizedEnvironment = (HashMap)builder.customizedEnvironment.clone();
        }
        this.appendEnvironment = builder.appendEnvironment;
        if (this.isBuildPathEditable() && !this.getBuildPath().equals(builder.getBuildPath())) {
            this.setBuildPath(builder.getBuildPath());
        }
        if (builder.customBuildProperties != null) {
            this.customBuildProperties = (HashMap)builder.customBuildProperties.clone();
        }
        if (allBuildSettings) {
            if (!this.getCommand().equals(builder.getCommand())) {
                this.setCommand(builder.getCommand());
            }
            if (!this.getArgumentsAttribute().equals(builder.getArgumentsAttribute())) {
                this.setArgumentsAttribute(builder.getArgumentsAttribute());
            }
            if (!CDataUtil.objectsEqual((Object)this.getAutoBuildTargetAttribute(), (Object)builder.getAutoBuildTargetAttribute())) {
                this.autoBuildTarget = builder.getAutoBuildTargetAttribute();
            }
            if (!CDataUtil.objectsEqual((Object)this.getIncrementalBuildTargetAttribute(), (Object)builder.getIncrementalBuildTargetAttribute())) {
                this.incrementalBuildTarget = builder.getIncrementalBuildTargetAttribute();
            }
            if (!CDataUtil.objectsEqual((Object)this.getCleanBuildTargetAttribute(), (Object)builder.getCleanBuildTargetAttribute())) {
                this.cleanBuildTarget = builder.getCleanBuildTargetAttribute();
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String isAbs;
        String reservedMacroNameSupplier;
        String reservedNames;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        this.versionsSupported = element.getAttribute("versionsSupported");
        this.convertToId = element.getAttribute("convertToId");
        this.builderVariablePattern = element.getAttribute("variableFormat");
        String isCS = element.getAttribute("isVariableCaseSensitive");
        if (isCS != null) {
            this.isVariableCaseSensitive = new Boolean("true".equals(isCS));
        }
        if ((reservedNames = element.getAttribute("reservedMacroNames")) != null) {
            this.reservedMacroNames = reservedNames.split(",");
        }
        if ((reservedMacroNameSupplier = element.getAttribute("reservedMacroNameSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.reservedMacroNameSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.command = element.getAttribute("command");
        this.args = element.getAttribute("arguments");
        this.autoBuildTarget = element.getAttribute("autoBuildTarget");
        String tmp = element.getAttribute("enableAutoBuild");
        if (tmp != null) {
            this.autoBuildEnabled = Boolean.valueOf(tmp);
        }
        this.incrementalBuildTarget = element.getAttribute("incrementalBuildTarget");
        tmp = element.getAttribute("enableAutoBuild");
        if (tmp != null) {
            this.incrementalBuildEnabled = Boolean.valueOf(tmp);
        }
        this.cleanBuildTarget = element.getAttribute("cleanBuildTarget");
        tmp = element.getAttribute("enableCleanBuild");
        if (tmp != null) {
            this.cleanBuildEnabled = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("managedBuildOn")) != null) {
            this.managedBuildOn = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("keepEnvironmentInBuildfile")) != null) {
            this.keepEnvVarInBuildfile = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("supportsManagedBuild")) != null) {
            this.supportsManagedBuild = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("customizedErrorParsers")) != null) {
            this.customizedErrorParserIds = CDataUtil.stringToArray((String)tmp, (String)";");
        }
        if ((tmp = element.getAttribute("environment")) != null) {
            this.customizedEnvironment = (HashMap)MapStorageElement.decodeMap(tmp);
        }
        if ((tmp = element.getAttribute("appendEnvironment")) != null) {
            this.appendEnvironment = Boolean.valueOf(tmp);
        }
        this.buildPath = element.getAttribute("buildPath");
        tmp = element.getAttribute("customBuilderProperties");
        if (tmp != null) {
            this.customBuildProperties = (HashMap)MapStorageElement.decodeMap(tmp);
        }
        this.ignoreErrCmd = element.getAttribute("ignoreErrCmd");
        tmp = element.getAttribute("stopOnErr");
        if (tmp != null) {
            this.stopOnErr = Boolean.valueOf(tmp);
        }
        this.parallelBuildCmd = element.getAttribute("parallelBuildCmd");
        tmp = element.getAttribute("parallelizationNumber");
        if (tmp != null) {
            try {
                this.parallelNum = Integer.decode(tmp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((tmp = element.getAttribute("parallelBuildOn")) != null) {
            this.parallelBuildOn = Boolean.valueOf(tmp);
        }
        this.errorParserIds = element.getAttribute("errorParsers");
        String buildfileGenerator = element.getAttribute("buildfileGenerator");
        if (buildfileGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.buildFileGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.fileContextBuildMacroValues = new FileContextBuildMacroValues(this, element);
        tmp = element.getAttribute("isSystem");
        if (tmp != null) {
            this.isTest = Boolean.valueOf(tmp);
        }
        IManagedConfigElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IManagedConfigElement child = children[i];
            String name = child.getName();
            if ("outputEntries".equals(name)) {
                ICSettingEntry[] entries = LanguageSettingEntriesSerializer.loadEntries((ICStorageElement)new ManagedConfigStorageElement(child));
                if (entries.length == 0) {
                    this.outputEntries = new ICOutputEntry[0];
                } else {
                    ArrayList<ICSettingEntry> list = new ArrayList<ICSettingEntry>(entries.length);
                    int k = 0;
                    while (k < entries.length) {
                        if (entries[k].getKind() == 64) {
                            list.add(entries[k]);
                        }
                        ++k;
                    }
                    this.outputEntries = list.toArray(new ICOutputEntry[list.size()]);
                }
            }
            ++i;
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String tmp;
        String isAbs;
        if (element.getAttribute("id") != null) {
            this.setId(element.getAttribute("id"));
        }
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        this.setVersion(this.getVersionFromId());
        if (element.getAttribute("superClass") != null) {
            this.superClassId = element.getAttribute("superClass");
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
                this.checkForMigrationSupport();
            }
        }
        if (element.getAttribute("versionsSupported") != null) {
            this.versionsSupported = element.getAttribute("versionsSupported");
        }
        if (element.getAttribute("convertToId") != null) {
            this.convertToId = element.getAttribute("convertToId");
        }
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.getAttribute("command") != null) {
            this.command = element.getAttribute("command");
        }
        if (element.getAttribute("arguments") != null) {
            this.args = element.getAttribute("arguments");
        }
        if (element.getAttribute("autoBuildTarget") != null) {
            this.autoBuildTarget = element.getAttribute("autoBuildTarget");
        }
        if ((tmp = element.getAttribute("enableAutoBuild")) != null) {
            this.autoBuildEnabled = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("incrementalBuildTarget") != null) {
            this.incrementalBuildTarget = element.getAttribute("incrementalBuildTarget");
        }
        if ((tmp = element.getAttribute("enabledIncrementalBuild")) != null) {
            this.incrementalBuildEnabled = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("cleanBuildTarget") != null) {
            this.cleanBuildTarget = element.getAttribute("cleanBuildTarget");
        }
        if ((tmp = element.getAttribute("enableCleanBuild")) != null) {
            this.cleanBuildEnabled = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("managedBuildOn")) != null) {
            this.managedBuildOn = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("keepEnvironmentInBuildfile")) != null) {
            this.keepEnvVarInBuildfile = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("supportsManagedBuild")) != null) {
            this.supportsManagedBuild = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("customizedErrorParsers")) != null) {
            this.customizedErrorParserIds = CDataUtil.stringToArray((String)tmp, (String)";");
        }
        if ((tmp = element.getAttribute("environment")) != null) {
            this.customizedEnvironment = (HashMap)MapStorageElement.decodeMap(tmp);
        }
        if ((tmp = element.getAttribute("appendEnvironment")) != null) {
            this.appendEnvironment = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("buildPath") != null) {
            this.buildPath = element.getAttribute("buildPath");
        }
        if ((tmp = element.getAttribute("customBuilderProperties")) != null) {
            this.customBuildProperties = (HashMap)MapStorageElement.decodeMap(tmp);
        }
        if (element.getAttribute("errorParsers") != null) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        element.getAttribute("buildfileGenerator");
        if (element.getAttribute("ignoreErrCmd") != null) {
            this.ignoreErrCmd = element.getAttribute("ignoreErrCmd");
        }
        if ((tmp = element.getAttribute("stopOnErr")) != null) {
            this.stopOnErr = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("parallelBuildCmd") != null) {
            this.parallelBuildCmd = element.getAttribute("parallelBuildCmd");
        }
        if ((tmp = element.getAttribute("parallelizationNumber")) != null) {
            try {
                this.parallelNum = Integer.decode(tmp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((tmp = element.getAttribute("parallelBuildOn")) != null) {
            this.parallelBuildOn = Boolean.valueOf(tmp);
        }
        ICStorageElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String name = child.getName();
            if ("outputEntries".equals(name)) {
                ICSettingEntry[] entries = LanguageSettingEntriesSerializer.loadEntries((ICStorageElement)child);
                if (entries.length == 0) {
                    this.outputEntries = new ICOutputEntry[0];
                } else {
                    ArrayList<ICSettingEntry> list = new ArrayList<ICSettingEntry>(entries.length);
                    int k = 0;
                    while (k < entries.length) {
                        if (entries[k].getKind() == 64) {
                            list.add(entries[k]);
                        }
                        ++k;
                    }
                    this.outputEntries = list.toArray(new ICOutputEntry[list.size()]);
                }
            }
            ++i;
        }
    }

    public void serialize(ICStorageElement element) {
        this.serialize(element, true);
    }

    public void serialize(ICStorageElement element, boolean resetDirtyState) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.versionsSupported != null) {
            element.setAttribute("versionsSupported", this.versionsSupported);
        }
        if (this.convertToId != null) {
            element.setAttribute("convertToId", this.convertToId);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.args != null) {
            element.setAttribute("arguments", this.args);
        }
        if (this.autoBuildTarget != null) {
            element.setAttribute("autoBuildTarget", this.autoBuildTarget);
        }
        if (this.autoBuildEnabled != null) {
            element.setAttribute("enableAutoBuild", this.autoBuildEnabled.toString());
        }
        if (this.incrementalBuildTarget != null) {
            element.setAttribute("incrementalBuildTarget", this.incrementalBuildTarget);
        }
        if (this.incrementalBuildEnabled != null) {
            element.setAttribute("enabledIncrementalBuild", this.incrementalBuildEnabled.toString());
        }
        if (this.cleanBuildTarget != null) {
            element.setAttribute("cleanBuildTarget", this.cleanBuildTarget);
        }
        if (this.cleanBuildEnabled != null) {
            element.setAttribute("enableCleanBuild", this.cleanBuildEnabled.toString());
        }
        if (this.managedBuildOn != null) {
            element.setAttribute("managedBuildOn", this.managedBuildOn.toString());
        }
        if (this.keepEnvVarInBuildfile != null) {
            element.setAttribute("keepEnvironmentInBuildfile", this.keepEnvVarInBuildfile.toString());
        }
        if (this.supportsManagedBuild != null) {
            element.setAttribute("supportsManagedBuild", this.supportsManagedBuild.toString());
        }
        if (this.customizedErrorParserIds != null) {
            element.setAttribute("customizedErrorParsers", CDataUtil.arrayToString((String[])this.customizedErrorParserIds, (String)";"));
        }
        if (this.customizedEnvironment != null) {
            element.setAttribute("environment", MapStorageElement.encodeMap(this.customizedEnvironment));
        }
        if (this.appendEnvironment != null) {
            element.setAttribute("appendEnvironment", this.appendEnvironment.toString());
        }
        if (this.buildPath != null) {
            element.setAttribute("buildPath", this.buildPath);
        }
        if (this.customBuildProperties != null) {
            element.setAttribute("customBuilderProperties", MapStorageElement.encodeMap(this.customBuildProperties));
        }
        if (this.ignoreErrCmd != null) {
            element.setAttribute("ignoreErrCmd", this.ignoreErrCmd);
        }
        if (this.stopOnErr != null) {
            element.setAttribute("stopOnErr", this.stopOnErr.toString());
        }
        if (this.parallelBuildCmd != null) {
            element.setAttribute("parallelBuildCmd", this.parallelBuildCmd);
        }
        if (this.parallelNum != null) {
            element.setAttribute("parallelizationNumber", this.parallelNum.toString());
        }
        if (this.parallelBuildOn != null) {
            element.setAttribute("parallelBuildOn", this.parallelBuildOn.toString());
        }
        if (this.outputEntries != null) {
            ICStorageElement outEl = element.createChild("outputEntries");
            LanguageSettingEntriesSerializer.serializeEntries((ICSettingEntry[])this.outputEntries, (ICStorageElement)outEl);
        }
        if (resetDirtyState) {
            this.isDirty = false;
        }
    }

    public void serializeRawData(ICStorageElement element) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.getName() != null) {
            element.setAttribute("name", this.getName());
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.versionsSupported != null) {
            element.setAttribute("versionsSupported", this.versionsSupported);
        }
        if (this.convertToId != null) {
            element.setAttribute("convertToId", this.convertToId);
        }
        if (this.getErrorParserIds() != null) {
            element.setAttribute("errorParsers", this.getErrorParserIds());
        }
        if (this.getCommand() != null) {
            element.setAttribute("command", this.getCommand());
        }
        if (this.getArgumentsAttribute() != null) {
            element.setAttribute("arguments", this.getArguments());
        }
        if (this.getAutoBuildTargetAttribute() != null) {
            element.setAttribute("autoBuildTarget", this.getAutoBuildTargetAttribute());
        }
        element.setAttribute("enableAutoBuild", Boolean.valueOf(this.isAutoBuildEnable()).toString());
        if (this.getIncrementalBuildTargetAttribute() != null) {
            element.setAttribute("incrementalBuildTarget", this.getIncrementalBuildTargetAttribute());
        }
        element.setAttribute("enabledIncrementalBuild", Boolean.valueOf(this.isIncrementalBuildEnabled()).toString());
        if (this.getCleanBuildTargetAttribute() != null) {
            element.setAttribute("cleanBuildTarget", this.getCleanBuildTargetAttribute());
        }
        element.setAttribute("enableCleanBuild", Boolean.valueOf(this.isCleanBuildEnabled()).toString());
        element.setAttribute("managedBuildOn", Boolean.valueOf(this.isManagedBuildOn()).toString());
        element.setAttribute("keepEnvironmentInBuildfile", Boolean.valueOf(this.keepEnvironmentVariablesInBuildfile()).toString());
        element.setAttribute("supportsManagedBuild", Boolean.valueOf(this.supportsBuild(true)).toString());
        if (this.customizedErrorParserIds != null) {
            element.setAttribute("customizedErrorParsers", CDataUtil.arrayToString((String[])this.customizedErrorParserIds, (String)";"));
        }
        if (this.customizedEnvironment != null) {
            element.setAttribute("environment", MapStorageElement.encodeMap(this.customizedEnvironment));
        }
        element.setAttribute("appendEnvironment", Boolean.valueOf(this.appendEnvironment()).toString());
        if (this.getBuildPathAttribute() != null) {
            element.setAttribute("buildPath", this.getBuildPathAttribute());
        }
        if (this.customBuildProperties != null) {
            element.setAttribute("customBuilderProperties", MapStorageElement.encodeMap(this.customBuildProperties));
        }
        if (this.getIgnoreErrCmdAttribute() != null) {
            element.setAttribute("ignoreErrCmd", this.getIgnoreErrCmdAttribute());
        }
        element.setAttribute("stopOnErr", Boolean.valueOf(this.isStopOnError()).toString());
        if (this.getParrallelBuildCmd() != null) {
            element.setAttribute("parallelBuildCmd", this.getParrallelBuildCmd());
        }
        element.setAttribute("parallelizationNumber", new Integer(this.getParallelizationNumAttribute()).toString());
        element.setAttribute("parallelBuildOn", Boolean.valueOf(this.isParallelBuildOn()).toString());
        if (this.outputEntries != null) {
            ICStorageElement outEl = element.createChild("outputEntries");
            LanguageSettingEntriesSerializer.serializeEntries((ICSettingEntry[])this.outputEntries, (ICStorageElement)outEl);
        }
    }

    public IToolChain getParent() {
        return this.parent;
    }

    public IBuilder getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand();
            }
            return "make";
        }
        return this.command;
    }

    public String getArguments() {
        String args = this.getArgumentsAttribute();
        String stopOnErrCmd = this.getStopOnErrCmd(this.isStopOnError());
        String parallelBuildCmd = this.isParallelBuildOn() ? this.getParallelizationCmd(this.getParallelizationNum()) : EMPTY_STRING;
        String reversedStopOnErrCmd = this.getStopOnErrCmd(!this.isStopOnError());
        String reversedParallelBuildCmd = !this.isParallelBuildOn() ? this.getParallelizationCmd(this.getParallelizationNum()) : EMPTY_STRING;
        args = this.removeCmd(args, reversedStopOnErrCmd);
        args = this.removeCmd(args, reversedParallelBuildCmd);
        args = this.addCmd(args, stopOnErrCmd);
        args = this.addCmd(args, parallelBuildCmd);
        return args != null ? args.trim() : null;
    }

    private String addCmd(String args, String cmd) {
        if (this.getCmdIndex(args, cmd) == -1) {
            if (args.length() != 0) {
                args = String.valueOf(args) + ' ';
            }
            args = String.valueOf(args) + cmd;
        }
        return args;
    }

    private String removeCmd(String args, String cmd) {
        int index = this.getCmdIndex(args, cmd);
        if (index != -1) {
            String prefix = args.substring(0, index).trim();
            String suffix = args.substring(index + cmd.length(), args.length()).trim();
            args = prefix.length() == 0 ? suffix : (suffix.length() == 0 ? prefix : String.valueOf(prefix) + ' ' + suffix);
            args = args.trim();
        }
        return args;
    }

    private int getCmdIndex(String args, String cmd) {
        if (cmd.length() == 0) {
            return -1;
        }
        String tmp = args;
        int index = -1;
        index = tmp.indexOf(cmd);
        while (index != -1) {
            char c;
            int end;
            char c2;
            if ((index == 0 || (c2 = tmp.charAt(index - 1)) == '\t' || c2 == ' ') && ((end = index + cmd.length()) >= tmp.length() || (c = tmp.charAt(end)) == '\t' || c == ' ')) break;
            index = tmp.indexOf(cmd, index + 1);
        }
        return index;
    }

    public String getParallelizationCmd(int num) {
        String pattern = this.getParrallelBuildCmd();
        if (pattern.length() == 0) {
            return EMPTY_STRING;
        }
        if (num == 0) {
            return EMPTY_STRING;
        }
        return this.processParallelPattern(pattern, num < 0, num);
    }

    private String processParallelPattern(String pattern, boolean empty, int num) {
        String result;
        int start = pattern.indexOf("[");
        int end = -1;
        boolean hasStartChar = false;
        if (start != -1) {
            end = pattern.indexOf("]");
            if (end != -1) {
                hasStartChar = true;
            } else {
                start = -1;
            }
        }
        if (start == -1 && (start = pattern.indexOf("*")) != -1) {
            end = start + "*".length();
        }
        if (start == -1) {
            result = pattern;
        } else {
            String prefix = pattern.substring(0, start);
            String suffix = pattern.substring(end);
            String numStr = pattern.substring(start, end);
            if (empty) {
                result = String.valueOf(prefix) + suffix;
            } else {
                String resolvedNum;
                if (hasStartChar) {
                    numStr = numStr.substring(0, "[".length());
                    numStr = numStr.substring(numStr.length() - "]".length());
                    int numStart = pattern.indexOf("*");
                    if (numStart != -1) {
                        int numEnd = numStart + "*".length();
                        String numPrefix = numStr.substring(0, numStart);
                        String numSuffix = numStr.substring(numEnd);
                        resolvedNum = String.valueOf(numPrefix) + new Integer(num).toString() + numSuffix;
                    } else {
                        resolvedNum = EMPTY_STRING;
                    }
                } else {
                    resolvedNum = new Integer(num).toString();
                }
                result = String.valueOf(prefix) + resolvedNum + suffix;
            }
        }
        return result;
    }

    public String getArgumentsAttribute() {
        if (this.args == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getArgumentsAttribute();
            }
            return EMPTY_STRING;
        }
        return this.args;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.superClass.getErrorParserIds();
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String parserIDs = this.getErrorParserIds();
        String[] errorParsers = null;
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{EMPTY_STRING};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public void setCommand(String cmd) {
        if (this.getCommand().equals(cmd)) {
            return;
        }
        if (cmd == null && this.command == null) {
            return;
        }
        if (this.command == null || cmd == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.setDirty(true);
        }
    }

    public void setArguments(String newArgs) {
        if (this.getArguments().equals(newArgs)) {
            return;
        }
        if (newArgs != null) {
            String stopOnErrCmd = this.getStopOnErrCmd(this.isStopOnError());
            String parallelBuildCmd = this.isParallelBuildOn() ? this.getParallelizationCmd(this.getParallelizationNum()) : EMPTY_STRING;
            newArgs = this.removeCmd(newArgs, stopOnErrCmd);
            newArgs = this.removeCmd(newArgs, parallelBuildCmd);
        }
        this.setArgumentsAttribute(newArgs);
    }

    public void setArgumentsAttribute(String newArgs) {
        if (newArgs == null && this.args == null) {
            return;
        }
        if (this.args == null || newArgs == null || !newArgs.equals(this.args)) {
            this.args = newArgs;
            this.setDirty(true);
        }
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public IConfigurationElement getBuildFileGeneratorElement() {
        if (this.buildFileGeneratorElement == null && this.superClass != null) {
            return ((Builder)this.superClass).getBuildFileGeneratorElement();
        }
        return this.buildFileGeneratorElement;
    }

    public IManagedBuilderMakefileGenerator getBuildFileGenerator() {
        IConfigurationElement element = this.getBuildFileGeneratorElement();
        if (element != null) {
            try {
                if (element.getName().equalsIgnoreCase("target")) {
                    if (element.getAttribute("makefileGenerator") != null) {
                        return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("makefileGenerator");
                    }
                } else if (element.getAttribute("buildfileGenerator") != null) {
                    return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("buildfileGenerator");
                }
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
        }
        return new GnuMakefileGenerator();
    }

    public void setBuildFileGeneratorElement(IConfigurationElement element) {
        this.buildFileGeneratorElement = element;
        this.setDirty(true);
    }

    public boolean isExtensionElement() {
        return this.isExtensionBuilder;
    }

    public boolean isDirty() {
        if (this.isExtensionBuilder) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "builder", this.getId());
                }
            }
        }
    }

    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.superClass != null) {
                return this.superClass.getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.superClass != null) {
                return this.superClass.getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    public IFileContextBuildMacroValues getFileContextBuildMacroValues() {
        if (this.fileContextBuildMacroValues == null && this.superClass != null) {
            return this.superClass.getFileContextBuildMacroValues();
        }
        return this.fileContextBuildMacroValues;
    }

    public String getBuilderVariablePattern() {
        if (this.builderVariablePattern == null && this.superClass != null) {
            return this.superClass.getBuilderVariablePattern();
        }
        return this.builderVariablePattern;
    }

    public boolean isVariableCaseSensitive() {
        if (this.isVariableCaseSensitive == null) {
            if (this.superClass != null) {
                return this.superClass.isVariableCaseSensitive();
            }
            return true;
        }
        return this.isVariableCaseSensitive;
    }

    public String[] getReservedMacroNames() {
        if (this.reservedMacroNames == null && this.superClass != null) {
            return this.superClass.getReservedMacroNames();
        }
        return this.reservedMacroNames;
    }

    public IReservedMacroNameSupplier getReservedMacroNameSupplier() {
        if (this.reservedMacroNameSupplier == null && this.reservedMacroNameSupplierElement != null) {
            try {
                this.reservedMacroNameSupplier = (IReservedMacroNameSupplier)this.reservedMacroNameSupplierElement.createExecutableExtension("reservedMacroNameSupplier");
            }
            catch (CoreException coreException) {}
        }
        if (this.reservedMacroNameSupplier == null && this.superClass != null) {
            return this.superClass.getReservedMacroNameSupplier();
        }
        return this.reservedMacroNameSupplier;
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = (String)ManagedBuildManager.getExtensionBuilderMap().lastKey();
            SortedMap subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IToolChain parent = this.getParent();
                IConfiguration parentConfig = parent.getParent();
                IManagedProject managedProject = parentConfig.getManagedProject();
                if (managedProject != null) {
                    managedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionBuilderMap().subMap(this.superClassId, String.valueOf(high) + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.superClassId);
            Collection c = subMap.values();
            IBuilder[] builderElements = c.toArray(new IBuilder[c.size()]);
            int i = 0;
            while (i < builderElements.length) {
                String versionsSupported;
                IBuilder builderElement = builderElements[i];
                if (ManagedBuildManager.getIdFromIdAndVersion(builderElement.getId()).compareTo(baseId) > 0) break;
                if (ManagedBuildManager.getIdFromIdAndVersion(builderElement.getId()).equals(baseId) && (versionsSupported = builderElement.getVersionsSupported()) != null && !versionsSupported.equals(EMPTY_STRING)) {
                    String[] tmpVersions = versionsSupported.split(",");
                    int j = 0;
                    while (j < tmpVersions.length) {
                        if (new PluginVersionIdentifier(version).equals((Object)new PluginVersionIdentifier(tmpVersions[j]))) {
                            String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(builderElement.getId());
                            this.setId(String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(this.getId())) + "_" + supportedVersion);
                            this.superClass = builderElement;
                            this.superClassId = this.superClass.getId();
                            isExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (isExists) break;
                }
                ++i;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.equals(EMPTY_STRING)) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IToolChain parent = this.getParent();
            IConfiguration parentConfig = parent.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IToolChain parent;
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            PluginVersionIdentifier currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.isGreaterThan(new PluginVersionIdentifier(mbsVersion))) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((managedProject = (parentConfig = (parent = this.getParent()).getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    public CBuildData getBuildData() {
        return this.fBuildData;
    }

    public String[] getErrorParsers() {
        if (this.isCustomBuilder() && this.customizedErrorParserIds != null) {
            return (String[])this.customizedErrorParserIds.clone();
        }
        IToolChain parent = this.getParent();
        IConfiguration parentConfig = parent.getParent();
        return parentConfig.getErrorParserList();
    }

    public String[] getCustomizedErrorParserIds() {
        if (this.customizedErrorParserIds != null) {
            return (String[])this.customizedErrorParserIds.clone();
        }
        return null;
    }

    public void setCustomizedErrorParserIds(String[] ids) {
        this.customizedErrorParserIds = ids != null ? (String[])ids.clone() : ids;
    }

    public void setErrorParsers(String[] parsers) throws CoreException {
        if (this.isCustomBuilder()) {
            this.customizedErrorParserIds = parsers != null && parsers.length != 0 ? (String[])parsers.clone() : parsers;
        } else {
            IToolChain parent = this.getParent();
            IConfiguration parentConfig = parent.getParent();
            parentConfig.setErrorParserList(parsers);
        }
    }

    private Object getMacroContextData() {
        return this;
    }

    public String getBuildArguments() {
        String args = this.getArguments();
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        try {
            args = provider.resolveValue(args, EMPTY_STRING, " ", 3, this.getMacroContextData());
        }
        catch (BuildMacroException buildMacroException) {}
        return args;
    }

    public IPath getBuildCommand() {
        String command = this.getCommand();
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        try {
            command = provider.resolveValue(command, EMPTY_STRING, " ", 3, this.getMacroContextData());
        }
        catch (BuildMacroException buildMacroException) {}
        return new Path(command);
    }

    public String getBuildPathAttribute() {
        return this.getBuildPathAttribute(true);
    }

    public String getBuildPathAttribute(boolean querySuperClass) {
        if (this.buildPath == null && querySuperClass && this.superClass != null) {
            return ((Builder)this.superClass).getBuildPathAttribute(true);
        }
        return this.buildPath;
    }

    public void setBuildPath(String path) {
        this.setBuildPathAttribute(path);
    }

    public void setBuildPathAttribute(String path) {
        this.buildPath = path;
        this.setDirty(true);
    }

    public String getBuildPath() {
        if (this.isManagedBuildOn()) {
            return this.getDefaultBuildPath();
        }
        String path = this.getBuildPathAttribute();
        if (path == null) {
            path = this.getDefaultBuildPath();
        }
        return path;
    }

    private boolean isBuildPathEditable() {
        return !this.isManagedBuildOn();
    }

    public String getDefaultBuildPath() {
        String result;
        Configuration cfg = (Configuration)this.getConfguration();
        if (cfg != null) {
            if (!this.isExtensionElement() && !cfg.isPreference()) {
                Path buildPath;
                IProject project = cfg.getOwner().getProject();
                if (this.isManagedBuildOn()) {
                    IManagedBuilderMakefileGenerator gen = this.getBuildFileGenerator();
                    if (gen instanceof IManagedBuilderMakefileGenerator2) {
                        ((IManagedBuilderMakefileGenerator2)gen).initialize(6, cfg, this, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        gen.initialize(project, ManagedBuildManager.getBuildInfo((IResource)project), (IProgressMonitor)new NullProgressMonitor());
                    }
                    buildPath = gen.getBuildWorkingDir();
                    if (buildPath == null) {
                        buildPath = new Path(cfg.getName());
                    }
                } else {
                    buildPath = Path.EMPTY;
                }
                if (!buildPath.isAbsolute()) {
                    buildPath = project.getFullPath().append((IPath)buildPath);
                    IStringVariableManager mngr = VariablesPlugin.getDefault().getStringVariableManager();
                    result = buildPath.toString();
                    result = mngr.generateVariableExpression("workspace_loc", result);
                } else {
                    result = buildPath.toString();
                }
            } else if (this.isManagedBuildOn()) {
                result = cfg.getName();
                if (result == null) {
                    result = EMPTY_STRING;
                }
            } else {
                result = EMPTY_STRING;
            }
        } else {
            result = EMPTY_STRING;
        }
        return result;
    }

    public IPath getBuildLocation() {
        String path = this.getBuildPath();
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        try {
            path = provider.resolveValue(path, EMPTY_STRING, " ", 3, this.getMacroContextData());
        }
        catch (BuildMacroException buildMacroException) {}
        return new Path(path);
    }

    public boolean isDefaultBuildCmd() {
        return this.isExtensionBuilder || this.command == null && this.args == null && this.superClass != null;
    }

    public boolean isStopOnError() {
        if (this.stopOnErr == null) {
            if (this.superClass != null) {
                return this.superClass.isStopOnError();
            }
            return true;
        }
        return this.stopOnErr;
    }

    public void setBuildArguments(String args) throws CoreException {
        this.setArguments(args);
    }

    public void setBuildCommand(IPath command) throws CoreException {
        String cmd = command != null ? command.toString() : null;
        this.setCommand(cmd);
    }

    public void setBuildLocation(IPath location) throws CoreException {
        String path = location != null ? location.toString() : null;
        this.setBuildPath(path);
    }

    public void setStopOnError(boolean on) throws CoreException {
        if (this.isStopOnError() == on) {
            return;
        }
        if (this.supportsStopOnError(on)) {
            String curCmd = this.getStopOnErrCmd(this.isStopOnError());
            String args = this.getArgumentsAttribute();
            String updatedArgs = this.removeCmd(args, curCmd);
            if (!updatedArgs.equals(args)) {
                this.setArgumentsAttribute(updatedArgs);
            }
            this.stopOnErr = on;
        }
        this.setDirty(true);
    }

    public void setUseDefaultBuildCmd(boolean on) throws CoreException {
        if (!this.isExtensionBuilder && this.superClass != null) {
            if (on) {
                this.command = null;
                this.args = null;
            } else {
                this.command = this.getCommand();
            }
        }
    }

    public String getAutoBuildTargetAttribute() {
        if (this.autoBuildTarget == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getAutoBuildTargetAttribute();
            }
            return null;
        }
        return this.autoBuildTarget;
    }

    public String getAutoBuildTarget() {
        String attr = this.getAutoBuildTargetAttribute();
        if (attr != null) {
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            try {
                attr = provider.resolveValue(attr, EMPTY_STRING, " ", 3, this.getMacroContextData());
            }
            catch (BuildMacroException buildMacroException) {}
        }
        if (attr == null) {
            attr = "all";
        }
        return attr;
    }

    public String getCleanBuildTargetAttribute() {
        if (this.cleanBuildTarget == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getCleanBuildTargetAttribute();
            }
            return null;
        }
        return this.cleanBuildTarget;
    }

    public String getCleanBuildTarget() {
        String attr = this.getCleanBuildTargetAttribute();
        if (attr != null) {
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            try {
                attr = provider.resolveValue(attr, EMPTY_STRING, " ", 3, this.getMacroContextData());
            }
            catch (BuildMacroException buildMacroException) {}
        }
        if (attr == null) {
            attr = "clean";
        }
        return attr;
    }

    public String getFullBuildTarget() {
        return this.getIncrementalBuildTarget();
    }

    public String getIncrementalBuildTargetAttribute() {
        if (this.incrementalBuildTarget == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getIncrementalBuildTargetAttribute();
            }
            return null;
        }
        return this.incrementalBuildTarget;
    }

    public String getIncrementalBuildTarget() {
        String attr = this.getIncrementalBuildTargetAttribute();
        if (attr != null) {
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            try {
                attr = provider.resolveValue(attr, EMPTY_STRING, " ", 3, this.getMacroContextData());
            }
            catch (BuildMacroException buildMacroException) {}
        }
        if (attr == null) {
            attr = "all";
        }
        return attr;
    }

    public boolean isAutoBuildEnable() {
        if (this.autoBuildEnabled == null) {
            if (this.superClass != null) {
                return this.superClass.isAutoBuildEnable();
            }
            return false;
        }
        return this.autoBuildEnabled;
    }

    public boolean isCleanBuildEnabled() {
        if (this.cleanBuildEnabled == null) {
            if (this.superClass != null) {
                return this.superClass.isCleanBuildEnabled();
            }
            return true;
        }
        return this.cleanBuildEnabled;
    }

    public boolean isFullBuildEnabled() {
        return this.isIncrementalBuildEnabled();
    }

    public boolean isIncrementalBuildEnabled() {
        if (this.incrementalBuildEnabled == null) {
            if (this.superClass != null) {
                return this.superClass.isIncrementalBuildEnabled();
            }
            return true;
        }
        return this.incrementalBuildEnabled;
    }

    public void setAutoBuildEnable(boolean enabled) throws CoreException {
        this.autoBuildEnabled = enabled;
    }

    public void setAutoBuildTarget(String target) throws CoreException {
        this.autoBuildTarget = target;
    }

    public void setCleanBuildEnable(boolean enabled) throws CoreException {
        this.cleanBuildEnabled = enabled;
    }

    public void setCleanBuildTarget(String target) throws CoreException {
        this.cleanBuildTarget = target;
    }

    public void setFullBuildEnable(boolean enabled) throws CoreException {
        this.setIncrementalBuildEnable(enabled);
    }

    public void setFullBuildTarget(String target) throws CoreException {
        this.setIncrementalBuildTarget(target);
    }

    public void setIncrementalBuildEnable(boolean enabled) throws CoreException {
        this.incrementalBuildEnabled = enabled;
    }

    public void setIncrementalBuildTarget(String target) throws CoreException {
        this.incrementalBuildTarget = target;
    }

    public boolean appendEnvironment() {
        if (this.appendEnvironment == null) {
            if (this.superClass != null) {
                return this.superClass.appendEnvironment();
            }
            return true;
        }
        return this.appendEnvironment;
    }

    public String getBuildAttribute(String name, String defaultValue) {
        String result = null;
        if ("org.eclipse.cdt.make.core.build.target.inc".equals(name)) {
            result = this.getIncrementalBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.build.target.auto".equals(name)) {
            result = this.getAutoBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.build.target.clean".equals(name)) {
            result = this.getCleanBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.build.location".equals(name)) {
            result = this.getBuildPathAttribute();
        } else if ("org.eclipse.cdt.make.core.build.command".equals(name)) {
            result = this.getCommand();
        } else if ("org.eclipse.cdt.make.core.build.arguments".equals(name)) {
            result = this.getArguments();
        } else if ("org.eclipse.cdt.make.core.buildCommand".equals(name)) {
            result = this.getCommand();
        } else if ("org.eclipse.cdt.make.core.buildLocation".equals(name)) {
            result = this.getBuildPathAttribute();
        } else if ("org.eclipse.cdt.make.core.stopOnError".equals(name)) {
            result = Boolean.valueOf(this.isStopOnError()).toString();
        } else if ("org.eclipse.cdt.make.core.useDefaultBuildCmd".equals(name)) {
            result = Boolean.valueOf(this.isDefaultBuildCmd()).toString();
        } else if ("org.eclipse.cdt.make.core.autoBuildTarget".equals(name)) {
            result = this.getAutoBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.incrementalBuildTarget".equals(name)) {
            result = this.getIncrementalBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.fullBuildTarget".equals(name)) {
            result = this.getIncrementalBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.cleanBuildTarget".equals(name)) {
            result = this.getCleanBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.enableFullBuild".equals(name)) {
            result = Boolean.valueOf(this.isFullBuildEnabled()).toString();
        } else if ("org.eclipse.cdt.make.core.enableCleanBuild".equals(name)) {
            result = Boolean.valueOf(this.isCleanBuildEnabled()).toString();
        } else if ("org.eclipse.cdt.make.core.enabledIncrementalBuild".equals(name)) {
            result = Boolean.valueOf(this.isIncrementalBuildEnabled()).toString();
        } else if ("org.eclipse.cdt.make.core.enableAutoBuild".equals(name)) {
            result = Boolean.valueOf(this.isAutoBuildEnable()).toString();
        } else if ("org.eclipse.cdt.make.core.buildArguments".equals(name)) {
            result = this.getArguments();
        } else if ("org.eclipse.cdt.make.core.environment".equals(name)) {
            result = this.customizedEnvironment != null ? MapStorageElement.encodeMap(this.customizedEnvironment) : null;
        } else if ("org.eclipse.cdt.make.core.append_environment".equals(name)) {
            result = Boolean.valueOf(this.appendEnvironment()).toString();
        } else if (this.customBuildProperties != null) {
            result = (String)this.customBuildProperties.get(name);
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static String[] toBuildAttributes(String name) {
        if ("incrementalBuildTarget".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.target.inc", "org.eclipse.cdt.make.core.incrementalBuildTarget", "org.eclipse.cdt.make.core.build.target.full", "org.eclipse.cdt.make.core.fullBuildTarget"};
        }
        if ("autoBuildTarget".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.target.auto", "org.eclipse.cdt.make.core.autoBuildTarget"};
        }
        if ("cleanBuildTarget".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.target.clean", "org.eclipse.cdt.make.core.cleanBuildTarget"};
        }
        if ("buildPath".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.location", "org.eclipse.cdt.make.core.buildLocation"};
        }
        if ("command".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.command", "org.eclipse.cdt.make.core.buildCommand"};
        }
        if ("arguments".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.arguments", "org.eclipse.cdt.make.core.buildArguments"};
        }
        if ("stopOnErr".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.stopOnError"};
        }
        if ("enabledIncrementalBuild".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.enabledIncrementalBuild", "org.eclipse.cdt.make.core.enableFullBuild"};
        }
        if ("enableCleanBuild".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.enableCleanBuild"};
        }
        if ("enableAutoBuild".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.enableAutoBuild"};
        }
        if ("environment".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.environment"};
        }
        if ("appendEnvironment".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.append_environment"};
        }
        if ("customizedErrorParsers".equals(name)) {
            return new String[]{"org.eclipse.cdt.core.errorOutputParser"};
        }
        return new String[0];
    }

    public static String toBuilderAttribute(String name) {
        if ("org.eclipse.cdt.make.core.build.target.inc".equals(name) || "org.eclipse.cdt.make.core.incrementalBuildTarget".equals(name) || "org.eclipse.cdt.make.core.build.target.full".equals(name) || "org.eclipse.cdt.make.core.fullBuildTarget".equals(name)) {
            return "incrementalBuildTarget";
        }
        if ("org.eclipse.cdt.make.core.build.target.auto".equals(name) || "org.eclipse.cdt.make.core.autoBuildTarget".equals(name)) {
            return "autoBuildTarget";
        }
        if ("org.eclipse.cdt.make.core.build.target.clean".equals(name) || "org.eclipse.cdt.make.core.cleanBuildTarget".equals(name)) {
            return "cleanBuildTarget";
        }
        if ("org.eclipse.cdt.make.core.build.location".equals(name) || "org.eclipse.cdt.make.core.buildLocation".equals(name)) {
            return "buildPath";
        }
        if ("org.eclipse.cdt.make.core.build.command".equals(name) || "org.eclipse.cdt.make.core.buildCommand".equals(name)) {
            return "command";
        }
        if ("org.eclipse.cdt.make.core.build.arguments".equals(name) || "org.eclipse.cdt.make.core.buildArguments".equals(name)) {
            return "arguments";
        }
        if ("org.eclipse.cdt.make.core.stopOnError".equals(name)) {
            return "stopOnErr";
        }
        if ("org.eclipse.cdt.make.core.enabledIncrementalBuild".equals(name) || "org.eclipse.cdt.make.core.enableFullBuild".equals(name)) {
            return "enabledIncrementalBuild";
        }
        if ("org.eclipse.cdt.make.core.enableCleanBuild".equals(name)) {
            return "enableCleanBuild";
        }
        if ("org.eclipse.cdt.make.core.enableAutoBuild".equals(name)) {
            return "enableAutoBuild";
        }
        if ("org.eclipse.cdt.make.core.environment".equals(name)) {
            return "environment";
        }
        if ("org.eclipse.cdt.make.core.append_environment".equals(name)) {
            return "appendEnvironment";
        }
        if ("org.eclipse.cdt.core.errorOutputParser".equals(name)) {
            return "customizedErrorParsers";
        }
        return null;
    }

    public Map getEnvironment() {
        if (this.customizedEnvironment != null) {
            return (HashMap)this.customizedEnvironment.clone();
        }
        return null;
    }

    public Map getExpandedEnvironment() throws CoreException {
        if (this.customizedEnvironment != null) {
            HashMap expanded = (HashMap)this.customizedEnvironment.clone();
            ICdtVariableManager mngr = CCorePlugin.getDefault().getCdtVariableManager();
            String separator = CCorePlugin.getDefault().getBuildEnvironmentManager().getDefaultDelimiter();
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.getParent().getParent());
            Iterator iter = expanded.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String value = (String)entry.getValue();
                try {
                    value = mngr.resolveValue(value, EMPTY_STRING, separator, cfgDes);
                    entry.setValue(value);
                }
                catch (CdtVariableException cdtVariableException) {}
            }
            return expanded;
        }
        return null;
    }

    public void setAppendEnvironment(boolean append) throws CoreException {
        this.appendEnvironment = append;
    }

    public void setBuildAttribute(String name, String value) throws CoreException {
        if ("org.eclipse.cdt.make.core.build.target.inc".equals(name)) {
            this.incrementalBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.build.target.auto".equals(name)) {
            this.autoBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.build.target.clean".equals(name)) {
            this.cleanBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.build.location".equals(name)) {
            this.buildPath = value;
        } else if ("org.eclipse.cdt.make.core.build.command".equals(name)) {
            this.command = value;
        } else if ("org.eclipse.cdt.make.core.build.arguments".equals(name)) {
            this.args = value;
        } else if ("org.eclipse.cdt.make.core.buildCommand".equals(name)) {
            this.command = value;
        } else if ("org.eclipse.cdt.make.core.buildLocation".equals(name)) {
            this.buildPath = value;
        } else if ("org.eclipse.cdt.make.core.stopOnError".equals(name)) {
            this.stopOnErr = Boolean.valueOf(value);
        } else if ("org.eclipse.cdt.make.core.useDefaultBuildCmd".equals(name)) {
            if ((value == null || Boolean.valueOf(value).booleanValue()) && this.superClass != null) {
                this.command = null;
            }
        } else if ("org.eclipse.cdt.make.core.autoBuildTarget".equals(name)) {
            this.autoBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.incrementalBuildTarget".equals(name)) {
            this.incrementalBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.fullBuildTarget".equals(name)) {
            this.autoBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.cleanBuildTarget".equals(name)) {
            this.cleanBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.enableFullBuild".equals(name)) {
            this.autoBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.enableCleanBuild".equals(name)) {
            this.cleanBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.enabledIncrementalBuild".equals(name)) {
            this.incrementalBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.enableAutoBuild".equals(name)) {
            this.autoBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.buildArguments".equals(name)) {
            this.args = value;
        } else if ("org.eclipse.cdt.make.core.environment".equals(name)) {
            this.customizedEnvironment = value == null ? null : (HashMap)MapStorageElement.decodeMap(value);
        } else if ("org.eclipse.cdt.make.core.append_environment".equals(name)) {
            this.appendEnvironment = value != null ? Boolean.valueOf(value) : null;
        } else {
            this.getCustomBuildPropertiesMap().put(name, value);
        }
    }

    private Map getCustomBuildPropertiesMap() {
        if (this.customBuildProperties == null) {
            this.customBuildProperties = new HashMap();
        }
        return this.customBuildProperties;
    }

    public void setEnvironment(Map env) throws CoreException {
        this.customizedEnvironment = new HashMap(env);
    }

    public boolean isCustomBuilder() {
        return !this.isExtensionBuilder && this.getParent().getBuilder() != this;
    }

    public IConfiguration getConfguration() {
        if (this.getParent() != null) {
            return this.getParent().getParent();
        }
        return null;
    }

    public boolean isManagedBuildOn() {
        Boolean attr;
        IConfiguration cfg = this.getConfguration();
        if (cfg != null) {
            if (!cfg.supportsBuild(true)) {
                return false;
            }
            if (!cfg.supportsBuild(false)) {
                return true;
            }
        }
        if ((attr = this.getManagedBuildOnAttribute()) != null) {
            return attr;
        }
        return true;
    }

    public Boolean getManagedBuildOnAttribute() {
        if (this.managedBuildOn == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getManagedBuildOnAttribute();
            }
            return null;
        }
        return this.managedBuildOn;
    }

    public void setManagedBuildOn(boolean on) throws CoreException {
        this.managedBuildOn = on;
    }

    public boolean canKeepEnvironmentVariablesInBuildfile() {
        return BuildMacroProvider.canKeepMacrosInBuildfile(this);
    }

    public boolean keepEnvironmentVariablesInBuildfile() {
        if (this.keepEnvVarInBuildfile == null) {
            if (this.superClass != null) {
                return this.superClass.keepEnvironmentVariablesInBuildfile();
            }
            return false;
        }
        return this.keepEnvVarInBuildfile;
    }

    public void setKeepEnvironmentVariablesInBuildfile(boolean keep) {
        this.keepEnvVarInBuildfile = keep;
    }

    public boolean supportsCustomizedBuild() {
        if (this.fSupportsCustomizedBuild == null) {
            IManagedBuilderMakefileGenerator makeGen = this.getBuildFileGenerator();
            this.fSupportsCustomizedBuild = makeGen instanceof IManagedBuilderMakefileGenerator2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.fSupportsCustomizedBuild;
    }

    public boolean supportsBuild(boolean managed) {
        if (this.supportsManagedBuild == null) {
            if (this.superClass != null) {
                return this.superClass.supportsBuild(managed);
            }
            return managed || !this.isInternalBuilder();
        }
        return this.supportsManagedBuild;
    }

    public void setParent(IToolChain toolChain) {
        this.parent = toolChain;
    }

    public boolean matches(IBuilder builder) {
        if (builder == this) {
            return true;
        }
        IBuilder rBld = ManagedBuildManager.getRealBuilder(this);
        if (rBld == null) {
            return false;
        }
        return rBld == ManagedBuildManager.getRealBuilder(builder);
    }

    public boolean performMatchComparison(IBuilder builder) {
        if (builder == null) {
            return false;
        }
        if (builder == this) {
            return true;
        }
        if (!builder.getName().equals(this.getName())) {
            return false;
        }
        String thisVersion = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
        String otherVersion = ManagedBuildManager.getVersionFromIdAndVersion(builder.getId());
        return !(thisVersion == null || thisVersion.length() == 0 ? otherVersion != null && otherVersion.length() != 0 : !thisVersion.equals(otherVersion));
    }

    public Object getMatchKey() {
        if (this.isAbstract()) {
            return null;
        }
        if (!this.isExtensionBuilder) {
            return null;
        }
        return new MatchKey(this);
    }

    public void setIdenticalList(List list) {
        this.identicalList = list;
    }

    public String getNameAndVersion() {
        String name = this.getName();
        String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
        if (version != null && version.length() != 0) {
            return name + " (" + version + EMPTY_STRING;
        }
        return name;
    }

    public List getIdenticalList() {
        return this.identicalList;
    }

    public boolean isInternalBuilder() {
        IBuilder internalBuilder = ManagedBuildManager.getInternalBuilder();
        IBuilder builder = this;
        while (builder != null) {
            if (internalBuilder == builder) {
                return true;
            }
            builder = builder.getSuperClass();
        }
        return false;
    }

    public int getParallelizationNum() {
        if (this.supportsParallelBuild()) {
            return this.getParallelizationNumAttribute();
        }
        return 1;
    }

    public int getParallelizationNumAttribute() {
        if (this.parallelNum == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getParallelizationNumAttribute();
            }
            return 1;
        }
        return this.parallelNum;
    }

    public void setParallelizationNum(int num) throws CoreException {
        Integer newParallelNum = new Integer(num);
        String curCmd = this.getParallelizationCmd(this.getParallelizationNum());
        String args = this.getArgumentsAttribute();
        String updatedArgs = this.removeCmd(args, curCmd);
        if (!updatedArgs.equals(args)) {
            this.setArgumentsAttribute(updatedArgs);
        }
        this.parallelNum = newParallelNum;
        this.setDirty(true);
    }

    public boolean supportsParallelBuild() {
        if (this.isInternalBuilder()) {
            return true;
        }
        return this.getParrallelBuildCmd().length() != 0;
    }

    public boolean supportsStopOnError(boolean on) {
        if (this.isInternalBuilder()) {
            return true;
        }
        if (!on) {
            return this.getIgnoreErrCmdAttribute().length() != 0;
        }
        return true;
    }

    public String getStopOnErrCmd(boolean stop) {
        if (!stop) {
            return this.getIgnoreErrCmdAttribute();
        }
        return EMPTY_STRING;
    }

    public String getIgnoreErrCmdAttribute() {
        if (this.ignoreErrCmd == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getIgnoreErrCmdAttribute();
            }
            return EMPTY_STRING;
        }
        return this.ignoreErrCmd;
    }

    public String getParrallelBuildCmd() {
        if (this.parallelBuildCmd == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getParrallelBuildCmd();
            }
            return EMPTY_STRING;
        }
        return this.parallelBuildCmd;
    }

    public boolean isParallelBuildOn() {
        if (this.parallelBuildOn == null) {
            if (this.superClass != null) {
                return this.superClass.isParallelBuildOn();
            }
            return false;
        }
        return this.parallelBuildOn;
    }

    public void setParallelBuildOn(boolean on) throws CoreException {
        if (this.isParallelBuildOn() == on) {
            return;
        }
        if (on && !this.supportsParallelBuild()) {
            return;
        }
        String curCmd = this.getParallelizationCmd(this.getParallelizationNum());
        String args = this.getArgumentsAttribute();
        String updatedArgs = this.removeCmd(args, curCmd);
        if (!updatedArgs.equals(args)) {
            this.setArgumentsAttribute(updatedArgs);
        }
        this.parallelBuildOn = on;
        this.setDirty(true);
    }

    public Set contributeErrorParsers(Set set) {
        if (this.getErrorParserIds() != null) {
            String[] ids;
            if (set == null) {
                set = new HashSet<String>();
            }
            if ((ids = this.getErrorParserList()).length != 0) {
                set.addAll(Arrays.asList(ids));
            }
        }
        return set;
    }

    public void resetErrorParsers() {
        this.errorParserIds = null;
    }

    void removeErrorParsers(Set set) {
        HashSet oldSet = this.contributeErrorParsers(null);
        if (oldSet == null) {
            oldSet = new HashSet();
        }
        oldSet.removeAll(set);
        this.setErrorParserList(oldSet.toArray(new String[oldSet.size()]));
    }

    public void setErrorParserList(String[] ids) {
        if (ids == null) {
            this.errorParserIds = null;
        } else if (ids.length == 0) {
            this.errorParserIds = EMPTY_STRING;
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(ids[0]);
            int i = 1;
            while (i < ids.length) {
                buf.append(";").append(ids[i]);
                ++i;
            }
            this.errorParserIds = buf.toString();
        }
    }

    public boolean isSystemObject() {
        if (this.isTest) {
            return true;
        }
        if (this.getConvertToId().length() != 0) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isSystemObject();
        }
        return false;
    }

    public String getUniqueRealName() {
        String name = this.getName();
        if (name == null) {
            name = this.getId();
        } else {
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
            if (version != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(name);
                buf.append(" (v").append(version).append(")");
                name = buf.toString();
            }
        }
        return name;
    }

    public ICOutputEntry[] getOutputEntries() {
        if (this.isManagedBuildOn()) {
            return this.getDefaultOutputSettings();
        }
        ICOutputEntry[] entries = this.getOutputEntrySettings();
        if (entries == null || entries.length == 0) {
            entries = this.getDefaultOutputSettings();
        }
        return entries;
    }

    private ICOutputEntry[] getDefaultOutputSettings() {
        Configuration cfg = (Configuration)this.getConfguration();
        if (cfg == null || cfg.isPreference() || cfg.isExtensionElement()) {
            return new ICOutputEntry[]{new COutputEntry((IPath)Path.EMPTY, null, 24)};
        }
        Object path = ManagedBuildManager.getBuildFullPath(cfg, this);
        IProject proj = cfg.getOwner().getProject();
        IPath projFullPath = proj.getFullPath();
        path = path != null && projFullPath.isPrefixOf(path) ? path.removeFirstSegments(projFullPath.segmentCount()).makeRelative() : Path.EMPTY;
        return new ICOutputEntry[]{new COutputEntry(path, null, 24)};
    }

    public ICOutputEntry[] getOutputEntrySettings() {
        if (this.outputEntries == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getOutputEntrySettings();
            }
            return null;
        }
        return (ICOutputEntry[])this.outputEntries.clone();
    }

    public void setOutputEntries(ICOutputEntry[] entries) {
        this.outputEntries = entries != null ? (ICOutputEntry[])entries.clone() : null;
    }

    private int getSuperClassNum() {
        int num = 0;
        IBuilder superTool = this.getSuperClass();
        while (superTool != null) {
            ++num;
            superTool = superTool.getSuperClass();
        }
        return num;
    }

    public int compareTo(Object o) {
        Builder other = (Builder)o;
        if (other.isSystemObject() != this.isSystemObject()) {
            return this.isSystemObject() ? 1 : -1;
        }
        return this.getSuperClassNum() - other.getSuperClassNum();
    }

    public IRealBuildObjectAssociation getExtensionObject() {
        return (Builder)ManagedBuildManager.getExtensionBuilder(this);
    }

    public IRealBuildObjectAssociation[] getIdenticBuildObjects() {
        return (IRealBuildObjectAssociation[])ManagedBuildManager.findIdenticalBuilders(this);
    }

    public IRealBuildObjectAssociation getRealBuildObject() {
        return (Builder)ManagedBuildManager.getRealBuilder(this);
    }

    public IRealBuildObjectAssociation getSuperClassObject() {
        return (Builder)this.getSuperClass();
    }

    public final int getType() {
        return 4;
    }

    public boolean isRealBuildObject() {
        return ManagedBuildManager.getRealBuilder(this) == this;
    }

    public boolean isExtensionBuildObject() {
        return this.isExtensionElement();
    }

    public String toString() {
        return this.getUniqueRealName();
    }

    private class MatchKey {
        Builder builder;

        public MatchKey(Builder builder2) {
            this.builder = builder2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchKey)) {
                return false;
            }
            MatchKey other = (MatchKey)obj;
            return this.builder.performMatchComparison(other.builder);
        }

        public int hashCode() {
            String name = Builder.this.getName();
            if (name == null) {
                name = Builder.this.getId();
            }
            int code = name.hashCode();
            String version = ManagedBuildManager.getVersionFromIdAndVersion(Builder.this.getId());
            if (version != null) {
                code += version.hashCode();
            }
            return code;
        }
    }
}

