/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.ListComparator;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStateManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DescriptionBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IProjectBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ParallelBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.StepBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.newmake.core.IMakeBuilderInfo;
import org.eclipse.cdt.newmake.internal.core.StreamMonitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class CommonBuilder
extends ACBuilder {
    public static final String BUILDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".genmakebuilder";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String CONSOLE_HEADER = "ManagedMakeBuilder.message.console.header";
    private static final String ERROR_HEADER = "GeneratedmakefileBuilder error [";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String NOTHING_BUILT = "ManagedMakeBuilder.message.no.build";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "GeneratedmakefileBuilder trace [";
    private static final String TYPE_CLEAN = "ManagedMakeBuilder.type.clean";
    private static final String TYPE_INC = "ManagedMakeBuider.type.incremental";
    private static final String WARNING_UNSUPPORTED_CONFIGURATION = "ManagedMakeBuilder.warning.unsupported.configuration";
    private static final String BUILD_CANCELLED = "ManagedMakeBuilder.message.cancelled";
    private static final String BUILD_FINISHED_WITH_ERRS = "ManagedMakeBuilder.message.finished.with.errs";
    private static final String BUILD_FAILED_ERR = "ManagedMakeBuilder.message.internal.builder.error";
    private static final String BUILD_STOPPED_ERR = "ManagedMakeBuilder.message.stopped.error";
    private static final String INTERNAL_BUILDER_HEADER_NOTE = "ManagedMakeBuilder.message.internal.builder.header.note";
    private static final String TYPE_REBUILD = "ManagedMakeBuider.type.rebuild";
    private static final String INTERNAL_BUILDER = "ManagedMakeBuilder.message.internal.builder";
    public static boolean VERBOSE = false;
    private static CfgBuildSet fBuildSet = new CfgBuildSet();
    private boolean fBuildErrOccured;

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    protected boolean isCdtProjectCreated(IProject project) {
        ICProjectDescription des = CoreModel.getDefault().getProjectDescription(project, false);
        return des != null && !des.isCdtProjectCreating();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        fBuildSet.start(this);
        IProject project = this.getProject();
        if (!this.isCdtProjectCreated(project)) {
            return project.getReferencedProjects();
        }
        if (VERBOSE) {
            CommonBuilder.outputTrace(project.getName(), ">>build requested, type = " + kind);
        }
        IBuilder[] builders = ManagedBuilderCorePlugin.createBuilders(project, args);
        IProject[] projects = this.build(kind, project, builders, true, monitor);
        if (VERBOSE) {
            CommonBuilder.outputTrace(project.getName(), "<<done build requested, type = " + kind);
        }
        return projects;
    }

    protected IProject[] build(int kind, IProject project, IBuilder[] builders, boolean isForeground, IProgressMonitor monitor) throws CoreException {
        if (!this.isCdtProjectCreated(project)) {
            return project.getReferencedProjects();
        }
        int num = builders.length;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration activeCfg = info.getDefaultConfiguration();
        IProject[] refProjects = project.getReferencedProjects();
        if (num != 0) {
            Set set;
            MultiStatus status = this.checkBuilders(builders, activeCfg);
            if (status.getSeverity() != 0) {
                throw new CoreException((IStatus)status);
            }
            IConfiguration[] cfgs = this.getReferencedConfigs(builders);
            monitor.beginTask("", num + cfgs.length);
            if (cfgs.length != 0 && (set = this.buildReferencedConfigs(cfgs, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).size() != 0) {
                set.addAll(Arrays.asList(refProjects));
                refProjects = set.toArray(new IProject[set.size()]);
            }
            int i = 0;
            while (i < num) {
                this.build(kind, new CfgBuildInfo(builders[i], isForeground), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        if (isForeground) {
            this.updateOtherConfigs(info, builders, kind);
        }
        monitor.done();
        return project.getReferencedProjects();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set buildReferencedConfigs(IConfiguration[] cfgs, IProgressMonitor monitor) {
        Set projSet = this.getProjectsSet(cfgs);
        if ((cfgs = this.filterConfigsToBuild(cfgs)).length == 0) {
            monitor.done();
            return projSet;
        }
        monitor.beginTask(ManagedMakeMessages.getResourceString("CommonBuilder.22"), cfgs.length);
        int i = 0;
        while (i < cfgs.length) {
            Object var9_10;
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            try {
                try {
                    IConfiguration cfg = cfgs[i];
                    IBuilder builder = cfg.getEditableBuilder();
                    if (VERBOSE) {
                        CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), ">>>>building reference cfg " + cfg.getName());
                    }
                    IProject[] projs = this.build(10, cfg.getOwner().getProject(), new IBuilder[]{builder}, false, (IProgressMonitor)subMonitor);
                    if (VERBOSE) {
                        CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "<<<<done building reference cfg " + cfg.getName());
                    }
                    projSet.addAll(Arrays.asList(projs));
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            }
            catch (Throwable throwable) {
                var9_10 = null;
                subMonitor.done();
                throw throwable;
            }
            {
                var9_10 = null;
            }
            subMonitor.done();
            ++i;
        }
        return projSet;
    }

    private IConfiguration[] filterConfigsToBuild(IConfiguration[] cfgs) {
        ArrayList<IConfiguration> cfgList = new ArrayList<IConfiguration>(cfgs.length);
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration cfg = cfgs[i];
            IProject project = cfg.getOwner().getProject();
            Set set = fBuildSet.getCfgIdSet(project, true);
            if (set.add(cfg.getId())) {
                if (VERBOSE) {
                    CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "set: adding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
                    CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "filtering regs: adding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
                }
                cfgList.add(cfg);
            } else if (VERBOSE) {
                CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "filtering regs: excluding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
            }
            ++i;
        }
        return cfgList.toArray(new IConfiguration[cfgList.size()]);
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    private IConfiguration[] getReferencedConfigs(IBuilder[] builders) {
        HashSet<IConfiguration> set = new HashSet<IConfiguration>();
        int i = 0;
        while (i < builders.length) {
            IConfiguration cfg = builders[i].getParent().getParent();
            IConfiguration[] refs = ManagedBuildManager.getReferencedConfigurations(cfg);
            int k = 0;
            while (k < refs.length) {
                set.add(refs[k]);
                ++k;
            }
            ++i;
        }
        return set.toArray(new Configuration[set.size()]);
    }

    private Set getProjectsSet(IConfiguration[] cfgs) {
        if (cfgs.length == 0) {
            return new HashSet(0);
        }
        HashSet<IProject> set = new HashSet<IProject>();
        int i = 0;
        while (i < cfgs.length) {
            set.add(cfgs[i].getOwner().getProject());
            ++i;
        }
        return set;
    }

    protected MultiStatus checkBuilders(IBuilder[] builders, IConfiguration activeCfg) {
        MultiStatus status = null;
        int i = 0;
        while (i < builders.length) {
            IBuilder builder = builders[i];
            boolean supportsCustomization = builder.supportsCustomizedBuild();
            boolean isManagedBuildOn = builder.isManagedBuildOn();
            if (isManagedBuildOn && !supportsCustomization) {
                if (builder.isCustomBuilder()) {
                    if (status == null) {
                        status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null);
                    }
                    status.add((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getResourceString("CommonBuilder.1"), null));
                } else if (builder.getParent().getParent() != activeCfg) {
                    if (status == null) {
                        status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null);
                    }
                    status.add((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getResourceString("CommonBuilder.2"), null));
                }
            }
            ++i;
        }
        if (status == null) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    private void updateOtherConfigs(IManagedBuildInfo info, IBuilder[] builders, int buildKind) {
        IConfiguration[] allCfgs = info.getManagedProject().getConfigurations();
        new OtherConfigVerifier(builders, allCfgs).updateOtherConfigs(buildKind == 6 ? null : this.getDelta(info.getManagedProject().getOwner().getProject()));
    }

    protected void build(int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            CommonBuilder.outputTrace(bInfo.getProject().getName(), "building cfg " + bInfo.getConfiguration().getName() + " with builder " + bInfo.getBuilder().getName());
        }
        IBuilder builder = bInfo.getBuilder();
        BuildStatus status = new BuildStatus(builder);
        if (!this.shouldBuild(kind, builder)) {
            return;
        }
        if (status.isBuild()) {
            IConfiguration cfg = bInfo.getConfiguration();
            if (!builder.isCustomBuilder()) {
                Set set = fBuildSet.getCfgIdSet(bInfo.getProject(), true);
                if (VERBOSE) {
                    CommonBuilder.outputTrace(bInfo.getProject().getName(), "set: adding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
                }
                set.add(cfg.getId());
            }
            if (status.isManagedBuildOn()) {
                status = this.performPrebuildGeneration(kind, bInfo, status, monitor);
            }
            if (status.isBuild()) {
                try {
                    boolean isClean = this.invokeBuilder(kind, bInfo, monitor);
                    if (isClean) {
                        this.forgetLastBuiltState();
                        cfg.setRebuildState(true);
                    } else {
                        if (status.isManagedBuildOn()) {
                            this.performPostbuildGeneration(kind, bInfo, status, monitor);
                        }
                        cfg.setRebuildState(false);
                    }
                }
                catch (CoreException e) {
                    cfg.setRebuildState(true);
                    throw e;
                }
                PropertyManager.getInstance().serialize(cfg);
            } else if (status.getConsoleMessagesList().size() != 0) {
                this.emitMessage(bInfo, this.concatMessages(status.getConsoleMessagesList()));
            }
        }
        this.checkCancel(monitor);
    }

    private String concatMessages(List msgs) {
        int size = msgs.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return (String)msgs.get(0);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(msgs.get(0));
        int i = 1;
        while (i < size) {
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append((String)msgs.get(i));
            ++i;
        }
        return buf.toString();
    }

    private String createNoSourceMessage(int buildType, IStatus status, CfgBuildInfo bInfo) throws CoreException {
        StringBuffer buf = new StringBuffer();
        String[] consoleHeader = new String[3];
        String configName = bInfo.getConfiguration().getName();
        String projName = bInfo.getProject().getName();
        if (buildType == 6 || buildType == 10) {
            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
        } else {
            consoleHeader[0] = new String();
            CommonBuilder.outputError(projName, "The given build type is not supported in this context");
        }
        consoleHeader[1] = configName;
        consoleHeader[2] = projName;
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(status.getMessage());
        buf.append(System.getProperty("line.separator", "\n"));
        return buf.toString();
    }

    private void emitMessage(CfgBuildInfo info, String msg) throws CoreException {
        try {
            IConsole console = info.getConsole();
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            consoleOutStream.write(msg.getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException io) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), io.getLocalizedMessage(), (Throwable)io));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean invokeInternalBuilder(int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) {
        ConsoleOutputStream consoleOutStream;
        block28: {
            IBuilder builder = bInfo.getBuilder();
            IConfiguration cfg = bInfo.getConfiguration();
            boolean isParallel = builder.isParallelBuildOn() && builder.getParallelizationNum() > 1;
            boolean resumeOnErr = !builder.isStopOnError();
            IProject currentProject = bInfo.getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            String[] msgs = new String[]{ManagedMakeMessages.getResourceString(INTERNAL_BUILDER), currentProject.getName()};
            consoleOutStream = null;
            IConsole console = null;
            OutputStream epmOutputStream = null;
            try {
                block27: {
                    try {
                        int flags = 0;
                        IResourceDelta delta = this.getDelta(currentProject);
                        BuildStateManager bsMngr = BuildStateManager.getInstance();
                        IProjectBuildState pBS = bsMngr.getProjectBuildState(currentProject);
                        IConfigurationBuildState cBS = pBS.getConfigurationBuildState(cfg.getId(), true);
                        flags = 7;
                        boolean buildIncrementaly = delta != null;
                        StringBuffer buf = new StringBuffer();
                        console = bInfo.getConsole();
                        consoleOutStream = console.getOutputStream();
                        String[] consoleHeader = new String[]{buildIncrementaly ? ManagedMakeMessages.getResourceString(TYPE_INC) : ManagedMakeMessages.getResourceString(TYPE_REBUILD), cfg.getName(), currentProject.getName()};
                        buf.append(System.getProperty("line.separator", "\n"));
                        buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
                        buf.append(System.getProperty("line.separator", "\n"));
                        buf.append(System.getProperty("line.separator", "\n"));
                        buf.append(ManagedMakeMessages.getResourceString(INTERNAL_BUILDER_HEADER_NOTE));
                        buf.append("\n");
                        if (!cfg.isSupported()) {
                            buf.append(ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{cfg.getName(), cfg.getToolChain().getName()}));
                            buf.append(System.getProperty("line.separator", "\n"));
                            buf.append(System.getProperty("line.separator", "\n"));
                        }
                        consoleOutStream.write(buf.toString().getBytes());
                        consoleOutStream.flush();
                        IBuildDescription des = BuildDescriptionManager.createBuildDescription(cfg, cBS, delta, flags);
                        DescriptionBuilder dBuilder = null;
                        if (!isParallel) {
                            dBuilder = new DescriptionBuilder(des, buildIncrementaly, resumeOnErr, cBS);
                        }
                        if (isParallel || dBuilder.getNumCommands() > 0) {
                            this.removeAllMarkers(currentProject);
                            String[] errorParsers = builder.getErrorParsers();
                            ErrorParserManager epm = new ErrorParserManager(currentProject, des.getDefaultBuildDirLocation(), (IMarkerGenerator)this, errorParsers);
                            epm.setOutputStream((OutputStream)consoleOutStream);
                            epmOutputStream = epm.getOutputStream();
                            int status = 0;
                            long t1 = System.currentTimeMillis();
                            status = isParallel ? ParallelBuilder.build(des, null, null, epmOutputStream, epmOutputStream, monitor, resumeOnErr, buildIncrementaly) : dBuilder.build(epmOutputStream, epmOutputStream, monitor);
                            long t2 = System.currentTimeMillis();
                            buf = new StringBuffer();
                            switch (status) {
                                case 0: {
                                    buf.append(ManagedMakeMessages.getFormattedString(BUILD_FINISHED, currentProject.getName()));
                                    break;
                                }
                                case -3: {
                                    buf.append(ManagedMakeMessages.getResourceString(BUILD_CANCELLED));
                                    break;
                                }
                                case -1: {
                                    String msg = resumeOnErr ? ManagedMakeMessages.getResourceString(BUILD_FINISHED_WITH_ERRS) : ManagedMakeMessages.getResourceString(BUILD_STOPPED_ERR);
                                    buf.append(msg);
                                    break;
                                }
                                default: {
                                    buf.append(ManagedMakeMessages.getResourceString(BUILD_FAILED_ERR));
                                }
                            }
                            buf.append(System.getProperty("line.separator", "\n"));
                            buf.append(ManagedMakeMessages.getFormattedString("CommonBuilder.6", Integer.toString((int)(t2 - t1))));
                            if (isParallel) {
                                buf.append(ManagedMakeMessages.getFormattedString("CommonBuilder.7", Integer.toString(ParallelBuilder.lastThreadsUsed)));
                            }
                            buf.append(System.getProperty("line.separator", "\n"));
                            consoleOutStream.write(buf.toString().getBytes());
                            consoleOutStream.flush();
                            epmOutputStream.close();
                            epmOutputStream = null;
                            monitor.subTask(ManagedMakeMessages.getResourceString(MARKERS));
                            epm.reportProblems();
                            bsMngr.setProjectBuildState(currentProject, pBS);
                            break block27;
                        }
                        buf = new StringBuffer();
                        buf.append(ManagedMakeMessages.getFormattedString(NOTHING_BUILT, currentProject.getName()));
                        buf.append(System.getProperty("line.separator", "\n"));
                        consoleOutStream.write(buf.toString().getBytes());
                        consoleOutStream.flush();
                    }
                    catch (Exception e) {
                        if (consoleOutStream != null) {
                            StringBuffer buf = new StringBuffer();
                            String errorDesc = ManagedMakeMessages.getResourceString(BUILD_ERROR);
                            buf.append(errorDesc);
                            buf.append(System.getProperty("line.separator", "\n"));
                            buf.append(e.getLocalizedMessage());
                            buf.append(System.getProperty("line.separator", "\n"));
                            try {
                                consoleOutStream.write(buf.toString().getBytes());
                                consoleOutStream.flush();
                            }
                            catch (IOException iOException) {}
                        }
                        this.forgetLastBuiltState();
                    }
                }
                Object var31_34 = null;
                if (epmOutputStream == null) break block28;
            }
            catch (Throwable throwable) {
                Object var31_33 = null;
                if (epmOutputStream != null) {
                    try {
                        epmOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (consoleOutStream != null) {
                    try {
                        consoleOutStream.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            epmOutputStream.close();
        }
        if (consoleOutStream != null) {
            try {}
            catch (IOException iOException) {}
            consoleOutStream.close();
        }
        monitor.done();
        return false;
    }

    protected String[] calcEnvironment(IBuilder builder) throws CoreException {
        Map builderEnv;
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (builder.appendEnvironment()) {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(builder.getParent().getParent());
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] vars = mngr.getVariables(cfgDes, true);
            int i = 0;
            while (i < vars.length) {
                envMap.put(vars[i].getName(), vars[i].getValue());
                ++i;
            }
        }
        if ((builderEnv = builder.getExpandedEnvironment()) != null) {
            envMap.putAll(builderEnv);
        }
        Iterator iter = envMap.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private void invokeInternalBuilder(IResource[] resourcesToBuild, CfgBuildInfo bInfo, boolean buildIncrementaly, boolean resumeOnErr, boolean initNewConsole, boolean printFinishedMessage, IProgressMonitor monitor) {
        IProject currentProject = bInfo.getProject();
        IConfiguration cfg = bInfo.getConfiguration();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int flags = 0;
            IResourceDelta delta = null;
            if (buildIncrementaly) {
                flags = 7;
                delta = this.getDelta(currentProject);
            }
            String[] msgs = new String[]{ManagedMakeMessages.getResourceString(INTERNAL_BUILDER), currentProject.getName()};
            IConsole console = bInfo.getConsole();
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            StringBuffer buf = new StringBuffer();
            if (initNewConsole) {
                if (buildIncrementaly) {
                    buf.append(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.buildSelectedIncremental"));
                } else {
                    buf.append(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.buildSelectedRebuild"));
                }
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(ManagedMakeMessages.getResourceString(INTERNAL_BUILDER_HEADER_NOTE));
                buf.append("\n");
            }
            if (!cfg.isSupported()) {
                buf.append(ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{cfg.getName(), cfg.getToolChain().getName()}));
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(System.getProperty("line.separator", "\n"));
            }
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            this.removeAllMarkers(currentProject);
            IBuildDescription des = BuildDescriptionManager.createBuildDescription(cfg, delta, flags);
            String[] errorParsers = cfg.getErrorParserList();
            ErrorParserManager epm = new ErrorParserManager(currentProject, des.getDefaultBuildDirLocation(), (IMarkerGenerator)this, errorParsers);
            epm.setOutputStream((OutputStream)consoleOutStream);
            OutputStream epmOutputStream = epm.getOutputStream();
            boolean errorsFound = false;
            int k = 0;
            block7: while (k < resourcesToBuild.length) {
                IBuildResource buildResource = des.getBuildResource(resourcesToBuild[k]);
                HashSet<IBuildStep> dependentSteps = new HashSet<IBuildStep>();
                IBuildIOType[] depTypes = buildResource.getDependentIOTypes();
                int j = 0;
                while (j < depTypes.length) {
                    IBuildIOType type = depTypes[j];
                    if (type != null && type.getStep() != null) {
                        dependentSteps.add(type.getStep());
                    }
                    ++j;
                }
                monitor.subTask(String.valueOf(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.buildingFile")) + resourcesToBuild[k].getProjectRelativePath());
                Iterator stepIter = dependentSteps.iterator();
                block9: while (stepIter.hasNext()) {
                    IBuildStep step = (IBuildStep)stepIter.next();
                    StepBuilder stepBuilder = new StepBuilder(step, null);
                    int status = stepBuilder.build((OutputStream)consoleOutStream, epmOutputStream, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                    IBuildIOType[] outputIOTypes = step.getOutputIOTypes();
                    int j2 = 0;
                    while (j2 < outputIOTypes.length) {
                        IBuildResource[] resources = outputIOTypes[j2].getResources();
                        int i = 0;
                        while (i < resources.length) {
                            IFile file = currentProject.getFile(resources[i].getLocation());
                            file.refreshLocal(2, null);
                            ++i;
                        }
                        ++j2;
                    }
                    switch (status) {
                        case 0: {
                            break;
                        }
                        case -3: {
                            buf.append(ManagedMakeMessages.getResourceString(BUILD_CANCELLED));
                            break block7;
                        }
                        case -1: {
                            errorsFound = true;
                            if (resumeOnErr) continue block9;
                            buf.append(ManagedMakeMessages.getResourceString(BUILD_STOPPED_ERR));
                            break block7;
                        }
                        default: {
                            buf.append(ManagedMakeMessages.getResourceString(BUILD_FAILED_ERR));
                            break block7;
                        }
                    }
                }
                ++k;
            }
            buf = new StringBuffer();
            buf.append(System.getProperty("line.separator", "\n"));
            if (printFinishedMessage) {
                if (errorsFound) {
                    buf.append(ManagedMakeMessages.getResourceString(BUILD_FAILED_ERR));
                } else {
                    buf.append(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.buildResourcesFinished"));
                }
            }
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            epmOutputStream.close();
            epm.reportProblems();
            consoleOutStream.close();
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            String errorDesc = ManagedMakeMessages.getResourceString(BUILD_ERROR);
            buf.append(errorDesc);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append("(").append(e.getLocalizedMessage()).append(")");
            this.forgetLastBuiltState();
        }
    }

    protected BuildStatus performPostbuildGeneration(int kind, CfgBuildInfo bInfo, BuildStatus buildStatus, IProgressMonitor monitor) throws CoreException {
        IBuilder builder = bInfo.getBuilder();
        if (builder.isInternalBuilder()) {
            return buildStatus;
        }
        if (buildStatus.isRebuild()) {
            buildStatus.getMakeGen().regenerateDependencies(false);
        } else {
            buildStatus.getMakeGen().generateDependencies();
        }
        return buildStatus;
    }

    protected BuildStatus performPrebuildGeneration(int kind, CfgBuildInfo bInfo, BuildStatus buildStatus, IProgressMonitor monitor) throws CoreException {
        IBuilder builder = bInfo.getBuilder();
        if (builder.isInternalBuilder()) {
            return buildStatus;
        }
        buildStatus = this.performCleanning(kind, bInfo, buildStatus, monitor);
        IManagedBuilderMakefileGenerator generator = builder.getBuildFileGenerator();
        if (generator != null) {
            this.initializeGenerator(generator, kind, bInfo, monitor);
            buildStatus.setMakeGen(generator);
            MultiStatus result = this.performMakefileGeneration(bInfo, generator, buildStatus, monitor);
            if (result.getCode() == 2 || result.getCode() == 1) {
                IStatus[] kids = result.getChildren();
                int index = 0;
                while (index < kids.length) {
                    IStatus status = kids[index];
                    if (status.getCode() == 1) {
                        buildStatus.getConsoleMessagesList().add(this.createNoSourceMessage(kind, status, bInfo));
                        buildStatus.cancelBuild();
                    }
                    ++index;
                }
            } else if (result.getCode() == 4) {
                StringBuffer buf = new StringBuffer();
                buf.append(ManagedMakeMessages.getString("CommonBuilder.23")).append(NEWLINE);
                String message = result.getMessage();
                if (message != null || message.length() != 0) {
                    buf.append(message).append(NEWLINE);
                }
                buf.append(ManagedMakeMessages.getString("CommonBuilder.24")).append(NEWLINE);
                message = buf.toString();
                buildStatus.getConsoleMessagesList().add(message);
                buildStatus.cancelBuild();
            }
            this.checkCancel(monitor);
        } else {
            buildStatus.cancelBuild();
        }
        return buildStatus;
    }

    protected BuildStatus performCleanning(int kind, CfgBuildInfo bInfo, BuildStatus status, IProgressMonitor monitor) throws CoreException {
        boolean makefileRegenerationNeeded;
        block9: {
            IConfiguration cfg = bInfo.getConfiguration();
            IProject curProject = bInfo.getProject();
            makefileRegenerationNeeded = false;
            if (cfg.needsFullRebuild()) {
                CommonBuilder.outputTrace(curProject.getName(), "config rebuild state is set to true, making a full rebuild");
                this.clean(bInfo, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                makefileRegenerationNeeded = true;
            } else {
                IResourceDelta delta;
                makefileRegenerationNeeded = cfg.needsRebuild();
                IBuildDescription des = null;
                IResourceDelta iResourceDelta = delta = kind == 6 ? null : this.getDelta(curProject);
                if (delta == null) {
                    makefileRegenerationNeeded = true;
                }
                if (cfg.needsRebuild() || delta != null) {
                    try {
                        int flags = 14;
                        if (delta != null) {
                            flags |= 1;
                        }
                        CommonBuilder.outputTrace(curProject.getName(), "using a build description..");
                        des = BuildDescriptionManager.createBuildDescription(cfg, this.getDelta(curProject), flags);
                        BuildDescriptionManager.cleanGeneratedRebuildResources(des);
                    }
                    catch (Throwable e) {
                        CommonBuilder.outputError(curProject.getName(), "error occured while build description calculation: " + e.getLocalizedMessage());
                        if (cfg.needsRebuild()) {
                            this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                            makefileRegenerationNeeded = true;
                        }
                        if (delta == null || makefileRegenerationNeeded) break block9;
                        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(cfg, bInfo.getBuildInfo().getManagedProject().getConfigurations());
                        delta.accept((IResourceDeltaVisitor)visitor);
                        if (!visitor.shouldBuildFull()) break block9;
                        this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                        makefileRegenerationNeeded = true;
                    }
                }
            }
        }
        if (makefileRegenerationNeeded) {
            status.setRebuild();
        }
        return status;
    }

    protected MultiStatus performMakefileGeneration(CfgBuildInfo bInfo, IManagedBuilderMakefileGenerator generator, BuildStatus buildStatus, IProgressMonitor monitor) throws CoreException {
        IProject curProject = bInfo.getProject();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.update.makefiles", curProject.getName());
        monitor.subTask(statusMsg);
        MultiStatus result = buildStatus.isRebuild() ? generator.regenerateMakefiles() : generator.generateMakefiles(this.getDelta(curProject));
        return result;
    }

    private MultiStatus createMultiStatus(int severity) {
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), severity, new String(), null);
    }

    protected void initializeGenerator(IManagedBuilderMakefileGenerator generator, int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) {
        if (generator instanceof IManagedBuilderMakefileGenerator2) {
            IManagedBuilderMakefileGenerator2 gen2 = (IManagedBuilderMakefileGenerator2)generator;
            gen2.initialize(kind, bInfo.getConfiguration(), bInfo.getBuilder(), monitor);
        } else {
            generator.initialize(bInfo.getProject(), bInfo.getBuildInfo(), monitor);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject curProject = this.getProject();
        if (!this.isCdtProjectCreated(curProject)) {
            return;
        }
        IBuilder[] builders = ManagedBuilderCorePlugin.createBuilders(curProject, null);
        int i = 0;
        while (i < builders.length) {
            IBuilder builder = builders[i];
            CfgBuildInfo bInfo = new CfgBuildInfo(builder, true);
            this.clean(bInfo, monitor);
            ++i;
        }
    }

    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        super.addMarker(file, lineNumber, errorDesc, severity, errorVar);
        if (severity == 4) {
            this.fBuildErrOccured = true;
        }
    }

    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        super.addMarker(problemMarkerInfo);
        if (problemMarkerInfo.severity == 4) {
            this.fBuildErrOccured = true;
        }
    }

    protected void clean(CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        if (this.shouldBuild(15, bInfo.getBuilder())) {
            BuildStateManager bsMngr = BuildStateManager.getInstance();
            IProject project = bInfo.getProject();
            IConfiguration cfg = bInfo.getConfiguration();
            IProjectBuildState pbs = bsMngr.getProjectBuildState(project);
            IConfigurationBuildState cbs = pbs.getConfigurationBuildState(cfg.getId(), false);
            if (cbs != null) {
                pbs.removeConfigurationBuildState(cfg.getId());
                bsMngr.setProjectBuildState(project, pbs);
            }
            if (!cfg.getEditableBuilder().isManagedBuildOn()) {
                this.performExternalClean(bInfo, false, monitor);
            } else {
                IResource rc;
                boolean programmatically = true;
                IPath path = ManagedBuildManager.getBuildFullPath(cfg, bInfo.getBuilder());
                IResource iResource = rc = path != null ? ResourcesPlugin.getWorkspace().getRoot().findMember(path) : null;
                if (path == null || rc != null && rc.getType() != 1) {
                    if (!cfg.getEditableBuilder().isInternalBuilder()) {
                        this.fBuildErrOccured = false;
                        try {
                            this.performExternalClean(bInfo, false, monitor);
                        }
                        catch (CoreException coreException) {
                            this.fBuildErrOccured = true;
                        }
                        if (!this.fBuildErrOccured) {
                            programmatically = false;
                        }
                    }
                    if (programmatically) {
                        try {
                            this.cleanWithInternalBuilder(bInfo, monitor);
                        }
                        catch (CoreException coreException) {
                            this.cleanProgrammatically(bInfo, monitor);
                        }
                    }
                }
            }
        }
    }

    protected void performExternalClean(final CfgBuildInfo bInfo, boolean separateJob, IProgressMonitor monitor) throws CoreException {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        final ISchedulingRule rule = ruleFactory.modifyRule((IResource)bInfo.getProject());
        if (separateJob) {
            Job backgroundJob = new Job("CDT Common Builder"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, bInfo){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ CfgBuildInfo val$bInfo;
                            {
                                this.this$1 = var1_1;
                                this.val$bInfo = cfgBuildInfo;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                2.access$0(this.this$1).invokeMake(15, this.val$bInfo, monitor);
                            }
                        }, rule, 1, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }

                static /* synthetic */ CommonBuilder access$0(2 var0) {
                    return var0.CommonBuilder.this;
                }
            };
            backgroundJob.setRule(rule);
            backgroundJob.schedule();
        } else {
            this.invokeMake(15, bInfo, monitor);
        }
    }

    protected boolean shouldCleanProgrammatically(CfgBuildInfo bInfo) {
        return bInfo.getBuilder().isManagedBuildOn();
    }

    protected void cleanWithInternalBuilder(CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        IProject curProject = bInfo.getProject();
        CommonBuilder.outputTrace(curProject.getName(), "Clean build with Internal Builder requested");
        IConfiguration cfg = bInfo.getConfiguration();
        int flags = 8;
        BuildDescription des = (BuildDescription)BuildDescriptionManager.createBuildDescription(cfg, null, null, flags);
        IBuildStep cleanStep = des.getCleanStep();
        StepBuilder sBuilder = new StepBuilder(cleanStep, null, null);
        try {
            StringBuffer buf = new StringBuffer();
            IConsole console = bInfo.getConsole();
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[]{ManagedMakeMessages.getResourceString(TYPE_CLEAN), cfg.getName(), curProject.getName()};
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
            buf.append(System.getProperty("line.separator", "\n"));
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            buf = new StringBuffer();
            sBuilder.build((OutputStream)consoleOutStream, (OutputStream)consoleOutStream, monitor);
            String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, curProject.getName());
            buf.append(successMsg);
            buf.append(System.getProperty("line.separator", "\n"));
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (IOException iOException) {}
    }

    protected void cleanProgrammatically(CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        IProject curProject = bInfo.getProject();
        CommonBuilder.outputTrace(curProject.getName(), "Clean build requested");
        IBuilder builder = bInfo.getBuilder();
        IConfiguration cfg = bInfo.getConfiguration();
        IPath buildPath = ManagedBuildManager.getBuildFullPath(cfg, builder);
        if (buildPath == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.0")));
        }
        IPath projectFullPath = curProject.getFullPath();
        if (!projectFullPath.isPrefixOf(buildPath)) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.16")));
        }
        IWorkspace workspace = CCorePlugin.getWorkspace();
        IResource rc = workspace.getRoot().findMember(buildPath);
        if (rc != null) {
            if (rc.getType() != 2) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.12")));
            }
            IFolder buildDir = (IFolder)rc;
            if (!buildDir.isAccessible()) {
                CommonBuilder.outputError(buildDir.getName(), "Could not delete the build directory");
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.13")));
            }
            try {
                String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.deleting.output", buildDir.getName());
                monitor.subTask(status);
                workspace.delete(new IResource[]{buildDir}, true, monitor);
                StringBuffer buf = new StringBuffer();
                IConsole console = bInfo.getConsole();
                ConsoleOutputStream consoleOutStream = console.getOutputStream();
                String[] consoleHeader = new String[]{ManagedMakeMessages.getResourceString(TYPE_CLEAN), cfg.getName(), curProject.getName()};
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
                buf.append(System.getProperty("line.separator", "\n"));
                consoleOutStream.write(buf.toString().getBytes());
                consoleOutStream.flush();
                buf = new StringBuffer();
                String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, curProject.getName());
                buf.append(successMsg);
                buf.append(System.getProperty("line.separator", "\n"));
                consoleOutStream.write(buf.toString().getBytes());
                consoleOutStream.flush();
                consoleOutStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean invokeBuilder(int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        if (bInfo.getBuilder().isInternalBuilder()) {
            return this.invokeInternalBuilder(kind, bInfo, monitor);
        }
        return this.invokeMake(kind, bInfo, monitor);
    }

    private ConsoleOutputSniffer createBuildOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, IConfiguration cfg, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        ICfgScannerConfigBuilderInfo2Set container = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo(cfg);
        Map map = container.getInfoMap();
        ArrayList clParserList = new ArrayList();
        if (container.isPerRcTypeDiscovery()) {
            IResourceInfo[] rcInfos = cfg.getResourceInfos();
            int q = 0;
            while (q < rcInfos.length) {
                IResourceInfo rcInfo = rcInfos[q];
                ITool[] tools = rcInfo instanceof IFileInfo ? ((IFileInfo)rcInfo).getToolsToInvoke() : ((IFolderInfo)rcInfo).getFilteredTools();
                int i = 0;
                while (i < tools.length) {
                    ITool tool = tools[i];
                    IInputType[] types = tool.getInputTypes();
                    if (types.length != 0) {
                        int k = 0;
                        while (k < types.length) {
                            IInputType type = types[k];
                            CfgInfoContext c = new CfgInfoContext(rcInfo, tool, type);
                            this.contributeToConsoleParserList(project, map, c, workingDirectory, markerGenerator, collector, clParserList);
                            ++k;
                        }
                    } else {
                        CfgInfoContext c = new CfgInfoContext(rcInfo, tool, null);
                        this.contributeToConsoleParserList(project, map, c, workingDirectory, markerGenerator, collector, clParserList);
                    }
                    ++i;
                }
                ++q;
            }
        }
        if (clParserList.size() == 0) {
            this.contributeToConsoleParserList(project, map, new CfgInfoContext(cfg), workingDirectory, markerGenerator, collector, clParserList);
        }
        if (clParserList.size() != 0) {
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])clParserList.toArray(new IScannerInfoConsoleParser[clParserList.size()]));
        }
        return null;
    }

    private boolean contributeToConsoleParserList(IProject project, Map map, CfgInfoContext context, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector, List parserList) {
        IScannerConfigBuilderInfo2 info = (IScannerConfigBuilderInfo2)map.get(context);
        InfoContext ic = context.toInfoContext();
        boolean added = false;
        if (info != null && info.isAutoDiscoveryEnabled() && info.isBuildOutputParserEnabled()) {
            String id = info.getSelectedProfileId();
            ScannerConfigProfile profile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(id);
            if (profile.getBuildOutputProviderElement() != null) {
                SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic, id);
                IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                if (clParser != null) {
                    clParser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info.isProblemReportingEnabled() ? markerGenerator : null));
                    parserList.add(clParser);
                    added = true;
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean invokeMake(int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        boolean isClean = false;
        IProject currProject = bInfo.getProject();
        IBuilder builder = bInfo.getBuilder();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(ManagedMakeMessages.getResourceString("MakeBuilder.Invoking_Make_Builder")) + currProject.getName(), 100);
        try {
            try {
                IPath buildCommand = builder.getBuildCommand();
                if (buildCommand != null) {
                    QualifiedName qName;
                    Integer last;
                    IConsole console = bInfo.getConsole();
                    ConsoleOutputStream cos = console.getOutputStream();
                    StringBuffer buf = new StringBuffer();
                    String[] consoleHeader = new String[3];
                    switch (kind) {
                        case 6: 
                        case 9: 
                        case 10: {
                            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
                            break;
                        }
                        case 15: {
                            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_CLEAN);
                            break;
                        }
                    }
                    IConfiguration cfg = bInfo.getConfiguration();
                    consoleHeader[1] = cfg.getName();
                    consoleHeader[2] = currProject.getName();
                    buf.append(System.getProperty("line.separator", "\n"));
                    buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
                    buf.append(System.getProperty("line.separator", "\n"));
                    buf.append(System.getProperty("line.separator", "\n"));
                    if (!cfg.isSupported()) {
                        buf.append(ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{cfg.getName(), cfg.getToolChain().getName()}));
                        buf.append(System.getProperty("line.separator", "\n"));
                        buf.append(System.getProperty("line.separator", "\n"));
                    }
                    cos.write(buf.toString().getBytes());
                    cos.flush();
                    this.removeAllMarkers(currProject);
                    IPath workingDirectory = ManagedBuildManager.getBuildLocation(cfg, builder);
                    String[] targets = this.getTargets(kind, builder);
                    if (targets.length != 0 && targets[targets.length - 1].equals(builder.getCleanBuildTarget())) {
                        isClean = true;
                    }
                    String errMsg = null;
                    CommandLauncher launcher = new CommandLauncher();
                    launcher.showCommand(true);
                    String[] env = this.calcEnvironment(builder);
                    String[] buildArguments = targets;
                    String args = builder.getBuildArguments();
                    if (args != null && !(args = args.trim()).equals("")) {
                        String[] newArgs = this.makeArray(args);
                        buildArguments = new String[targets.length + newArgs.length];
                        System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                        System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                    }
                    if ((last = (Integer)currProject.getSessionProperty(qName = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "progressMonitor"))) == null) {
                        last = new Integer(100);
                    }
                    StreamMonitor streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)cos, last);
                    ErrorParserManager epm = new ErrorParserManager(currProject, workingDirectory, (IMarkerGenerator)this, builder.getErrorParsers());
                    epm.setOutputStream((OutputStream)streamMon);
                    OutputStream stdout = epm.getOutputStream();
                    OutputStream stderr = epm.getOutputStream();
                    ConsoleOutputSniffer sniffer = this.createBuildOutputSniffer(stdout, stderr, currProject, cfg, workingDirectory, (IMarkerGenerator)this, null);
                    OutputStream consoleOut = sniffer == null ? stdout : sniffer.getOutputStream();
                    OutputStream consoleErr = sniffer == null ? stderr : sniffer.getErrorStream();
                    Process p = launcher.execute(buildCommand, buildArguments, env, workingDirectory);
                    if (p != null) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        monitor.subTask(String.valueOf(ManagedMakeMessages.getResourceString("MakeBuilder.Invoking_Command")) + launcher.getCommandLine());
                        if (launcher.waitAndRead(consoleOut, consoleErr, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor.subTask(ManagedMakeMessages.getResourceString("MakeBuilder.Updating_project"));
                        try {
                            currProject.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    currProject.setSessionProperty(qName, !monitor.isCanceled() && !isClean ? new Integer(streamMon.getWorkDone()) : null);
                    if (errMsg != null) {
                        buf = new StringBuffer(String.valueOf(buildCommand.toString()) + " ");
                        int i = 0;
                        while (true) {
                            if (i >= buildArguments.length) {
                                String errorDesc = ManagedMakeMessages.getFormattedString("MakeBuilder.buildError", buf.toString());
                                buf = new StringBuffer(errorDesc);
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append("(").append(errMsg).append(")");
                                cos.write(buf.toString().getBytes());
                                cos.flush();
                                break;
                            }
                            buf.append(buildArguments[i]);
                            buf.append(' ');
                            ++i;
                        }
                    }
                    stdout.close();
                    stderr.close();
                    monitor.subTask(ManagedMakeMessages.getResourceString("MakeBuilder.Creating_Markers"));
                    consoleOut.close();
                    consoleErr.close();
                    epm.reportProblems();
                    cos.close();
                }
            }
            catch (Exception e) {
                CCorePlugin.log((Throwable)e);
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var31_35 = null;
        }
        monitor.done();
        return isClean;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 6: 
            case 10: {
                return info.isFullBuildEnabled() | info.isIncrementalBuildEnabled();
            }
            case 15: {
                return info.isCleanBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int kind, IBuilder builder) {
        String[] targetsArray = null;
        if (kind != 15 && !builder.isCustomBuilder() && builder.isManagedBuildOn()) {
            IConfiguration cfg = builder.getParent().getParent();
            String preBuildStep = cfg.getPrebuildStep();
            try {
                preBuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(preBuildStep, "", " ", 3, cfg);
            }
            catch (BuildMacroException buildMacroException) {}
            if (preBuildStep != null && preBuildStep.length() != 0) {
                targetsArray = new String[]{"pre-build", "main-build"};
            }
        }
        if (targetsArray == null) {
            String targets = "";
            switch (kind) {
                case 9: {
                    targets = builder.getAutoBuildTarget();
                    break;
                }
                case 6: 
                case 10: {
                    targets = builder.getIncrementalBuildTarget();
                    break;
                }
                case 15: {
                    targets = builder.getCleanBuildTarget();
                }
            }
            targetsArray = this.makeArray(targets);
        }
        return targetsArray;
    }

    String[] makeArray(String string) {
        String str;
        string = string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    boolean bl = inComment = !inComment;
                }
            }
            if (c == ' ' && !inComment) {
                String str2;
                if (buffer.length() > 0 && (str2 = buffer.toString().trim()).length() > 0) {
                    aList.add(str2);
                }
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0 && (str = buffer.toString().trim()).length() > 0) {
            aList.add(str);
        }
        return aList.toArray(new String[aList.size()]);
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }

    protected class BuildStatus {
        private boolean fManagedBuildOn;
        private boolean fRebuild;
        private boolean fBuild = true;
        private List fConsoleMessages = new ArrayList();
        private IManagedBuilderMakefileGenerator fMakeGen;

        public BuildStatus(IBuilder builder) {
            this.fManagedBuildOn = builder.isManagedBuildOn();
        }

        public void setRebuild() {
            this.fRebuild = true;
        }

        public boolean isRebuild() {
            return this.fRebuild;
        }

        public boolean isManagedBuildOn() {
            return this.fManagedBuildOn;
        }

        public boolean isBuild() {
            return this.fBuild;
        }

        public void cancelBuild() {
            this.fBuild = false;
        }

        public List getConsoleMessagesList() {
            return this.fConsoleMessages;
        }

        public IManagedBuilderMakefileGenerator getMakeGen() {
            return this.fMakeGen;
        }

        public void setMakeGen(IManagedBuilderMakefileGenerator makeGen) {
            this.fMakeGen = makeGen;
        }
    }

    private static class CfgBuildInfo {
        private IProject fProject;
        private IManagedBuildInfo fBuildInfo;
        private IConfiguration fCfg;
        private IBuilder fBuilder;
        private IConsole fConsole;
        private boolean fIsForeground;

        CfgBuildInfo(IBuilder builder, boolean isForegound) {
            this.fBuilder = builder;
            this.fCfg = builder.getParent().getParent();
            this.fIsForeground = isForegound;
            this.fProject = this.fCfg.getOwner().getProject();
            this.fBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.fProject);
        }

        public IProject getProject() {
            return this.fProject;
        }

        public IConsole getConsole() {
            if (this.fConsole == null) {
                this.fConsole = this.fIsForeground ? CCorePlugin.getDefault().getConsole() : new NullConsole();
                this.fConsole.start(this.fProject);
            }
            return this.fConsole;
        }

        public boolean isForeground() {
            return this.fIsForeground;
        }

        public IBuilder getBuilder() {
            return this.fBuilder;
        }

        public IConfiguration getConfiguration() {
            return this.fCfg;
        }

        public IManagedBuildInfo getBuildInfo() {
            return this.fBuildInfo;
        }
    }

    private static class CfgBuildSet {
        Map fMap = new HashMap();

        private CfgBuildSet() {
        }

        public Set getCfgIdSet(IProject project, boolean create) {
            HashSet set = (HashSet)this.fMap.get(project);
            if (set == null && create) {
                set = new HashSet();
                this.fMap.put(project, set);
            }
            return set;
        }

        public void start(CommonBuilder bld) {
            this.checkClean(bld);
        }

        private boolean checkClean(CommonBuilder bld) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (bld.hasBeenBuilt(projects[i])) {
                    if (VERBOSE) {
                        CommonBuilder.outputTrace(null, "checking clean: the project " + projects[i].getName() + " was built, no clean needed");
                    }
                    return false;
                }
                ++i;
            }
            if (VERBOSE) {
                CommonBuilder.outputTrace(null, "checking clean: no projects were built.. cleanning");
            }
            this.fMap.clear();
            return true;
        }
    }

    private static class NullConsole
    implements IConsole {
        private ConsoleOutputStream nullStream = new ConsoleOutputStream(this){
            final /* synthetic */ NullConsole this$1;
            {
                this.this$1 = nullConsole;
            }

            public void write(byte[] b) throws IOException {
            }

            public void write(byte[] b, int off, int len) throws IOException {
            }

            public void write(int c) throws IOException {
            }
        };

        private NullConsole() {
        }

        public void start(IProject project) {
        }

        public ConsoleOutputStream getOutputStream() {
            return this.nullStream;
        }

        public ConsoleOutputStream getInfoStream() {
            return this.nullStream;
        }

        public ConsoleOutputStream getErrorStream() {
            return this.nullStream;
        }
    }

    private static class OtherConfigVerifier
    implements IResourceDeltaVisitor {
        IBuilder[] builders;
        IPath[] buildFullPaths;
        IConfiguration[] allConfigs;
        Configuration[] otherConfigs;
        int resourceChangeState;
        private static final IPath[] ignoreList = new IPath[]{new Path(".cdtproject"), new Path(".cproject"), new Path(".cdtbuild"), new Path(".settings")};

        OtherConfigVerifier(IBuilder[] builders, IConfiguration[] allCfgs) {
            this.builders = builders;
            this.allConfigs = allCfgs;
            HashSet<IConfiguration> buildCfgSet = new HashSet<IConfiguration>();
            int i = 0;
            while (i < builders.length) {
                buildCfgSet.add(builders[i].getParent().getParent());
                ++i;
            }
            List othersList = ListComparator.getAdded((Object[])allCfgs, (Object[])buildCfgSet.toArray());
            this.otherConfigs = othersList != null ? othersList.toArray(new Configuration[othersList.size()]) : new Configuration[0];
            ArrayList<IPath> list = new ArrayList<IPath>(builders.length);
            int i2 = 0;
            while (i2 < builders.length) {
                IPath path = ManagedBuildManager.getBuildFullPath(builders[i2].getParent().getParent(), builders[i2]);
                if (path != null) {
                    list.add(path);
                }
                ++i2;
            }
            this.buildFullPaths = list.toArray(new IPath[list.size()]);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource rc = delta.getResource();
            if (rc.getType() == 1) {
                if (this.isResourceValuable(rc)) {
                    this.resourceChangeState |= delta.getKind();
                }
                return false;
            }
            if (!this.isResourceValuable(rc)) {
                return false;
            }
            int i = 0;
            while (i < this.buildFullPaths.length) {
                if (this.buildFullPaths[i].isPrefixOf(rc.getFullPath())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void updateOtherConfigs(IResourceDelta delta) {
            if (delta == null) {
                this.resourceChangeState = -1;
            } else {
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException coreException) {
                    this.resourceChangeState = -1;
                }
            }
            this.setResourceChangeStateForOtherConfigs();
        }

        private void setResourceChangeStateForOtherConfigs() {
            int i = 0;
            while (i < this.otherConfigs.length) {
                this.otherConfigs[i].addResourceChangeState(this.resourceChangeState);
                ++i;
            }
        }

        private boolean isResourceValuable(IResource rc) {
            IPath path = rc.getProjectRelativePath();
            int i = 0;
            while (i < ignoreList.length) {
                if (ignoreList[i].equals((Object)path)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private String buildGoalName;
        private IProject project;
        private IConfiguration cfg;
        private IConfiguration[] allConfigs;
        private IPath[] buildPaths;
        private boolean incrBuildNeeded = false;
        private boolean fullBuildNeeded = false;
        private List reservedNames;

        public ResourceDeltaVisitor(IConfiguration cfg, IConfiguration[] allConfigs) {
            this.cfg = cfg;
            this.project = cfg.getOwner().getProject();
            this.allConfigs = allConfigs;
            this.buildPaths = new IPath[allConfigs.length];
            int i = 0;
            while (i < this.buildPaths.length) {
                this.buildPaths[i] = ManagedBuildManager.getBuildFullPath(allConfigs[i], allConfigs[i].getBuilder());
                ++i;
            }
            String ext = cfg.getArtifactExtension();
            try {
                ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, cfg);
            }
            catch (BuildMacroException buildMacroException) {}
            String name = cfg.getArtifactName();
            try {
                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, cfg);
                resolved = resolved.trim();
                if (resolved.length() > 0) {
                    name = resolved;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            this.buildGoalName = ext.length() > 0 ? String.valueOf(cfg.getOutputPrefix(ext)) + name + "." + ext : name;
            this.reservedNames = Arrays.asList(".cdtbuild", ".cdtproject", ".project");
        }

        private boolean isGeneratedResource(IResource resource) {
            IPath path = resource.getFullPath();
            int i = 0;
            while (i < this.buildPaths.length) {
                if (this.buildPaths[i] != null && this.buildPaths[i].isPrefixOf(path)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isProjectFile(IResource resource) {
            return this.reservedNames.contains(resource.getName());
        }

        public boolean shouldBuildIncr() {
            return this.incrBuildNeeded;
        }

        public boolean shouldBuildFull() {
            return this.fullBuildNeeded;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == this.project) {
                switch (resource.getType()) {
                    case 1: {
                        String name = resource.getName();
                        if (name.equals(this.buildGoalName) || !resource.isDerived() && !this.isProjectFile(resource) && !this.isGeneratedResource(resource)) {
                            this.incrBuildNeeded = true;
                            if (delta.getKind() == 2) {
                                this.fullBuildNeeded = true;
                                break;
                            }
                        }
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

