/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.core.runtime.IPath;

public class ResourceInfoContainer {
    private PathSettingsContainer fRcDataContainer;
    private boolean fIncludeCurrent;
    static /* synthetic */ Class class$0;

    public ResourceInfoContainer(PathSettingsContainer pathSettings, boolean includeCurrent) {
        this.fRcDataContainer = pathSettings;
        this.fIncludeCurrent = includeCurrent;
    }

    public void changeCurrentPath(IPath path, boolean moveChildren) {
        this.fRcDataContainer.setPath(path, moveChildren);
    }

    public IPath getCurrentPath() {
        return this.fRcDataContainer.getPath();
    }

    public IResourceInfo getCurrentResourceInfo() {
        return (IResourceInfo)this.fRcDataContainer.getValue();
    }

    public IResourceInfo getResourceInfo(IPath path, boolean exactPath) {
        PathSettingsContainer cr = this.fRcDataContainer.getChildContainer(path, false, exactPath);
        if (cr != null) {
            return (IResourceInfo)cr.getValue();
        }
        return null;
    }

    public IResourceInfo[] getResourceInfos(Class clazz) {
        return this.getResourceInfos(12, clazz);
    }

    public IResourceInfo[] getResourceInfos() {
        return this.getResourceInfos(12);
    }

    public IResourceInfo[] getResourceInfos(int kind) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.IResourceInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getResourceInfos(kind, clazz);
    }

    public IResourceInfo[] getResourceInfos(int kind, Class clazz) {
        List list = this.getRcInfoList(kind);
        IResourceInfo[] datas = (IResourceInfo[])Array.newInstance(clazz, list.size());
        return list.toArray(datas);
    }

    public IResourceInfo[] getDirectChildResourceInfos() {
        PathSettingsContainer[] children = this.fRcDataContainer.getDirectChildren();
        IResourceInfo[] datas = new IResourceInfo[children.length];
        int i = 0;
        while (i < datas.length) {
            datas[i] = (IResourceInfo)children[i].getValue();
            ++i;
        }
        return datas;
    }

    public List getRcInfoList(int kind) {
        return this.getRcInfoList(kind, this.fIncludeCurrent);
    }

    public List getRcInfoList(final int kind, final boolean includeCurrent) {
        final ArrayList list = new ArrayList();
        this.fRcDataContainer.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                IResourceInfo data;
                if ((includeCurrent || container != ResourceInfoContainer.this.fRcDataContainer) && ((data = (IResourceInfo)container.getValue()).getKind() & kind) == data.getKind()) {
                    list.add(data);
                }
                return true;
            }
        });
        return list;
    }

    public IResourceInfo getResourceInfo(IPath path, boolean exactPath, int kind) {
        IResourceInfo data = this.getResourceInfo(path, exactPath);
        if (data != null && (data.getKind() & kind) == data.getKind()) {
            return data;
        }
        return null;
    }

    public void removeResourceInfo(IPath path) {
        this.fRcDataContainer.removeChildContainer(path);
    }

    public void addResourceInfo(IResourceInfo data) {
        PathSettingsContainer cr = this.fRcDataContainer.getChildContainer(data.getPath(), true, true);
        cr.setValue((Object)data);
    }

    public IFileInfo getFileInfo(IPath path) {
        return (IFileInfo)this.getResourceInfo(path, true, 8);
    }

    public IFolderInfo getFolderInfo(IPath path) {
        return (IFolderInfo)this.getResourceInfo(path, true, 4);
    }
}

