/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupMessages;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class AbsolutePathSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.absolutePath";

    private Object[] findSourceElementByFile(File file) {
        Object[] wfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getAbsolutePath()));
        if (wfiles.length > 0) {
            return wfiles;
        }
        try {
            ICProject project;
            String projectName;
            ILaunchConfiguration launchConfiguration;
            wfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getCanonicalPath()));
            if (wfiles.length > 0) {
                return wfiles;
            }
            ISourceLookupDirector director = this.getDirector();
            if (director != null && (launchConfiguration = director.getLaunchConfiguration()) != null && (projectName = launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "")).length() > 0 && (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null) {
                IPath path = Path.fromOSString((String)file.getCanonicalPath());
                String id = CoreModel.getRegistedContentTypeId((IProject)project.getProject(), (String)path.lastSegment());
                return new ExternalTranslationUnit[]{new ExternalTranslationUnit((ICElement)project, (IPath)new Path(file.getCanonicalPath()), id)};
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        return new LocalFileStorage[]{new LocalFileStorage(file)};
    }

    public boolean isValidAbsoluteFilePath(String name) {
        return this.isValidAbsoluteFilePath(new File(name));
    }

    public boolean isValidAbsoluteFilePath(File file) {
        return file.isAbsolute() && file.exists() && file.isFile();
    }

    public Object[] findSourceElements(String name) throws CoreException {
        File file;
        if (name != null && this.isValidAbsoluteFilePath(file = new File(name))) {
            return this.findSourceElementByFile(file);
        }
        return new Object[0];
    }

    public String getName() {
        return SourceLookupMessages.getString("AbsolutePathSourceContainer.0");
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }
}

