/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionDelta;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;

public final class CProjectDescriptionEvent {
    public static final int LOADDED = 1;
    public static final int ABOUT_TO_APPLY = 2;
    public static final int APPLIED = 4;
    public static final int COPY_CREATED = 8;
    public static final int DATA_APPLIED = 16;
    public static final int ALL = 31;
    private int fType;
    private ICProjectDescription fNewDescription;
    private ICProjectDescription fOldDescription;
    private ICProjectDescription fAppliedDescription;
    private ICDescriptionDelta fProjDelta;
    private ICDescriptionDelta fActiveCfgDelta;
    private ICDescriptionDelta fIndexCfgDelta;
    private IProject fProject;

    public CProjectDescriptionEvent(int type, ICDescriptionDelta delta, ICProjectDescription newDes, ICProjectDescription oldDes, ICProjectDescription appliedDes) {
        this.fType = type;
        this.fProjDelta = delta;
        this.fNewDescription = newDes;
        this.fOldDescription = oldDes;
        this.fAppliedDescription = appliedDes;
        if (this.fNewDescription != null) {
            this.fProject = this.fNewDescription.getProject();
        } else if (this.fOldDescription != null) {
            this.fProject = this.fOldDescription.getProject();
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public int getEventType() {
        return this.fType;
    }

    public ICDescriptionDelta getProjectDelta() {
        return this.fProjDelta;
    }

    public ICDescriptionDelta getActiveCfgDelta() {
        if (this.fActiveCfgDelta == null) {
            this.fActiveCfgDelta = this.getDelta(true);
        }
        return this.fActiveCfgDelta;
    }

    public ICDescriptionDelta getDefaultSettingCfgDelta() {
        if (this.fIndexCfgDelta == null) {
            this.fIndexCfgDelta = this.getDelta(false);
        }
        return this.fIndexCfgDelta;
    }

    private ICDescriptionDelta getDelta(boolean active) {
        ICDescriptionDelta delta = null;
        switch (this.getEventType()) {
            case 1: 
            case 2: 
            case 4: 
            case 16: {
                if (this.fProjDelta == null) break;
                ICProjectDescription oldDes = this.getOldCProjectDescription();
                ICProjectDescription newDes = this.getNewCProjectDescription();
                if (oldDes == null) {
                    ICConfigurationDescription cfg = this.getCfg(newDes, active);
                    if (cfg == null) break;
                    delta = this.findCfgDelta(this.fProjDelta, cfg.getId());
                    break;
                }
                if (newDes == null) {
                    ICConfigurationDescription cfg = this.getCfg(oldDes, active);
                    if (cfg == null) break;
                    delta = this.findCfgDelta(this.fProjDelta, cfg.getId());
                    break;
                }
                ICConfigurationDescription newCfg = this.getCfg(newDes, active);
                ICConfigurationDescription oldCfg = this.getCfg(oldDes, active);
                if (oldCfg == null) {
                    if (newCfg == null) break;
                    delta = new CProjectDescriptionDelta(newCfg, null);
                    break;
                }
                delta = newCfg == null ? new CProjectDescriptionDelta(null, oldCfg) : (newCfg.getId().equals(oldCfg.getId()) ? this.findCfgDelta(this.fProjDelta, newCfg.getId()) : CProjectDescriptionManager.getInstance().createDelta(newCfg, oldCfg));
            }
        }
        return delta;
    }

    private ICConfigurationDescription getCfg(ICProjectDescription des, boolean active) {
        return active ? des.getActiveConfiguration() : des.getDefaultSettingConfiguration();
    }

    private ICDescriptionDelta findCfgDelta(ICDescriptionDelta delta, String id) {
        if (delta == null) {
            return null;
        }
        ICDescriptionDelta[] children = delta.getChildren();
        int i = 0;
        while (i < children.length) {
            ICSettingObject s = children[i].getNewSetting();
            if (s != null && id.equals(s.getId())) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    public ICProjectDescription getOldCProjectDescription() {
        return this.fOldDescription;
    }

    public ICProjectDescription getNewCProjectDescription() {
        return this.fNewDescription;
    }

    public ICProjectDescription getAppliedCProjectDescription() {
        return this.fAppliedDescription;
    }
}

