/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.ICMacroFileEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

public class EntryStore {
    private KindBasedStore fStore = new KindBasedStore();
    private boolean fPreserveReadOnly;

    public EntryStore() {
        this(false);
    }

    public EntryStore(boolean preserveReadOnly) {
        this.fPreserveReadOnly = preserveReadOnly;
    }

    public EntryStore(EntryStore base, boolean preserveReadOnly) {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            ArrayList list = (ArrayList)this.fStore.get(kind);
            if (list != null) {
                this.fStore.put(kind, (ArrayList)list.clone());
            }
            ++i;
        }
        this.fPreserveReadOnly = preserveReadOnly;
    }

    public ICLanguageSettingEntry[] getEntries() {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < kinds.length) {
            List list = (List)this.fStore.get(kinds[i]);
            if (list != null) {
                result.addAll(list);
            }
            ++i;
        }
        return result.toArray(new ICLanguageSettingEntry[result.size()]);
    }

    public boolean containsEntriesList(int kind) {
        List list = this.getEntriesList(kind, false);
        return list != null;
    }

    public ICLanguageSettingEntry[] getEntries(int kind) {
        ArrayList list = this.getEntriesList(kind);
        if (list == null) {
            list = new ArrayList(0);
        }
        switch (kind) {
            case 1: {
                return list.toArray(new ICIncludePathEntry[list.size()]);
            }
            case 2: {
                return list.toArray(new ICIncludeFileEntry[list.size()]);
            }
            case 4: {
                return list.toArray(new ICMacroEntry[list.size()]);
            }
            case 8: {
                return list.toArray(new ICMacroFileEntry[list.size()]);
            }
            case 16: {
                return list.toArray(new ICLibraryPathEntry[list.size()]);
            }
            case 32: {
                return list.toArray(new ICLibraryFileEntry[list.size()]);
            }
        }
        throw new IllegalArgumentException();
    }

    public List getEntriesList(int kind) {
        List list = this.getEntriesList(kind, false);
        if (list != null) {
            return new ArrayList(list);
        }
        return new ArrayList(0);
    }

    private void setEntriesList(int kind, List list) {
        this.fStore.put(kind, list);
    }

    private List getEntriesList(int kind, boolean create) {
        ArrayList list = (ArrayList)this.fStore.get(kind);
        if (list == null && create) {
            list = new ArrayList();
            this.fStore.put(kind, list);
        }
        return list;
    }

    public void addEntry(int pos, ICLanguageSettingEntry entry) {
        List list = this.getEntriesList(entry.getKind(), true);
        if (pos >= list.size()) {
            list.add(entry);
        } else {
            list.add(pos, entry);
        }
    }

    public void addEntries(ICLanguageSettingEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            this.addEntry(entries[i]);
            ++i;
        }
    }

    public void storeEntries(int kind, ICLanguageSettingEntry[] entries) {
        this.storeEntries(kind, entries != null ? Arrays.asList(entries) : new ArrayList());
    }

    public void storeEntries(int kind, List list) {
        List oldList;
        ArrayList newList = new ArrayList(list);
        if (this.fPreserveReadOnly && (oldList = this.getEntriesList(kind, false)) != null) {
            Set ro = this.getReadOnlySet(oldList);
            ro.removeAll(newList);
            Iterator iter = oldList.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ro.contains(o)) continue;
                newList.add(o);
            }
        }
        this.setEntriesList(kind, newList);
    }

    private Set getReadOnlySet(List entries) {
        HashSet<ICSettingEntry> set = new HashSet<ICSettingEntry>();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            ICSettingEntry entry = (ICSettingEntry)iter.next();
            if (!entry.isReadOnly()) continue;
            set.add(entry);
        }
        return set;
    }

    public void addEntry(ICLanguageSettingEntry entry) {
        List list = this.getEntriesList(entry.getKind(), true);
        list.add(entry);
    }

    public void trimToSize() {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            ArrayList list = (ArrayList)this.fStore.get(kinds[i]);
            if (list != null) {
                list.trimToSize();
            }
            ++i;
        }
    }
}

