/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.model.CoreModelUtil;

public class PatternNameMap {
    private static final char[] SPEC_CHARS = new char[]{'*', '?'};
    static final String DOUBLE_STAR_PATTERN = "**";
    private Map fChildrenMap;
    private Map fPatternMap;
    private Collection fValues;
    private boolean fContainsDoubleStar;

    public Object get(String name) {
        return this.fChildrenMap != null ? this.fChildrenMap.get(name) : null;
    }

    public int size() {
        return this.fChildrenMap != null ? this.fChildrenMap.size() : 0;
    }

    public boolean isEmpty() {
        return this.fChildrenMap == null || this.fChildrenMap.isEmpty();
    }

    public boolean hasPatterns() {
        return this.fContainsDoubleStar || this.hasPatternsMap();
    }

    public boolean hasPatternsMap() {
        return this.fPatternMap != null && this.fPatternMap.size() != 0;
    }

    public List getValues(String name) {
        if (this.fChildrenMap == null) {
            return null;
        }
        Object val = this.fChildrenMap.get(name);
        if (this.hasPatternsMap()) {
            ArrayList list;
            if (val != null) {
                list = new ArrayList(3);
                list.add(val);
            } else {
                list = null;
            }
            char[] nameCharArray = name.toCharArray();
            Iterator iter = this.fPatternMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                StringCharArray strCA = (StringCharArray)entry.getKey();
                if (!CoreModelUtil.match(strCA.getCharArray(), nameCharArray, true)) continue;
                if (list == null) {
                    list = new ArrayList(2);
                }
                list.add(entry.getValue());
            }
            return list;
        }
        if (val != null) {
            ArrayList list = new ArrayList(1);
            list.add(val);
            return list;
        }
        return null;
    }

    public boolean containsDoubleStar() {
        return this.fContainsDoubleStar;
    }

    public Object put(String name, Object value) {
        Object oldValue;
        if (value == null) {
            return this.remove(name);
        }
        if (this.fChildrenMap == null) {
            this.fChildrenMap = new HashMap();
            oldValue = null;
        } else {
            oldValue = this.fChildrenMap.get(name);
        }
        this.fChildrenMap.put(name, value);
        if (DOUBLE_STAR_PATTERN.equals(name)) {
            this.fContainsDoubleStar = true;
        } else if (PatternNameMap.isPatternName(name)) {
            StringCharArray strCA = new StringCharArray(name);
            if (this.fPatternMap == null) {
                this.fPatternMap = new HashMap();
            }
            this.fPatternMap.put(strCA, value);
        }
        return oldValue;
    }

    public Object remove(String name) {
        if (this.fChildrenMap != null) {
            Object oldVal = this.fChildrenMap.remove(name);
            if (this.fChildrenMap.size() == 0) {
                this.fChildrenMap = null;
                this.fPatternMap = null;
                this.fContainsDoubleStar = false;
            } else if (DOUBLE_STAR_PATTERN.equals(name)) {
                this.fContainsDoubleStar = false;
            } else {
                this.removePattern(name);
            }
            return oldVal;
        }
        return null;
    }

    private void removePattern(String name) {
        if (this.fPatternMap != null) {
            this.fPatternMap.remove(new StringCharArray(name));
            if (this.fPatternMap.size() == 0) {
                this.fPatternMap = null;
            }
        }
    }

    private static boolean hasSpecChars(String str) {
        int i = 0;
        while (i < SPEC_CHARS.length) {
            if (str.indexOf(SPEC_CHARS[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPatternName(String str) {
        return PatternNameMap.hasSpecChars(str);
    }

    public void clear() {
        this.fChildrenMap = null;
        this.fPatternMap = null;
        this.fContainsDoubleStar = false;
    }

    public Collection values() {
        if (this.fValues == null) {
            this.fValues = new ValuesCollection();
        }
        return this.fValues;
    }

    private class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class StringCharArray {
        private String fString;
        private char[] fCharArray;

        StringCharArray(String string) {
            this.fString = string;
        }

        char[] getCharArray() {
            if (this.fCharArray == null) {
                this.fCharArray = this.fString.toCharArray();
            }
            return this.fCharArray;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StringCharArray)) {
                return false;
            }
            return this.fString.equals(((StringCharArray)obj).fString);
        }

        public int hashCode() {
            return this.fString.hashCode();
        }

        public String toString() {
            return this.fString;
        }
    }

    private class ValuesCollection
    extends AbstractCollection {
        private ValuesCollection() {
        }

        public Iterator iterator() {
            return PatternNameMap.this.fChildrenMap != null ? new Iter(PatternNameMap.this.fChildrenMap.entrySet().iterator()) : new EmptyIterator();
        }

        public int size() {
            return PatternNameMap.this.size();
        }

        public void clear() {
            PatternNameMap.this.clear();
        }

        public boolean contains(Object o) {
            return PatternNameMap.this.fChildrenMap != null ? PatternNameMap.this.fChildrenMap.containsValue(o) : false;
        }

        private class Iter
        implements Iterator {
            private Iterator fEntrySetIter;
            private Map.Entry fCur;

            Iter(Iterator entryIter) {
                this.fEntrySetIter = entryIter;
            }

            public boolean hasNext() {
                return this.fEntrySetIter.hasNext();
            }

            public Object next() {
                this.fCur = (Map.Entry)this.fEntrySetIter.next();
                return this.fCur.getValue();
            }

            public void remove() {
                this.fEntrySetIter.remove();
                String name = (String)this.fCur.getKey();
                if (PatternNameMap.DOUBLE_STAR_PATTERN.equals(name)) {
                    PatternNameMap.this.fContainsDoubleStar = false;
                } else {
                    PatternNameMap.this.removePattern(name);
                }
            }
        }
    }
}

