/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.process.ConditionalProcessGroup;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Element;

public class TemplateProcessHandler {
    private TemplateCore template;
    private List conditionalProcessGroupList;

    public TemplateProcessHandler(TemplateCore template) {
        this.template = template;
        this.initialize();
    }

    private void initialize() {
        TemplateDescriptor desc = this.template.getTemplateDescriptor();
        Element root = desc.getRootElement();
        this.conditionalProcessGroupList = new ArrayList();
        List nodeList = TemplateEngine.getChildrenOfElementByTag(root, "if");
        int j = 0;
        int l = nodeList.size();
        while (j < l) {
            this.conditionalProcessGroupList.add(new ConditionalProcessGroup(this.template, (Element)nodeList.get(j), j + 1));
            ++j;
        }
        nodeList = TemplateEngine.getChildrenOfElementByTag(root, "process");
        this.conditionalProcessGroupList.add(new ConditionalProcessGroup(this.template, nodeList.toArray(new Element[nodeList.size()])));
    }

    public IStatus[] processAll(IProgressMonitor monitor) throws ProcessFailureException {
        ArrayList allStatuses = new ArrayList();
        Iterator i = this.conditionalProcessGroupList.iterator();
        while (i.hasNext()) {
            try {
                allStatuses.addAll(((ConditionalProcessGroup)i.next()).process(monitor));
            }
            catch (ProcessFailureException e) {
                throw new ProcessFailureException(e.getMessage(), e, allStatuses);
            }
        }
        return allStatuses.toArray(new IStatus[allStatuses.size()]);
    }

    public Set getAllMacros() {
        HashSet set = new HashSet();
        Iterator i = this.conditionalProcessGroupList.iterator();
        while (i.hasNext()) {
            Set subSet = ((ConditionalProcessGroup)i.next()).getAllMacros();
            if (subSet == null) continue;
            set.addAll(subSet);
        }
        return set;
    }
}

