/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IMacroCollector;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.CodeReaderCache;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.core.runtime.Preferences;

public class SavedCodeReaderFactory
implements ICodeReaderFactory {
    private ICodeReaderCache cache = null;
    private static SavedCodeReaderFactory instance = new SavedCodeReaderFactory();

    public static SavedCodeReaderFactory getInstance() {
        return instance;
    }

    private SavedCodeReaderFactory() {
        int size = 0;
        Preferences pluginPreferences = CCorePlugin.getDefault().getPluginPreferences();
        size = CCorePlugin.getDefault() == null || pluginPreferences == null ? 64 : pluginPreferences.getInt("org.eclipse.cdt.core.codeReaderCache");
        if (size > 0) {
            this.cache = new CodeReaderCache(size);
        } else if (size == 0) {
            String[] properties = pluginPreferences.propertyNames();
            boolean found = false;
            int j = 0;
            while (j < properties.length) {
                if (properties[j].equals("org.eclipse.cdt.core.codeReaderCache")) {
                    found = true;
                    break;
                }
                ++j;
            }
            this.cache = !found && size == 0 ? new CodeReaderCache(64) : new CodeReaderCache(0);
        } else {
            this.cache = new CodeReaderCache(64);
        }
    }

    public int getUniqueIdentifier() {
        return 0;
    }

    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return this.cache.get(path);
    }

    public CodeReader createCodeReaderForTranslationUnit(ITranslationUnit tu) {
        return new CodeReader(tu.getResource().getLocation().toOSString(), tu.getContents());
    }

    public CodeReader createCodeReaderForInclusion(IMacroCollector scanner, String path) {
        return this.cache.get(path);
    }

    public ICodeReaderCache getCodeReaderCache() {
        return this.cache;
    }
}

