/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public abstract class ASTNode
implements IASTNode {
    private static final IASTNodeLocation[] EMPTY_LOCATION_ARRAY = new IASTNodeLocation[0];
    private IASTNode parent;
    private ASTNodeProperty property;
    private int length;
    private int offset;
    private IASTNodeLocation[] locations = null;
    private IASTFileLocation fileLocation = null;

    public IASTNode getParent() {
        return this.parent;
    }

    public void setParent(IASTNode node) {
        this.parent = node;
    }

    public ASTNodeProperty getPropertyInParent() {
        return this.property;
    }

    public void setPropertyInParent(ASTNodeProperty property) {
        this.property = property;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.locations = null;
    }

    public void setLength(int length) {
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(ASTNode node) {
        this.setOffsetAndLength(node.getOffset(), node.getLength());
    }

    public IASTNodeLocation[] getNodeLocations() {
        if (this.locations != null) {
            return this.locations;
        }
        if (this.length == 0) {
            return EMPTY_LOCATION_ARRAY;
        }
        this.locations = this.getTranslationUnit().getLocationInfo(this.offset, this.length);
        return this.locations;
    }

    public String getRawSignature() {
        return this.getTranslationUnit().getUnpreprocessedSignature(this.getNodeLocations());
    }

    public String getContainingFilename() {
        return this.getTranslationUnit().getContainingFilename(this.offset);
    }

    public IASTFileLocation getFileLocation() {
        if (this.fileLocation != null) {
            return this.fileLocation;
        }
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null) {
            this.fileLocation = ast.flattenLocationsToFile(this.getNodeLocations());
        }
        return this.fileLocation;
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.parent != null ? this.parent.getTranslationUnit() : null;
    }

    public boolean accept(ASTVisitor visitor) {
        return true;
    }

    public boolean contains(IASTNode node) {
        if (node instanceof ASTNode) {
            ASTNode astNode = (ASTNode)node;
            return this.offset <= astNode.offset && astNode.offset + astNode.length <= this.offset + this.length;
        }
        return false;
    }
}

