/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CPPEnumerator
extends PlatformObject
implements IEnumerator,
ICPPInternalBinding {
    private IASTName enumName;

    public CPPEnumerator(IASTName enumerator) {
        this.enumName = enumerator;
        enumerator.setBinding(this);
    }

    public IASTNode[] getDeclarations() {
        return null;
    }

    public IASTNode getDefinition() {
        return this.enumName;
    }

    public void removeDeclaration(IASTNode node) {
    }

    public String getName() {
        return this.enumName.toString();
    }

    public char[] getNameCharArray() {
        return this.enumName.toCharArray();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.enumName);
    }

    public IASTNode getPhysicalNode() {
        return this.enumName;
    }

    public IType getType() {
        IASTEnumerationSpecifier.IASTEnumerator etor = (IASTEnumerationSpecifier.IASTEnumerator)this.enumName.getParent();
        IASTEnumerationSpecifier enumSpec = (IASTEnumerationSpecifier)etor.getParent();
        IEnumeration enumeration = (IEnumeration)enumSpec.getName().resolveBinding();
        return enumeration;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPEnumeratorDelegate(name, this);
    }

    public void addDefinition(IASTNode node) {
    }

    public void addDeclaration(IASTNode node) {
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public static class CPPEnumeratorDelegate
    extends CPPDelegate
    implements IEnumerator {
        public CPPEnumeratorDelegate(IASTName name, IEnumerator binding) {
            super(name, binding);
        }

        public IType getType() throws DOMException {
            return ((IEnumerator)this.getBinding()).getType();
        }
    }
}

