/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CPPPointerToMemberType
extends CPPPointerType
implements ICPPPointerToMemberType {
    private ICPPASTPointerToMember operator = null;
    private ICPPClassType clsType = null;

    public CPPPointerToMemberType(IType type, ICPPASTPointerToMember operator) {
        super(type, operator);
        this.operator = operator;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef || o instanceof IIndexType) {
            return o.isSameType(this);
        }
        if (!super.isSameType(o)) {
            return false;
        }
        if (!(o instanceof CPPPointerToMemberType)) {
            return false;
        }
        CPPPointerToMemberType pt = (CPPPointerToMemberType)o;
        ICPPClassType cls = pt.getMemberOfClass();
        if (cls != null) {
            return cls.isSameType(this.getMemberOfClass());
        }
        return false;
    }

    public ICPPClassType getMemberOfClass() {
        if (this.clsType == null) {
            IBinding binding;
            ICPPASTPointerToMember pm = this.operator;
            IASTName name = pm.getName();
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                name = ns.length > 1 ? ns[ns.length - 2] : ns[ns.length - 1];
            }
            this.clsType = (binding = name.resolveBinding()) instanceof ICPPClassType ? (ICPPClassType)binding : new CPPClassType.CPPClassTypeProblem(name, 5, name.toCharArray());
        }
        return this.clsType;
    }
}

