/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CPPVariable
extends PlatformObject
implements ICPPVariable,
ICPPInternalBinding {
    private IASTName[] declarations = null;
    private IASTName definition = null;
    private IType type = null;
    static /* synthetic */ Class class$0;

    public CPPVariable(IASTName name) {
        boolean isDef = this.isDefinition(name);
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        if (isDef) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
    }

    protected boolean isDefinition(IASTName name) {
        IASTDeclarator dtor = this.findDeclarator(name);
        if (dtor == null) {
            return false;
        }
        IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)dtor.getParent();
        IASTDeclSpecifier declSpec = simpleDecl.getDeclSpecifier();
        if (dtor.getInitializer() == null && declSpec.getStorageClass() == 2) {
            return false;
        }
        return !(simpleDecl.getParent() instanceof ICPPASTCompositeTypeSpecifier) || declSpec.getStorageClass() != 3;
    }

    private IASTDeclarator findDeclarator(IASTName name) {
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTQualifiedName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        IASTDeclarator dtor = (IASTDeclarator)node;
        while (dtor.getParent() instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)dtor.getParent();
        }
        return dtor;
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.isDefinition(name)) {
            this.definition = name;
        } else if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
        } else if (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.prepend(clazz, this.declarations, name);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.append(clazz, this.declarations, name);
        }
    }

    public void removeDeclaration(IASTNode node) {
        if (node == this.definition) {
            this.definition = null;
            return;
        }
        ArrayUtil.remove(this.declarations, node);
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public IType getType() {
        if (this.type == null) {
            IASTName n = null;
            if (this.definition != null) {
                n = this.definition;
            } else if (this.declarations != null && this.declarations.length > 0) {
                n = this.declarations[0];
            }
            if (n != null) {
                while (n.getParent() instanceof IASTName) {
                    n = (IASTName)n.getParent();
                }
                IASTNode node = n.getParent();
                if (node instanceof IASTDeclarator) {
                    this.type = CPPVisitor.createType((IASTDeclarator)node);
                }
            }
        }
        return this.type;
    }

    public String getName() {
        if (this.declarations != null) {
            return this.declarations[0].toString();
        }
        IASTName name = this.definition;
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        return name.toString();
    }

    public char[] getNameCharArray() {
        if (this.declarations != null) {
            return this.declarations[0].toCharArray();
        }
        IASTName name = this.definition;
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        return name.toCharArray();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.definition != null ? this.definition : this.declarations[0]);
    }

    public boolean isStatic() {
        IASTDeclarator dtor = null;
        dtor = this.declarations != null ? this.findDeclarator(this.declarations[0]) : this.findDeclarator(this.definition);
        if (dtor == null) {
            return false;
        }
        IASTNode node = dtor.getParent();
        if (node instanceof IASTSimpleDeclaration) {
            IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)node).getDeclSpecifier();
            return declSpec.getStorageClass() == 3;
        }
        return false;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPVariableDelegate(name, this);
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            IASTDeclSpecifier declSpec;
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTSimpleDeclaration) || (declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier()).getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public static class CPPVariableDelegate
    extends CPPDelegate
    implements ICPPVariable {
        public CPPVariableDelegate(IASTName name, ICPPVariable binding) {
            super(name, binding);
        }

        public IType getType() throws DOMException {
            return ((ICPPVariable)this.getBinding()).getType();
        }

        public boolean isStatic() throws DOMException {
            return ((ICPPVariable)this.getBinding()).isStatic();
        }

        public boolean isMutable() throws DOMException {
            return ((ICPPVariable)this.getBinding()).isMutable();
        }

        public boolean isExtern() throws DOMException {
            return ((ICPPVariable)this.getBinding()).isExtern();
        }

        public boolean isAuto() throws DOMException {
            return ((ICPPVariable)this.getBinding()).isAuto();
        }

        public boolean isRegister() throws DOMException {
            return ((ICPPVariable)this.getBinding()).isRegister();
        }
    }

    public static class CPPVariableProblem
    extends ProblemBinding
    implements ICPPVariable {
        public CPPVariableProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }
    }
}

