/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.Messages;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.cdt.internal.core.index.composite.c.CCompositesFactory;
import org.eclipse.cdt.internal.core.index.composite.cpp.CPPCompositesFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CIndex
implements IIndex {
    private static final boolean SPECIALCASE_SINGLES = true;
    private final IIndexFragment[] fFragments;
    private final int fPrimaryFragmentCount;
    private int fReadLock;
    private ICompositesFactory cppCF;
    private ICompositesFactory cCF;
    private ICompositesFactory fCF;

    public CIndex(IIndexFragment[] fragments, int primaryFragmentCount) {
        this.fFragments = fragments;
        this.fPrimaryFragmentCount = primaryFragmentCount;
    }

    public CIndex(IIndexFragment[] fragments) {
        this(fragments, fragments.length);
    }

    public IIndexBinding findBinding(IName name) throws CoreException {
        if (name instanceof IIndexFragmentName) {
            return this.adaptBinding(((IIndexFragmentName)name).getBinding());
        }
        if (name instanceof IASTName) {
            if (this.fFragments.length == 1) {
                return this.fFragments[0].findBinding((IASTName)name);
            }
            int i = 0;
            while (i < this.fPrimaryFragmentCount) {
                IIndexFragmentBinding binding = this.fFragments[i].findBinding((IASTName)name);
                if (binding != null) {
                    return this.getCompositesFactory(binding.getLinkage().getID()).getCompositeBinding(binding);
                }
                ++i;
            }
        }
        return null;
    }

    public IIndexBinding[] findBindings(Pattern pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new Pattern[]{pattern}, isFullyQualified, filter, monitor);
    }

    public IIndexBinding[] findBindings(Pattern[] patterns, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findBindings(patterns, isFullyQualified, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] linkages = Linkage.getAllLinkages();
        int j = 0;
        while (j < linkages.length) {
            if (filter.acceptLinkage(linkages[j])) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fPrimaryFragmentCount][];
                int i = 0;
                while (i < this.fPrimaryFragmentCount) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindings(patterns, isFullyQualified, this.retargetFilter(linkages[j], filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkages[j].getID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++j;
        }
        return this.flatten(result);
    }

    public IIndexName[] findNames(IBinding binding, int flags) throws CoreException {
        LinkedList<IIndexFragmentName> result = new LinkedList<IIndexFragmentName>();
        int fragCount = 0;
        int i = 0;
        while (i < this.fPrimaryFragmentCount) {
            IIndexFragmentName[] names;
            IIndexFragmentBinding adaptedBinding = this.fFragments[i].adaptBinding(binding);
            if (adaptedBinding != null && (names = this.fFragments[i].findNames(adaptedBinding, flags)).length > 0) {
                result.addAll(Arrays.asList(names));
                ++fragCount;
            }
            ++i;
        }
        if (fragCount > 1) {
            HashMap<String, IIndexFile> fileMap = new HashMap<String, IIndexFile>();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                IIndexFragmentName name = (IIndexFragmentName)iterator.next();
                IIndexFile file = name.getFile();
                String fileKey = name.getFile().getLocation().getURI().toString();
                IIndexFile otherFile = (IIndexFile)fileMap.get(fileKey);
                if (otherFile == null) {
                    fileMap.put(fileKey, file);
                    continue;
                }
                if (otherFile.equals(file)) continue;
                iterator.remove();
            }
        }
        return result.toArray(new IIndexName[result.size()]);
    }

    public IIndexName[] findDeclarations(IBinding binding) throws CoreException {
        return this.findNames(binding, 3);
    }

    public IIndexName[] findDefinitions(IBinding binding) throws CoreException {
        return this.findNames(binding, 2);
    }

    public IIndexName[] findReferences(IBinding binding) throws CoreException {
        return this.findNames(binding, 4);
    }

    public IIndexFile getFile(IIndexFileLocation location) throws CoreException {
        IIndexFragmentFile result = null;
        IIndexFragmentFile backup = null;
        int i = 0;
        while (result == null && i < this.fPrimaryFragmentCount) {
            IIndexFragmentFile candidate = this.fFragments[i].getFile(location);
            if (candidate != null) {
                if (candidate.hasNames()) {
                    result = candidate;
                }
                if (backup == null) {
                    backup = candidate;
                }
            }
            ++i;
        }
        return result == null ? backup : result;
    }

    public IIndexFile resolveInclude(IIndexInclude include) throws CoreException {
        IIndexFragmentFile result;
        if (!include.isResolved()) {
            return null;
        }
        IIndexFragmentInclude fragmentInclude = (IIndexFragmentInclude)include;
        IIndexFragment frag = fragmentInclude.getFragment();
        if (this.isPrimaryFragment(frag) && (result = fragmentInclude.getIncludes()) != null) {
            return result;
        }
        IIndexFileLocation location = include.getIncludesLocation();
        int i = 0;
        while (i < this.fPrimaryFragmentCount) {
            IIndexFragmentFile result2;
            IIndexFragment otherFrag = this.fFragments[i];
            if (otherFrag != frag && (result2 = otherFrag.getFile(location)) != null) {
                return result2;
            }
            ++i;
        }
        return null;
    }

    public IIndexInclude[] findIncludedBy(IIndexFile file) throws CoreException {
        return this.findIncludedBy(file, 0);
    }

    public IIndexInclude[] findIncludedBy(IIndexFile file, int depth) throws CoreException {
        ArrayList result = new ArrayList();
        this.findIncludedBy(Collections.singletonList(file), result, depth, new HashSet());
        return result.toArray(new IIndexInclude[result.size()]);
    }

    public void findIncludedBy(List in, List out, int depth, HashSet handled) throws CoreException {
        LinkedList<IIndexFile> nextLevel = depth != 0 ? new LinkedList<IIndexFile>() : null;
        Iterator it = in.iterator();
        while (it.hasNext()) {
            IIndexFragmentFile file = (IIndexFragmentFile)it.next();
            int j = 0;
            while (j < this.fPrimaryFragmentCount) {
                IIndexFragmentInclude[] includedBy = this.fFragments[j].findIncludedBy(file);
                int k = 0;
                while (k < includedBy.length) {
                    IIndexFragmentInclude include = includedBy[k];
                    if (handled.add(include.getIncludedByLocation())) {
                        out.add(include);
                        if (depth != 0) {
                            nextLevel.add(include.getIncludedBy());
                        }
                    }
                    ++k;
                }
                ++j;
            }
        }
        if (depth == 0 || nextLevel.isEmpty()) {
            return;
        }
        if (depth > 0) {
            --depth;
        }
        this.findIncludedBy(nextLevel, out, depth, handled);
    }

    public IIndexInclude[] findIncludes(IIndexFile file) throws CoreException {
        return this.findIncludes(file, 0);
    }

    public IIndexInclude[] findIncludes(IIndexFile file, int depth) throws CoreException {
        ArrayList result = new ArrayList();
        this.findIncludes(Collections.singletonList(file), result, depth, new HashSet());
        return result.toArray(new IIndexInclude[result.size()]);
    }

    private void findIncludes(List in, List out, int depth, HashSet handled) throws CoreException {
        LinkedList<IIndexFile> nextLevel = depth != 0 ? new LinkedList<IIndexFile>() : null;
        Iterator it = in.iterator();
        while (it.hasNext()) {
            IIndexFragmentFile file = (IIndexFragmentFile)it.next();
            IIndexFragment frag = file.getIndexFragment();
            if (!this.isPrimaryFragment(frag)) continue;
            IIndexInclude[] includes = file.getIncludes();
            int k = 0;
            while (k < includes.length) {
                Object key;
                IIndexInclude include = includes[k];
                IIndexFileLocation target = include.getIncludesLocation();
                Object object = key = target != null ? target : include.getName();
                if (handled.add(key)) {
                    IIndexFile includedByFile;
                    out.add(include);
                    if (depth != 0 && (includedByFile = this.resolveInclude(include)) != null) {
                        nextLevel.add(includedByFile);
                    }
                }
                ++k;
            }
        }
        if (depth == 0 || nextLevel.isEmpty()) {
            return;
        }
        if (depth > 0) {
            --depth;
        }
        this.findIncludes(nextLevel, out, depth, handled);
    }

    /*
     * Exception decompiling
     */
    public synchronized void acquireReadLock() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void releaseReadLock() {
        if (--this.fReadLock == 0) {
            int i = 0;
            while (i < this.fFragments.length) {
                this.fFragments[i].releaseReadLock();
                ++i;
            }
        }
    }

    protected synchronized int getReadLockCount() {
        return this.fReadLock;
    }

    public long getLastWriteAccess() {
        long result = 0L;
        int i = 0;
        while (i < this.fFragments.length) {
            result = Math.max(result, this.fFragments[i].getLastWriteAccess());
            ++i;
        }
        return result;
    }

    public IIndexBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fFragments.length == 1) {
            try {
                return this.fFragments[0].findBindings(names, filter, monitor);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] linkages = Linkage.getAllLinkages();
        monitor.beginTask(Messages.CIndex_FindBindingsTask_label, this.fFragments.length * linkages.length);
        int j = 0;
        while (j < linkages.length) {
            if (filter.acceptLinkage(linkages[j])) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fPrimaryFragmentCount][];
                int i = 0;
                while (i < this.fPrimaryFragmentCount) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindings(names, this.retargetFilter(linkages[j], filter), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkages[j].getID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++j;
        }
        monitor.done();
        return this.flatten(result);
    }

    public IIndexBinding adaptBinding(IBinding binding) {
        try {
            if (this.fFragments.length == 1) {
                return this.fFragments[0].adaptBinding(binding);
            }
            int i = 0;
            while (i < this.fPrimaryFragmentCount) {
                IIndexFragmentBinding adaptedBinding = this.fFragments[i].adaptBinding(binding);
                if (adaptedBinding != null) {
                    return this.getCompositesFactory(binding.getLinkage().getID()).getCompositeBinding(adaptedBinding);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return null;
    }

    public IIndexBinding[] findBindings(char[] name, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new char[][]{name}, filter, monitor);
    }

    private IIndexBinding[] flatten(List bindingArrays) {
        int size = 0;
        int i = 0;
        while (i < bindingArrays.size()) {
            size += ((IBinding[])bindingArrays.get(i)).length;
            ++i;
        }
        IIndexBinding[] result = new IIndexBinding[size];
        int offset = 0;
        int i2 = 0;
        while (i2 < bindingArrays.size()) {
            IBinding[] src = (IBinding[])bindingArrays.get(i2);
            System.arraycopy(src, 0, result, offset, src.length);
            offset += src.length;
            ++i2;
        }
        return result;
    }

    public IIndexFragment[] getPrimaryFragments() {
        IIndexFragment[] result = new IIndexFragment[this.fPrimaryFragmentCount];
        System.arraycopy(this.fFragments, 0, result, 0, this.fPrimaryFragmentCount);
        return result;
    }

    private boolean isPrimaryFragment(IIndexFragment frag) {
        int i = 0;
        while (i < this.fPrimaryFragmentCount) {
            if (frag == this.fFragments[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IIndexFragmentBinding[] findEquivalentBindings(IBinding binding) throws CoreException {
        ArrayList<IIndexFragmentBinding> result = new ArrayList<IIndexFragmentBinding>();
        int i = 0;
        while (i < this.fFragments.length) {
            IIndexFragmentBinding adapted = this.fFragments[i].adaptBinding(binding);
            if (adapted != null) {
                result.add(adapted);
            }
            ++i;
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    private ICompositesFactory getCompositesFactory(String linkageID) {
        if (linkageID.equals("C++")) {
            if (this.cppCF == null) {
                this.cppCF = new CPPCompositesFactory(new CIndex(this.fFragments, this.fFragments.length));
            }
            return this.cppCF;
        }
        if (linkageID.equals("C")) {
            if (this.cCF == null) {
                this.cCF = new CCompositesFactory(new CIndex(this.fFragments, this.fFragments.length));
            }
            return this.cCF;
        }
        if (linkageID.equals("Fortran")) {
            if (this.fCF == null) {
                this.fCF = new CCompositesFactory(new CIndex(this.fFragments, this.fFragments.length));
            }
            return this.fCF;
        }
        throw new CompositingNotImplementedError();
    }

    private IndexFilter retargetFilter(final ILinkage linkage, final IndexFilter filter) {
        return new IndexFilter(){

            public boolean acceptBinding(IBinding binding) throws CoreException {
                return filter.acceptBinding(binding);
            }

            public boolean acceptLinkage(ILinkage other) {
                return linkage.getID().equals(other.getID());
            }
        };
    }

    public IIndexBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findBindingsForPrefix(prefix, filescope, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] linkages = Linkage.getAllLinkages();
        int j = 0;
        while (j < linkages.length) {
            if (filter.acceptLinkage(linkages[j])) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fPrimaryFragmentCount][];
                int i = 0;
                while (i < this.fPrimaryFragmentCount) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindingsForPrefix(prefix, filescope, this.retargetFilter(linkages[j], filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkages[j].getID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++j;
        }
        return this.flatten(result);
    }

    public IIndexMacro[] findMacros(char[] name, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findMacros(name, false, true, filter, monitor);
    }

    public IIndexMacro[] findMacrosForPrefix(char[] name, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findMacros(name, true, false, filter, monitor);
    }

    private IIndexMacro[] findMacros(char[] name, boolean isPrefix, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fFragments.length == 1) {
            try {
                return this.fFragments[0].findMacros(name, isPrefix, caseSensitive, filter, monitor);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return IIndexMacro.EMPTY_INDEX_MACRO_ARRAY;
            }
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IIndexMacro> result = new ArrayList<IIndexMacro>();
        HashSet<IIndexFileLocation> handledIFLs = new HashSet<IIndexFileLocation>();
        monitor.beginTask(Messages.CIndex_FindBindingsTask_label, this.fFragments.length);
        int i = 0;
        while (i < this.fPrimaryFragmentCount) {
            HashSet<IIndexFile> allowedFiles = new HashSet<IIndexFile>();
            try {
                IIndexMacro[] macros = this.fFragments[i].findMacros(name, isPrefix, caseSensitive, filter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                int k = 0;
                while (k < macros.length) {
                    block12: {
                        IIndexMacro indexMacro;
                        block11: {
                            indexMacro = macros[k];
                            IIndexFile file = indexMacro.getFile();
                            if (allowedFiles.contains(file)) break block11;
                            if (!handledIFLs.add(file.getLocation())) break block12;
                            allowedFiles.add(file);
                        }
                        result.add(indexMacro);
                    }
                    ++k;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        monitor.done();
        return result.toArray(new IIndexMacro[result.size()]);
    }

    public long getCacheHits() {
        long result = 0L;
        int i = 0;
        while (i < this.fFragments.length) {
            result += this.fFragments[i].getCacheHits();
            ++i;
        }
        return result;
    }

    public long getCacheMisses() {
        long result = 0L;
        int i = 0;
        while (i < this.fFragments.length) {
            result += this.fFragments[i].getCacheMisses();
            ++i;
        }
        return result;
    }

    public void resetCacheCounters() {
        int i = 0;
        while (i < this.fFragments.length) {
            this.fFragments[i].resetCacheCounters();
            ++i;
        }
    }
}

