/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LanguageMappingStore {
    private static final String LANGUAGE_MAPPING_ID = "org.eclipse.cdt.core.language.mapping";
    private static final String PROJECT_MAPPINGS = "project-mappings";
    private static final String WORKSPACE_MAPPINGS = "workspace-mappings";
    private static final String CONTENT_TYPE_MAPPING = "content-type-mapping";
    private static final String FILE_MAPPING = "file-mapping";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_CONTENT_TYPE = "content-type";
    private static final String ATTRIBUTE_LANGUAGE = "language";
    private static final String ATTRIBUTE_CONFIGURATION = "configuration";

    public ProjectLanguageConfiguration decodeMappings(IProject project) throws CoreException {
        ProjectLanguageConfiguration config = new ProjectLanguageConfiguration();
        ICDescriptor descriptor = this.getProjectDescription(project);
        Element rootElement = descriptor.getProjectData(LANGUAGE_MAPPING_ID);
        if (rootElement == null) {
            return config;
        }
        NodeList mappingElements = rootElement.getElementsByTagName(PROJECT_MAPPINGS);
        if (mappingElements.getLength() > 0) {
            Element element = (Element)mappingElements.item(0);
            config.setContentTypeMappings(this.decodeProjectContentTypeMappings(element));
            config.setFileMappings(this.decodeFileMappings(element));
        }
        return config;
    }

    private Map decodeProjectContentTypeMappings(Element rootElement) {
        TreeMap decodedMappings = new TreeMap();
        NodeList mappingElements = rootElement.getElementsByTagName(CONTENT_TYPE_MAPPING);
        int j = 0;
        while (j < mappingElements.getLength()) {
            Element mapping = (Element)mappingElements.item(j);
            String configuration = mapping.getAttribute(ATTRIBUTE_CONFIGURATION);
            TreeMap<String, String> contentTypeMappings = (TreeMap<String, String>)decodedMappings.get(configuration);
            if (contentTypeMappings == null) {
                contentTypeMappings = new TreeMap<String, String>();
                decodedMappings.put(configuration, contentTypeMappings);
            }
            String contentType = mapping.getAttribute(ATTRIBUTE_CONTENT_TYPE);
            String language = mapping.getAttribute(ATTRIBUTE_LANGUAGE);
            contentTypeMappings.put(contentType, language);
            ++j;
        }
        return decodedMappings;
    }

    protected ICDescriptor getProjectDescription(IProject project) throws CoreException {
        return CCorePlugin.getDefault().getCProjectDescription(project, true);
    }

    private Map decodeContentTypeMappings(Element rootElement) throws CoreException {
        return this.decodeMappings(rootElement, CONTENT_TYPE_MAPPING, ATTRIBUTE_CONTENT_TYPE, ATTRIBUTE_LANGUAGE);
    }

    private Map decodeFileMappings(Element rootElement) throws CoreException {
        TreeMap decodedMappings = new TreeMap();
        NodeList mappingElements = rootElement.getElementsByTagName(FILE_MAPPING);
        int j = 0;
        while (j < mappingElements.getLength()) {
            Element mapping = (Element)mappingElements.item(j);
            String path = mapping.getAttribute(ATTRIBUTE_PATH);
            TreeMap<String, String> configurationMappings = (TreeMap<String, String>)decodedMappings.get(path);
            if (configurationMappings == null) {
                configurationMappings = new TreeMap<String, String>();
                decodedMappings.put(path, configurationMappings);
            }
            String configuration = mapping.getAttribute(ATTRIBUTE_CONFIGURATION);
            String language = mapping.getAttribute(ATTRIBUTE_LANGUAGE);
            configurationMappings.put(configuration, language);
            ++j;
        }
        return decodedMappings;
    }

    private Map decodeMappings(Element rootElement, String category, String keyName, String valueName) {
        TreeMap<String, String> decodedMappings = new TreeMap<String, String>();
        NodeList mappingElements = rootElement.getElementsByTagName(category);
        int j = 0;
        while (j < mappingElements.getLength()) {
            Element mapping = (Element)mappingElements.item(j);
            String key = mapping.getAttribute(keyName);
            String value = mapping.getAttribute(valueName);
            decodedMappings.put(key, value);
            ++j;
        }
        return decodedMappings;
    }

    public void storeMappings(IProject project, ProjectLanguageConfiguration config) throws CoreException {
        ICDescriptor descriptor = this.getProjectDescription(project);
        Element rootElement = descriptor.getProjectData(LANGUAGE_MAPPING_ID);
        this.clearChildren(rootElement);
        Document document = rootElement.getOwnerDocument();
        Element projectMappings = document.createElement(PROJECT_MAPPINGS);
        rootElement.appendChild(projectMappings);
        this.addProjectContentTypeMappings(config.getContentTypeMappings(), projectMappings);
        this.addFileMappings(config.getFileMappings(), projectMappings);
        descriptor.saveProjectData();
    }

    private void addProjectContentTypeMappings(Map contentTypeMappings, Element rootElement) {
        Document document = rootElement.getOwnerDocument();
        Iterator entries = contentTypeMappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String configuration = (String)entry.getKey();
            Iterator contentTypeEntries = ((Map)entry.getValue()).entrySet().iterator();
            while (contentTypeEntries.hasNext()) {
                Map.Entry configurationEntry = contentTypeEntries.next();
                String contentType = (String)configurationEntry.getKey();
                String language = (String)configurationEntry.getValue();
                Element mapping = document.createElement(CONTENT_TYPE_MAPPING);
                mapping.setAttribute(ATTRIBUTE_CONTENT_TYPE, contentType);
                mapping.setAttribute(ATTRIBUTE_CONFIGURATION, configuration);
                mapping.setAttribute(ATTRIBUTE_LANGUAGE, language);
                rootElement.appendChild(mapping);
            }
        }
    }

    public void storeMappings(WorkspaceLanguageConfiguration config) throws CoreException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement(WORKSPACE_MAPPINGS);
            doc.appendChild(rootElement);
            this.addContentTypeMappings(config.getWorkspaceMappings(), rootElement);
            Transformer serializer = this.createSerializer();
            DOMSource source = new DOMSource(doc);
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            serializer.transform(source, result);
            String encodedMappings = buffer.getBuffer().toString();
            Preferences node = CCorePlugin.getDefault().getPluginPreferences();
            node.setValue("org.eclipse.cdt.core.workspaceLanguageMappings", encodedMappings);
            CCorePlugin.getDefault().savePluginPreferences();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (TransformerException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public WorkspaceLanguageConfiguration decodeWorkspaceMappings() throws CoreException {
        Preferences node = CCorePlugin.getDefault().getPluginPreferences();
        String encodedMappings = node.getString("org.eclipse.cdt.core.workspaceLanguageMappings");
        WorkspaceLanguageConfiguration config = new WorkspaceLanguageConfiguration();
        if (encodedMappings == null || encodedMappings.length() == 0) {
            return config;
        }
        InputSource input = new InputSource(new StringReader(encodedMappings));
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            config.setWorkspaceMappings(this.decodeContentTypeMappings(document.getDocumentElement()));
            return config;
        }
        catch (SAXException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (IOException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    private Transformer createSerializer() throws CoreException {
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    private void clearChildren(Element element) {
        Node child = element.getFirstChild();
        while (child != null) {
            element.removeChild(child);
            child = element.getFirstChild();
        }
    }

    private void addMappings(Map mappings, Element rootElement, String category, String keyName, String valueName) {
        Document document = rootElement.getOwnerDocument();
        Iterator entries = mappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Element mapping = document.createElement(category);
            mapping.setAttribute(keyName, (String)entry.getKey());
            mapping.setAttribute(valueName, (String)entry.getValue());
            rootElement.appendChild(mapping);
        }
    }

    private void addContentTypeMappings(Map mappings, Element rootElement) {
        this.addMappings(mappings, rootElement, CONTENT_TYPE_MAPPING, ATTRIBUTE_CONTENT_TYPE, ATTRIBUTE_LANGUAGE);
    }

    private void addFileMappings(Map mappings, Element rootElement) {
        Document document = rootElement.getOwnerDocument();
        Iterator entries = mappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Element mapping = document.createElement(FILE_MAPPING);
            String path = (String)entry.getKey();
            Iterator configurationEntries = ((Map)entry.getValue()).entrySet().iterator();
            while (configurationEntries.hasNext()) {
                Map.Entry configurationEntry = configurationEntries.next();
                String configuration = (String)configurationEntry.getKey();
                String language = (String)configurationEntry.getValue();
                mapping.setAttribute(ATTRIBUTE_PATH, path);
                mapping.setAttribute(ATTRIBUTE_CONFIGURATION, configuration);
                mapping.setAttribute(ATTRIBUTE_LANGUAGE, language);
                rootElement.appendChild(mapping);
            }
        }
    }
}

